/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.project.Project;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public interface DatabaseConnectionPoint
extends RawConnectionConfig {
    @NotNull
    public Properties getConnectionProperties();

    public boolean isReadOnly();

    @NotNull
    public LocalDataSource getDataSource();

    @NotNull
    public Map<String, String> getAdditionalJdbcProperties();

    public DatabaseDriver getDatabaseDriver();

    public static class Adapter
    implements DatabaseConnectionPoint {
        private final DatabaseConnectionPoint myDelegate;

        public Adapter(DatabaseConnectionPoint delegate) {
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public Properties getConnectionProperties() {
            Properties properties = this.myDelegate.getConnectionProperties();
            if (properties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionPoint$Adapter", "getConnectionProperties"));
            }
            return properties;
        }

        @Override
        public boolean isReadOnly() {
            return this.myDelegate.isReadOnly();
        }

        @Override
        @NotNull
        public LocalDataSource getDataSource() {
            LocalDataSource localDataSource = this.myDelegate.getDataSource();
            if (localDataSource == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionPoint$Adapter", "getDataSource"));
            }
            return localDataSource;
        }

        @Override
        @NotNull
        public Map<String, String> getAdditionalJdbcProperties() {
            Map<String, String> map = this.myDelegate.getAdditionalJdbcProperties();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionPoint$Adapter", "getAdditionalJdbcProperties"));
            }
            return map;
        }

        @Override
        public DatabaseDriver getDatabaseDriver() {
            return this.myDelegate.getDatabaseDriver();
        }

        public String getName() {
            return this.myDelegate.getName();
        }

        public String getDriverClass() {
            return this.myDelegate.getDriverClass();
        }

        public String getUrl() {
            return this.myDelegate.getUrl();
        }

        public String getEffectiveUrl(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseConnectionPoint$Adapter", "getEffectiveUrl"));
            }
            return this.myDelegate.getEffectiveUrl(project);
        }
    }
}

