/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcModificationSession;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcValidator;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.impl.BlackHoleTextStorage;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.SimpleCompositeText;
import com.intellij.database.util.GuardedRef;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class DbSrcModelStorage
implements ModelTextStorage {
    private static final Logger LOG = Logger.getInstance(DbSrcModelStorage.class);
    private final DbDataSourceLayout myLayout;
    @Nullable
    private final Project myProject;
    private volatile DbSrcModificationSession myModSession;
    private final Alarm myInvalidUsageReporter;
    private static final int MESSAGE_DELAY = 500;

    private DbSrcModelStorage(@Nullable Project project, @NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "<init>"));
        }
        DbSrcStorage storage = DbSrcStorage.getInstance(project);
        this.myLayout = storage.getLayout(dataSourceId);
        this.myProject = project;
        this.myInvalidUsageReporter = AlarmFactory.getInstance().create(Alarm.ThreadToUse.SWING_THREAD, (Disposable)(project == null ? ApplicationManager.getApplication() : project));
    }

    @NotNull
    public GuardedRef startWriteSession(@NotNull BasicModel model, @Nullable TransactionId transactionId) {
        DbSrcModificationSession session;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "startWriteSession"));
        }
        if (this.myModSession != null) {
            LOG.warn("Parallel modification is forbidden");
        }
        this.myModSession = session = new DbSrcModificationSession(this.myProject, this.myLayout, transactionId);
        GuardedRef<DbSrcModificationSession> guardedRef = new GuardedRef<DbSrcModificationSession>(session){

            @Override
            protected void close(@NotNull DbSrcModificationSession ref) {
                if (ref == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage$1", "close"));
                }
                try {
                    session.waitForWriteFinished();
                }
                finally {
                    if (session == DbSrcModelStorage.this.myModSession) {
                        DbSrcModelStorage.this.myModSession = null;
                    }
                }
            }
        };
        if (guardedRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "startWriteSession"));
        }
        return guardedRef;
    }

    @Nullable
    private DbSrcModificationSession getModSession() {
        LOG.assertTrue(this.myModSession != null, (Object)"Session not started");
        return this.myModSession;
    }

    @Override
    public void save(@NotNull BasicSourceAware element, @Nullable CompositeText text) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "save"));
        }
        DbSrcModificationSession session = this.getModSession();
        if (session != null) {
            session.save(element, text);
        }
    }

    @Override
    public void queueDelete(@NotNull BasicSourceAware element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "queueDelete"));
        }
        DbSrcModificationSession session = this.getModSession();
        if (session != null) {
            session.queueDelete(element);
        }
    }

    @Override
    public void processDeleteQueue() {
        DbSrcModificationSession session = this.myModSession;
        if (session == null) {
            return;
        }
        session.beginWrite();
        session.endWrite();
    }

    @Override
    public void writeSession(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "writeSession"));
        }
        DbSrcModificationSession session = this.getModSession();
        if (session != null) {
            session.beginWrite();
            try {
                runnable.run();
            }
            finally {
                session.endWrite();
            }
        } else {
            runnable.run();
        }
    }

    @Override
    @Nullable
    public CompositeText load(@NotNull BasicSourceAware element) {
        boolean outdated;
        String text;
        CompositeText src;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "load"));
        }
        DbSrcModificationSession session = this.myModSession;
        CompositeText compositeText = src = session == null ? null : session.getTmpSource(element);
        if (src != null) {
            return src;
        }
        DbSrcPath srcPath = DbSrcPath.of(element);
        DbSrcStorageLayout.Item item = this.myLayout.getPath(srcPath, false);
        if (item == null) {
            return null;
        }
        if (session == null) {
            text = DbSrcFileStatus.getContent(item.getSrcFile());
        } else {
            if (item.getSrcAttributes() == null) {
                return null;
            }
            try (InputStream is = item.getInputStream();){
                text = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader(is, "UTF-8")));
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }
        if (text == null) {
            return null;
        }
        DbSrcStorageDsMetadata.MetaData md = this.myLayout.getMetaData(srcPath);
        BasicModel model = element.getModel();
        Rdbms rdbms = model == null ? UnknownDatabase.RDBMS : model.getRdbms();
        boolean bl = outdated = md != null && md.introContentVersion != DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(rdbms, element.getKind());
        if (outdated && session == null) {
            this.queueInvalidSourceUsageReport(element);
        }
        boolean noRanges = md == null || md.kinds == null || md.kinds.length == 0;
        return noRanges ? new SimpleCompositeText(text, CompositeText.Kind.ORIGINAL_TEXT) : new PersistentMarkup(text, md.offsets, md.kinds);
    }

    @Override
    public boolean hasExistingSources(@NotNull BasicElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "hasExistingSources"));
        }
        DbSrcPath srcPath = DbSrcPath.of(element);
        DbSrcStorageLayout.Item item = this.myLayout.getPath(srcPath, false);
        if (item == null) {
            return false;
        }
        if (item.hasChildren()) {
            return true;
        }
        if (!(element instanceof BasicSourceAware)) {
            return false;
        }
        return item.getSrcAttributes() != null;
    }

    @Override
    public Long getVersion(@NotNull BasicElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "getVersion"));
        }
        DbSrcPath srcPath = DbSrcPath.of(element);
        DbSrcStorageDsMetadata.MetaData data = this.myLayout.getMetaData(srcPath);
        return data == null ? null : data.srcVersion;
    }

    @Override
    public void setVersion(@NotNull BasicElement element, Long version) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "setVersion"));
        }
        DbSrcPath srcPath = DbSrcPath.of(element);
        DbSrcStorageDsMetadata.MetaData data = this.myLayout.getMetaData(srcPath);
        this.myLayout.putMetaData(srcPath, DbSrcStorageDsMetadata.MetaData.modSrcVersion(data, version));
    }

    @NotNull
    public static ModelFactory createFactory(@Nullable Project project, @NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "createFactory"));
        }
        ModelFactory modelFactory = DbSrcModelStorage.createFactory(dataSource.isGlobal() ? null : project, dataSource.getUniqueId());
        if (modelFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "createFactory"));
        }
        return modelFactory;
    }

    @NotNull
    public static ModelFactory createFactory(@Nullable Project project, @Nullable String dataSourceId) {
        ModelFactory modelFactory = new ModelFactory(DbSrcStorage.isEnabled() && dataSourceId != null ? new DbSrcModelStorage(project, dataSourceId) : BlackHoleTextStorage.INSTANCE);
        if (modelFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "createFactory"));
        }
        return modelFactory;
    }

    private void queueInvalidSourceUsageReport(@NotNull BasicSourceAware object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "queueInvalidSourceUsageReport"));
        }
        if (!DbSrcValidator.isEnabled()) {
            return;
        }
        this.myInvalidUsageReporter.cancelAllRequests();
        this.myInvalidUsageReporter.addRequest(this::reportInvalidSourceUsage, 500);
    }

    private void reportInvalidSourceUsage() {
        LocalDataSource dataSource = DbSrcUtils.findDataSource(this.myProject, this.myLayout.getDataSourceId());
        if (dataSource == null) {
            return;
        }
        Project project = this.myProject == null ? ProjectManager.getInstance().getDefaultProject() : this.myProject;
        DbSrcValidator.suggestIntrospecting(project, Collections.singletonList(dataSource));
    }
}

