/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcStorageDsMetadata
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DbSrcStorageDsMetadata.class);
    private final PersistentHashMap<DbSrcPath, MetaData> myObjects;

    public DbSrcStorageDsMetadata(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "<init>"));
        }
        this.myObjects = DbSrcStorageDsMetadata.createMapOrRecreate(file);
    }

    public void flush() {
        this.myObjects.force();
    }

    @NotNull
    private static PersistentHashMap<DbSrcPath, MetaData> createMapOrRecreate(@NotNull File file) throws IOException {
        PersistentHashMap<DbSrcPath, MetaData> persistentHashMap;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "createMapOrRecreate"));
        }
        try {
            FileUtil.createParentDirs((File)file.getParentFile());
            persistentHashMap = DbSrcStorageDsMetadata.createMap(file);
        }
        catch (PersistentEnumeratorBase.CorruptedException e) {
            FileUtil.delete((File)file);
            PersistentHashMap<DbSrcPath, MetaData> persistentHashMap2 = DbSrcStorageDsMetadata.createMap(file);
            if (persistentHashMap2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "createMapOrRecreate"));
            }
            return persistentHashMap2;
        }
        if (persistentHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "createMapOrRecreate"));
        }
        return persistentHashMap;
    }

    @NotNull
    private static PersistentHashMap<DbSrcPath, MetaData> createMap(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "createMap"));
        }
        PersistentHashMap persistentHashMap = new PersistentHashMap(file, (KeyDescriptor)new MyKeyDescriptor(), (DataExternalizer)new MyDataExternalizer(), 1024, 0, new PagedFileStorage.StorageLockContext(true));
        if (persistentHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "createMap"));
        }
        return persistentHashMap;
    }

    @Nullable
    public MetaData getMetaData(@NotNull DbSrcPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "getMetaData"));
        }
        try {
            return (MetaData)this.myObjects.get((Object)path);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void putMetaData(@NotNull DbSrcPath object, @Nullable MetaData data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata", "putMetaData"));
        }
        try {
            if (data == null || data.equals(MetaData.EMPTY)) {
                this.myObjects.remove((Object)object);
            } else {
                this.myObjects.put((Object)object, (Object)data);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void dispose() {
        try {
            this.myObjects.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static class MyDataExternalizer
    implements DataExternalizer<MetaData> {
        private static final byte DATA_VERSION = 3;
        private static final String OLD_KINDS = "_FODS;";

        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, MetaData value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$MyDataExternalizer", "save"));
            }
            out.write(3);
            out.writeBoolean(value.srcVersion != null);
            if (value.srcVersion != null) {
                out.writeLong(value.srcVersion);
            }
            out.writeInt(value.contentHash);
            out.writeInt(value.offsets == null ? 0 : value.offsets.length);
            if (value.offsets != null) {
                for (int offset : value.offsets) {
                    out.writeInt(offset);
                }
            }
            if (value.kinds != null) {
                for (char kind : value.kinds) {
                    out.writeChar(kind);
                }
            }
            out.writeInt(value.introContentVersion);
            out.writeInt(value.genContentVersion);
        }

        public MetaData read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$MyDataExternalizer", "read"));
            }
            byte ver = in.readByte();
            boolean srcVersionNotNull = ver < 2 ? ver == 1 : in.readBoolean();
            Long srcVersion = srcVersionNotNull ? Long.valueOf(in.readLong()) : null;
            int contentHash = in.readInt();
            if (ver < 2) {
                return new MetaData(srcVersion, contentHash, MetaData.EMPTY.offsets, MetaData.EMPTY.kinds, 0, 0);
            }
            int size = in.readInt();
            if (size > 100) {
                throw new IOException("Corrupted data format");
            }
            int[] offsets = null;
            char[] kinds = null;
            if (size != 0) {
                int i2;
                offsets = new int[size];
                kinds = new char[size];
                for (i2 = 0; i2 < offsets.length; ++i2) {
                    offsets[i2] = in.readInt();
                }
                for (i2 = 0; i2 < kinds.length; ++i2) {
                    kinds[i2] = ver == 2 ? MyDataExternalizer.getV2Char(in.readByte()) : in.readChar();
                }
            }
            if (ver < 3) {
                return new MetaData(srcVersion, contentHash, offsets, kinds, 0, 0);
            }
            int maj = in.readInt();
            int min = in.readInt();
            return new MetaData(srcVersion, contentHash, offsets, kinds, maj, min);
        }

        private static char getV2Char(byte ord) {
            return OLD_KINDS.charAt(ord >= 0 && ord < OLD_KINDS.length() ? (int)ord : 0);
        }
    }

    private static class MyKeyDescriptor
    implements KeyDescriptor<DbSrcPath> {
        private MyKeyDescriptor() {
        }

        public int getHashCode(DbSrcPath value) {
            return Comparing.hashcode((Object)value);
        }

        public boolean isEqual(DbSrcPath val1, DbSrcPath val2) {
            return Comparing.equal((Object)val1, (Object)val2);
        }

        public void save(@NotNull DataOutput out, DbSrcPath value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$MyKeyDescriptor", "save"));
            }
            int size = value.size();
            out.write(size);
            for (int i2 = 0; i2 < size; ++i2) {
                out.writeUTF(value.name(i2));
                out.writeUTF(value.kind(i2));
            }
            String d = value.getDisambiguator();
            out.writeBoolean(d != null);
            if (d != null) {
                out.writeUTF(d);
            }
        }

        public DbSrcPath read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$MyKeyDescriptor", "read"));
            }
            int size = in.readInt();
            if (size > 10) {
                throw new IOException("Corrupted key format");
            }
            ArrayList names = ContainerUtil.newArrayListWithCapacity((int)size);
            ArrayList kinds = ContainerUtil.newArrayListWithCapacity((int)size);
            for (int i2 = 0; i2 < size; ++i2) {
                names.add(DbUtil.intern((String)in.readUTF()));
                kinds.add(DbUtil.intern((String)in.readUTF()));
            }
            String disambiguator = in.readBoolean() ? in.readUTF() : null;
            return new DbSrcPath(names, kinds, disambiguator);
        }
    }

    public static final class MetaData {
        public static final MetaData EMPTY = new MetaData(null, 0, null, null, Integer.MIN_VALUE, Integer.MIN_VALUE);
        public final Long srcVersion;
        public final int contentHash;
        public final int[] offsets;
        public final char[] kinds;
        public final int introContentVersion;
        public final int genContentVersion;

        public MetaData(Long srcVersion, int contentHash, int[] offsets, char[] kinds, int introContentVersion, int genContentVersion) {
            this.srcVersion = srcVersion;
            this.contentHash = contentHash;
            this.offsets = offsets;
            this.kinds = kinds;
            this.introContentVersion = introContentVersion;
            this.genContentVersion = genContentVersion;
        }

        @NotNull
        public static MetaData modSrcVersion(@Nullable MetaData data, @Nullable Long srcVersion) {
            if (data == null) {
                data = EMPTY;
            }
            MetaData metaData = new MetaData(srcVersion, data.contentHash, data.offsets, data.kinds, data.introContentVersion, data.genContentVersion);
            if (metaData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$MetaData", "modSrcVersion"));
            }
            return metaData;
        }

        @NotNull
        public static MetaData modContentVersion(@Nullable MetaData data, int introVer, int genVer) {
            if (data == null) {
                data = EMPTY;
            }
            MetaData metaData = new MetaData(data.srcVersion, data.contentHash, data.offsets, data.kinds, introVer, genVer);
            if (metaData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageDsMetadata$MetaData", "modContentVersion"));
            }
            return metaData;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaData data = (MetaData)o;
            if (this.contentHash != data.contentHash) {
                return false;
            }
            if (this.srcVersion != null ? !this.srcVersion.equals(data.srcVersion) : data.srcVersion != null) {
                return false;
            }
            if (!Arrays.equals(this.offsets, data.offsets)) {
                return false;
            }
            if (!Arrays.equals(this.kinds, data.kinds)) {
                return false;
            }
            if (this.introContentVersion != data.introContentVersion) {
                return false;
            }
            return this.genContentVersion == data.genContentVersion;
        }

        public int hashCode() {
            int result2 = this.srcVersion != null ? this.srcVersion.hashCode() : 0;
            result2 = 31 * result2 + this.contentHash;
            result2 = 31 * result2 + Arrays.hashCode(this.offsets);
            result2 = 31 * result2 + Arrays.hashCode(this.kinds);
            result2 = 31 * result2 + this.introContentVersion;
            result2 = 31 * result2 + this.genContentVersion;
            return result2;
        }
    }
}

