/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileSystem;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileSystemProvider;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipPath;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcStorageLayouts {
    private static final Logger LOG = Logger.getInstance(DbSrcStorageLayouts.class);
    private static FileSystemProvider ourZipProvider = new ZipFileSystemProvider();
    public static final Map<String, Function<DbSrcStorage.FsAccess, DbSrcStorageLayout>> ourLayouts = ContainerUtil.immutableMapBuilder().put((Object)"schema-zip", SchemaZipLayout::new).put((Object)"plain", PlainLayout::new).build();
    public static final String VFS_SEP = String.valueOf('/');
    public static final String[] ESCAPE_FROM = new String[]{"/", "&", ".", "!", "\"", "\\", "<", ">", "|", "*", "?", ":"};
    public static final String[] ESCAPE_TO = new String[]{"&slash;", "&amp;", "&dot;", "&#33;", "&quot;", "&#92;", "&lt;", "&gt;", "&#124;", "&#42;", "&#63;", "&#58;"};
    public static final String EMPTY = "&empty;";

    private static String pathForFs(String path, FileSystem fs) {
        String sep = fs.getSeparator();
        if (sep != VFS_SEP) {
            path = path.replace(VFS_SEP, sep);
        }
        return path;
    }

    @Nullable
    public static DbSrcStorageLayout createLayout(@Nullable String id, @NotNull DbSrcStorage.FsAccess fs) {
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts", "createLayout"));
        }
        Function<DbSrcStorage.FsAccess, DbSrcStorageLayout> function = ourLayouts.get(id);
        return function == null ? null : (DbSrcStorageLayout)function.fun((Object)fs);
    }

    public static boolean kickZipUpdate(VirtualFile file) {
        LocalFileSystem fs;
        LocalFileSystem localFileSystem = fs = file == null ? null : (LocalFileSystem)ObjectUtils.tryCast((Object)file.getFileSystem(), LocalFileSystem.class);
        if (fs == null) {
            return false;
        }
        try {
            fs.setTimeStamp(file, file.getTimeStamp() + 1L);
        }
        catch (IOException e) {
            LOG.warn("failed to modify zip's timestamp", (Throwable)e);
        }
        VfsUtil.markDirty((boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{file});
        VirtualFile root2 = JarFileSystem.getInstance().getJarRootForLocalFile(file);
        if (root2 != null) {
            VfsUtil.markDirty((boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{root2});
        }
        return true;
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return EMPTY;
        }
        return StringUtil.replace((String)s, (String[])ESCAPE_FROM, (String[])ESCAPE_TO);
    }

    private static String unescape(String s) {
        if (s == null) {
            return null;
        }
        if (s.equals(EMPTY)) {
            return "";
        }
        return StringUtil.replace((String)s, (String[])ESCAPE_TO, (String[])ESCAPE_FROM);
    }

    private static boolean isEmpty(@NotNull Path path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts", "isEmpty"));
        }
        try (Stream<Path> list = Files.list(path);){
            boolean bl = !list.findAny().isPresent();
            return bl;
        }
    }

    public static abstract class PathLayout
    extends DbSrcStorageLayout {
        protected final DbSrcStorage.FsAccess myFsAccess;

        public PathLayout(@NotNull DbSrcStorage.FsAccess fs) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "<init>"));
            }
            this.myFsAccess = fs;
        }

        @Override
        @NotNull
        public DbSrcStorageLayout.Item getLocation(@NotNull String root2, @NotNull DbSrcPath object) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getLocation"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getLocation"));
            }
            DbSrcStorage.BiPath path = this.buildPath(root2, object, true);
            DbSrcStorage.BiPath path2 = this.buildPath(root2, object, false);
            FileItem fileItem = new FileItem(path, object, path2, this);
            if (fileItem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getLocation"));
            }
            return fileItem;
        }

        @NotNull
        protected abstract DbSrcStorage.BiPath buildPath(@NotNull String var1, @Nullable DbSrcPath var2, boolean var3);

        protected DbSrcStorage.BiPath compose(@NotNull String root2, @Nullable DbSrcStorage.BiPath path) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "compose"));
            }
            return path == null ? null : new DbSrcStorage.BiPath(root2 + VFS_SEP + path.local, path.zip);
        }

        @NotNull
        protected DbSrcStorage.BiPath append(@NotNull DbSrcStorage.BiPath path, @NotNull String node) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "append"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "append"));
            }
            if (path.zip == null) {
                DbSrcStorage.BiPath biPath = new DbSrcStorage.BiPath(path.local + VFS_SEP + node, null);
                if (biPath == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "append"));
                }
                return biPath;
            }
            DbSrcStorage.BiPath biPath = new DbSrcStorage.BiPath(path.local, path.zip.isEmpty() ? node : path.zip + VFS_SEP + node);
            if (biPath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "append"));
            }
            return biPath;
        }

        @Override
        @Nullable
        public DbSrcPath getObject(@NotNull String root2, @NotNull String file) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getObject"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getObject"));
            }
            BiSeq path = this.splitPath(root2, file);
            if (path == null) {
                return null;
            }
            return this.detectObject(path.local, path.zip);
        }

        @Nullable
        protected abstract DbSrcPath detectObject(@NotNull List<String> var1, @Nullable List<String> var2);

        @Override
        @NotNull
        public DbSrcStorage.FsAccess getFsAccess() {
            DbSrcStorage.FsAccess fsAccess = this.myFsAccess;
            if (fsAccess == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getFsAccess"));
            }
            return fsAccess;
        }

        @Nullable
        protected BiSeq splitPath(@NotNull String root2, @NotNull String child) {
            String zipPath;
            String localPath;
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "splitPath"));
            }
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "splitPath"));
            }
            if (!child.startsWith(root2)) {
                return null;
            }
            if (child.length() == root2.length()) {
                return new BiSeq(Collections.emptyList(), null);
            }
            if (root2.endsWith("/")) {
                child = child.substring(root2.length());
            } else if (child.charAt(root2.length()) == '/') {
                child = child.substring(root2.length() + 1);
            } else {
                return null;
            }
            int idx = child.indexOf("!/");
            if (idx != -1) {
                localPath = child.substring(0, idx);
                zipPath = child.substring(idx + "!/".length());
            } else {
                localPath = child;
                zipPath = null;
            }
            return new BiSeq(PathLayout.splitPath(localPath), PathLayout.splitPath(zipPath));
        }

        @Override
        @NotNull
        public DbSrcStorageLayout.WriteSession createSession() {
            ZipWriteSession zipWriteSession = new ZipWriteSession(this.myFsAccess);
            if (zipWriteSession == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "createSession"));
            }
            return zipWriteSession;
        }

        @Contract(value="null->null")
        private static List<String> splitPath(@Nullable String localPath) {
            if (localPath == null) {
                return null;
            }
            return localPath.isEmpty() ? Collections.emptyList() : ContainerUtil.newArrayList(DbSrcFileSystem.splitPath(localPath));
        }
    }

    public static abstract class UniformPathLayout
    extends PathLayout {
        public UniformPathLayout(DbSrcStorage.FsAccess fs) {
            super(fs);
        }

        @Override
        @Nullable
        protected DbSrcPath detectObject(@NotNull List<String> local, @Nullable List<String> zip) {
            if (local == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "detectObject"));
            }
            Iterable<String> path = this.glue(null, local, zip);
            if (path == null) {
                return null;
            }
            return this.detectObject(null, path);
        }

        @Nullable
        protected abstract DbSrcPath detectObject(@Nullable DbSrcPath var1, @NotNull Iterable<String> var2);

        @Nullable
        protected abstract Iterable<String> glue(@Nullable DbSrcPath var1, @NotNull List<String> var2, @Nullable List<String> var3);

        @Override
        @NotNull
        public Iterable<DbSrcPath> getExistingChildren(@NotNull String root2, @Nullable DbSrcPath object, @NotNull String group2) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingChildren"));
            }
            if (group2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingChildren"));
            }
            DbSrcStorage.BiPath path = this.buildPath(root2, object, false);
            JBIterable<BiSeq> children = this.getExistingChildrenRelative(object, path, group2);
            Set set = children.transform(f -> {
                Iterable<String> sub = this.glue(object, f.local, f.zip);
                if (sub == null) {
                    return null;
                }
                return this.detectObject(object, sub);
            }).filter(Conditions.notNull()).toSet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingChildren"));
            }
            return set;
        }

        @Override
        @NotNull
        public Iterable<String> getExistingGroups(@NotNull String root2, @Nullable DbSrcPath object) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingGroups"));
            }
            DbSrcStorage.BiPath path = this.buildPath(root2, object, false);
            JBIterable<String> jBIterable = this.getExistingGroups(object, path);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingGroups"));
            }
            return jBIterable;
        }

        protected abstract JBIterable<BiSeq> getExistingChildrenRelative(@Nullable DbSrcPath var1, @NotNull DbSrcStorage.BiPath var2, @NotNull String var3);

        @NotNull
        protected abstract JBIterable<String> getExistingGroups(@Nullable DbSrcPath var1, @NotNull DbSrcStorage.BiPath var2);
    }

    public static abstract class GroupedByKindLayout
    extends UniformPathLayout {
        private final String myZipStart;

        public GroupedByKindLayout(@Nullable String zipStart, DbSrcStorage.FsAccess fs) {
            super(fs);
            this.myZipStart = zipStart;
        }

        @Override
        @Nullable
        protected DbSrcPath detectObject(@Nullable DbSrcPath parent, @NotNull Iterable<String> path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "detectObject"));
            }
            if (!path.iterator().hasNext()) {
                return parent;
            }
            ArrayList kinds = ContainerUtil.newArrayListWithCapacity((int)(parent == null ? 1 : parent.size() + 1));
            ArrayList names = ContainerUtil.newArrayListWithCapacity((int)(parent == null ? 1 : parent.size() + 1));
            if (parent != null) {
                for (int i2 = 0; i2 < parent.size(); ++i2) {
                    kinds.add(parent.kind(i2));
                    names.add(parent.name(i2));
                }
            }
            String disambiguator = null;
            Iterator<String> it = path.iterator();
            while (it.hasNext()) {
                String code = it.next();
                if (code.indexOf(46) != -1) {
                    return null;
                }
                kinds.add(DbSrcStorageLayouts.unescape(code));
                if (!it.hasNext()) {
                    return null;
                }
                String name = it.next();
                int pt = name.indexOf(".");
                if (pt != -1) {
                    if (it.hasNext()) {
                        return null;
                    }
                    disambiguator = DbSrcStorageLayouts.unescape(name.substring(pt + 1));
                    name = name.substring(0, pt);
                }
                names.add(DbSrcStorageLayouts.unescape(name));
            }
            return names.isEmpty() ? null : new DbSrcPath(names, kinds, disambiguator);
        }

        @Override
        @Nullable
        protected Iterable<String> glue(@Nullable DbSrcPath parent, @NotNull List<String> local, @Nullable List<String> zip) {
            if (local == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "glue"));
            }
            if (zip == null) {
                String last = (String)ContainerUtil.getLastItem(local);
                if (last != null && last.endsWith(".zip")) {
                    return null;
                }
                return JBIterable.from(GroupedByKindLayout.trimExt(local, ".sql"));
            }
            if (local.isEmpty()) {
                return JBIterable.from(GroupedByKindLayout.trimExt(zip, ".sql"));
            }
            return JBIterable.from(GroupedByKindLayout.trimExt(local, ".zip")).append(GroupedByKindLayout.trimExt(zip, ".sql"));
        }

        @NotNull
        private static Iterable<String> trimExt(@NotNull List<String> list, @NotNull String ext) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
            }
            if (ext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
            }
            String last = (String)ContainerUtil.getLastItem(list);
            if (last == null) {
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
                }
                return list2;
            }
            if (!last.endsWith(ext)) {
                List<String> list3 = list;
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
                }
                return list3;
            }
            JBIterable jBIterable = JBIterable.from(list).take(list.size() - 1).append((Object)StringUtil.trimEnd((String)last, (String)ext));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
            }
            return jBIterable;
        }

        @NotNull
        private String[] list(@NotNull DbSrcStorage.BiPath path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "list"));
            }
            String[] stringArray = this.myFsAccess.list(path);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "list"));
            }
            return stringArray;
        }

        @Override
        protected JBIterable<BiSeq> getExistingChildrenRelative(@Nullable DbSrcPath object, @NotNull DbSrcStorage.BiPath file, @NotNull String group2) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "getExistingChildrenRelative"));
            }
            if (group2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "getExistingChildrenRelative"));
            }
            String groupDir = DbSrcStorageLayouts.escape(group2);
            JBIterable groupIt = JBIterable.of((Object[])this.list(this.append(file, groupDir)));
            return groupIt.transform(f -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "lambda$getExistingChildrenRelative$0"));
                }
                if (file.zip != null) {
                    return new BiSeq(Collections.emptyList(), Arrays.asList(groupDir, f));
                }
                return new BiSeq(Arrays.asList(groupDir, f), f.endsWith(".zip") ? Collections.emptyList() : null);
            });
        }

        @Override
        @NotNull
        protected JBIterable<String> getExistingGroups(@Nullable DbSrcPath object, @NotNull DbSrcStorage.BiPath file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "getExistingGroups"));
            }
            JBIterable jBIterable = JBIterable.of((Object[])this.list(file)).transform(f -> DbSrcStorageLayouts.unescape(f));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "getExistingGroups"));
            }
            return jBIterable;
        }

        @Override
        @NotNull
        protected DbSrcStorage.BiPath buildPath(@NotNull String root2, @Nullable DbSrcPath object, boolean src) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "buildPath"));
            }
            if (object == null) {
                DbSrcStorage.BiPath biPath = new DbSrcStorage.BiPath(root2, null);
                if (biPath == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "buildPath"));
                }
                return biPath;
            }
            StringBuilder res = new StringBuilder(root2);
            String local = null;
            int end = object.size();
            for (int i2 = 0; i2 < end; ++i2) {
                String kind = object.kind(i2);
                String name = object.name(i2);
                if (res.length() != 0) {
                    res.append("/");
                }
                res.append(DbSrcStorageLayouts.escape(kind)).append("/").append(DbSrcStorageLayouts.escape(name));
                if (!kind.equals(this.myZipStart) || i2 == end - 1 && src) continue;
                if (local != null) {
                    throw new AssertionError((Object)"passed zip start twice");
                }
                res.append(".zip");
                local = res.toString();
                res.setLength(0);
            }
            if (src) {
                if (object.getDisambiguator() != null) {
                    res.append(".").append(DbSrcStorageLayouts.escape(object.getDisambiguator()));
                }
                res.append(".sql");
            }
            DbSrcStorage.BiPath biPath = local == null ? new DbSrcStorage.BiPath(res.toString(), null) : new DbSrcStorage.BiPath(local, res.toString());
            if (biPath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "buildPath"));
            }
            return biPath;
        }
    }

    public static class SchemaZipLayout
    extends GroupedByKindLayout {
        public static final String ID = "schema-zip";

        public SchemaZipLayout(@NotNull DbSrcStorage.FsAccess fs) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$SchemaZipLayout", "<init>"));
            }
            super(ObjectKind.SCHEMA.code(), fs);
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$SchemaZipLayout", "getId"));
            }
            return ID;
        }
    }

    public static class PlainLayout
    extends GroupedByKindLayout {
        public static final String ID = "plain";

        public PlainLayout(@NotNull DbSrcStorage.FsAccess fs) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PlainLayout", "<init>"));
            }
            super(null, fs);
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PlainLayout", "getId"));
            }
            return ID;
        }
    }

    public static class FileItem
    implements DbSrcStorageLayout.Item {
        protected final DbSrcStorage.BiPath myPath;
        protected final DbSrcStorage.BiPath myChildrenPath;
        private final DbSrcPath myObject;
        protected final DbSrcStorageLayout myLayout;

        public FileItem(@NotNull DbSrcStorage.BiPath path, @NotNull DbSrcPath object, @Nullable DbSrcStorage.BiPath childrenPath, @NotNull DbSrcStorageLayout layout) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "<init>"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "<init>"));
            }
            if (layout == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "<init>"));
            }
            this.myPath = path;
            this.myChildrenPath = childrenPath;
            this.myObject = object;
            this.myLayout = layout;
        }

        @Override
        @NotNull
        public DbSrcStorageLayout getLayout() {
            DbSrcStorageLayout dbSrcStorageLayout = this.myLayout;
            if (dbSrcStorageLayout == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getLayout"));
            }
            return dbSrcStorageLayout;
        }

        @Override
        @NotNull
        public DbSrcPath getObject() {
            DbSrcPath dbSrcPath = this.myObject;
            if (dbSrcPath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getObject"));
            }
            return dbSrcPath;
        }

        @Override
        @Nullable
        public FileAttributes getSrcAttributes() {
            return this.myLayout.getFsAccess().getAttributes(this.myPath);
        }

        @Nullable
        private FileAttributes getChildrenAttributes() {
            return this.myChildrenPath == null ? null : this.myLayout.getFsAccess().getAttributes(this.myChildrenPath);
        }

        @Override
        @Nullable
        public VirtualFile getSrcFile() {
            VirtualFile file = this.toVirtualFile(this.myPath);
            Application app = ApplicationManager.getApplication();
            if ((app == null || app.isUnitTestMode()) && file == null && this.getSrcAttributes() != null) {
                throw new AssertionError((Object)("Failed to find: " + this.myPath.toPath()));
            }
            return file;
        }

        @Override
        public boolean hasChildren() {
            return this.getChildrenAttributes() != null;
        }

        @Nullable
        private VirtualFile toVirtualFile(@Nullable DbSrcStorage.BiPath path) {
            if (path == null) {
                return null;
            }
            return this.myLayout.getFsAccess().findFileByPath(path);
        }

        @Override
        @NotNull
        public OutputStream getOutputStream(@Nullable Object requestor, @Nullable DbSrcStorageLayout.WriteSession someSession) throws IOException {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (this.myPath.zip == null) {
                OutputStream outputStream = FileItem.ensureExistsLocal(this.myLayout.getFsAccess(), this.myPath.local, requestor).getOutputStream(requestor);
                if (outputStream == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getOutputStream"));
                }
                return outputStream;
            }
            final ZipWriteSharedSession shared = ZipWriteSession.acquire(someSession, this.myLayout.getFsAccess(), this.myPath.local);
            shared.willWrite();
            OutputStream outputStream = new OutputStream(){
                private OutputStream myOutputStream;
                {
                    try {
                        ZipPath path = shared.fs.getPath(DbSrcStorageLayouts.pathForFs(myPath.zip, shared.fs), new String[0]);
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        this.myOutputStream = Files.newOutputStream(path, StandardOpenOption.CREATE);
                    }
                    finally {
                        if (this.myOutputStream == null) {
                            ZipWriteSharedSession.release(shared);
                        }
                    }
                }

                @Override
                public void write(int b) throws IOException {
                    this.myOutputStream.write(b);
                }

                @Override
                public void close() throws IOException {
                    try {
                        this.myOutputStream.close();
                    }
                    finally {
                        ZipWriteSharedSession.release(shared);
                    }
                }
            };
            if (outputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getOutputStream"));
            }
            return outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete(@Nullable Object requestor, @Nullable DbSrcStorageLayout.WriteSession someSession) throws IOException {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (this.myPath.zip == null) {
                Path path;
                FileSystem defaultFs = FileSystems.getDefault();
                String fsPath = DbSrcStorageLayouts.pathForFs(this.myPath.local, defaultFs);
                Path stop = path = defaultFs.getPath(fsPath, new String[0]);
                int cnt = this.myObject.size() * 2;
                for (int i2 = 0; i2 < cnt && stop != null; stop = stop.getParent(), ++i2) {
                }
                FileItem.deleteUpwards(path, stop);
                this.myLayout.getFsAccess().markDirty(this.myPath);
                return;
            }
            ZipWriteSharedSession sharedSession = ZipWriteSession.acquire(someSession, this.myLayout.getFsAccess(), this.myPath.local);
            try {
                sharedSession.willWrite();
                ZipFileSystem fs = sharedSession.fs;
                ZipPath path = fs.getPath(DbSrcStorageLayouts.pathForFs(this.myPath.zip, fs), new String[0]);
                FileItem.deleteUpwards(path, null);
            }
            finally {
                ZipWriteSharedSession.release(sharedSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public byte[] getSrcContents() throws IOException {
            byte[] byArray;
            ZipWriteSharedSession session;
            block8: {
                session = this.myPath.zip == null ? null : ZipWriteSharedSession.acquire(this.myPath.local, this.myLayout.getFsAccess(), false);
                if (session != null) {
                    ZipFileSystem fs = session.fs;
                    ZipPath path = fs.getPath(DbSrcStorageLayouts.pathForFs(this.myPath.zip, fs), new String[0]);
                    if (Files.size(path) >= (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                        throw new FileTooBigException(path.toString());
                    }
                    byte[] byArray2 = Files.readAllBytes(path);
                    if (byArray2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getSrcContents"));
                    }
                    return byArray2;
                }
                byArray = this.myLayout.getFsAccess().getContents(this.myPath);
                if (byArray != null) break block8;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getSrcContents"));
            }
            return byArray;
            finally {
                if (session != null) {
                    ZipWriteSharedSession.release(session);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            ZipWriteSharedSession session = this.myPath.zip == null ? null : ZipWriteSharedSession.acquire(this.myPath.local, this.myLayout.getFsAccess(), false);
            if (session != null) {
                ZipFileSystem fs = session.fs;
                ZipPath path = fs.getPath(DbSrcStorageLayouts.pathForFs(this.myPath.zip, fs), new String[0]);
                if (Files.size(path) >= (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                    throw new FileTooBigException(path.toString());
                }
                final ZipWriteSharedSession finalSession = session;
                BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])){

                    @Override
                    public void close() throws IOException {
                        try {
                            super.close();
                        }
                        finally {
                            ZipWriteSharedSession.release(finalSession);
                        }
                    }
                };
                session = null;
                BufferedInputStream bufferedInputStream = stream;
                BufferedInputStream bufferedInputStream2 = bufferedInputStream;
                if (bufferedInputStream2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getInputStream"));
                }
                return bufferedInputStream2;
            }
            InputStream inputStream = this.myLayout.getFsAccess().getInputStream(this.myPath);
            InputStream inputStream2 = inputStream;
            if (inputStream2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getInputStream"));
            }
            return inputStream2;
            finally {
                if (session != null) {
                    ZipWriteSharedSession.release(session);
                }
            }
        }

        private static void deleteUpwards(@NotNull Path path, @Nullable Path until) throws IOException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "deleteUpwards"));
            }
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    Files.deleteIfExists(path);
                }
                for (path = path.getParent(); path != null && !path.equals(until) && (!Files.exists(path, new LinkOption[0]) || DbSrcStorageLayouts.isEmpty(path) && Files.deleteIfExists(path)); path = path.getParent()) {
                }
            }
            catch (DirectoryNotEmptyException | NotDirectoryException fileSystemException) {
                // empty catch block
            }
        }

        @Override
        @NotNull
        public String getSrcPath() {
            String string = this.myPath.zip == null ? this.myPath.local : this.myPath.local + "!/" + this.myPath.zip;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getSrcPath"));
            }
            return string;
        }

        @NotNull
        protected static VirtualFile ensureExistsLocal(@NotNull DbSrcStorage.FsAccess fs, @NotNull String filePath, @Nullable Object requestor) throws IOException {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "ensureExistsLocal"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "ensureExistsLocal"));
            }
            FileSystem defaultFs = FileSystems.getDefault();
            String fsPath = DbSrcStorageLayouts.pathForFs(filePath, defaultFs);
            Path toCreate = defaultFs.getPath(fsPath, new String[0]).getParent();
            try {
                Files.createDirectories(toCreate, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            VirtualFile path = fs.findFileByPath(new DbSrcStorage.BiPath(filePath, null));
            if (path == null) {
                VirtualFile parent;
                String dir = VfsUtil.getParentDir((String)filePath);
                VirtualFile virtualFile = parent = dir == null ? null : VfsUtil.createDirectories((String)dir);
                if (parent == null) {
                    throw new IOException("Directory creation failed");
                }
                path = parent.findOrCreateChildData(requestor, PathUtil.getFileName((String)filePath));
            }
            VirtualFile virtualFile = path;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "ensureExistsLocal"));
            }
            return virtualFile;
        }
    }

    private static class ZipWriteSession
    implements DbSrcStorageLayout.WriteSession {
        private static final Logger LOG = Logger.getInstance(ZipWriteSession.class);
        private final DbSrcStorage.FsAccess myFsAccess;
        public ZipWriteSharedSession mySharedSession;

        private ZipWriteSession(@NotNull DbSrcStorage.FsAccess fsAccess) {
            if (fsAccess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fsAccess", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "<init>"));
            }
            this.myFsAccess = fsAccess;
        }

        @NotNull
        public static ZipWriteSharedSession acquire(@Nullable DbSrcStorageLayout.WriteSession someSession, @NotNull DbSrcStorage.FsAccess fsAccess, @NotNull String path) throws IOException {
            if (fsAccess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fsAccess", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "acquire"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "acquire"));
            }
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            ZipWriteSession session = (ZipWriteSession)ObjectUtils.tryCast((Object)someSession, ZipWriteSession.class);
            if (session == null) {
                ZipWriteSharedSession zipWriteSharedSession = ZipWriteSharedSession.acquire(path, fsAccess, true);
                if (zipWriteSharedSession == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "acquire"));
                }
                return zipWriteSharedSession;
            }
            session.renew(path);
            ZipWriteSharedSession zipWriteSharedSession = ZipWriteSharedSession.acquire(session.mySharedSession);
            if (zipWriteSharedSession == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "acquire"));
            }
            return zipWriteSharedSession;
        }

        private void renew(@NotNull String path) throws IOException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "renew"));
            }
            path = ZipWriteSharedSession.normalizePath(path);
            if (this.mySharedSession != null && path.equals(this.mySharedSession.path)) {
                return;
            }
            try {
                this.close();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                this.mySharedSession = null;
            }
            this.mySharedSession = ZipWriteSharedSession.acquire(path, this.myFsAccess, true);
        }

        @Override
        public void close() throws IOException {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (this.mySharedSession == null) {
                return;
            }
            ZipWriteSharedSession session = this.mySharedSession;
            this.mySharedSession = null;
            ZipWriteSharedSession.release(session);
        }
    }

    private static class ZipWriteSharedSession {
        private static final Map<String, ZipWriteSharedSession> ourShared = ContainerUtil.newHashMap();
        private final DbSrcStorage.FsAccess myFsAccess;
        private int myCounter;
        private volatile boolean myWrite;
        public final ZipFileSystem fs;
        public final String path;

        private ZipWriteSharedSession(@NotNull String path, @NotNull ZipFileSystem fs, @NotNull DbSrcStorage.FsAccess fsAccess) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "<init>"));
            }
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "<init>"));
            }
            if (fsAccess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fsAccess", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "<init>"));
            }
            this.fs = fs;
            this.path = path;
            this.myFsAccess = fsAccess;
        }

        private static ZipFileSystem create(@NotNull String path) throws IOException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "create"));
            }
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            return ZipWriteSharedSession.createOrBackupZipFile(FileSystems.getDefault().getPath(path, new String[0]));
        }

        public void willWrite() {
            this.myWrite = true;
        }

        @NotNull
        static String normalizePath(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "normalizePath"));
            }
            String string = path = DbSrcStorageLayouts.pathForFs(path, FileSystems.getDefault());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "normalizePath"));
            }
            return string;
        }

        private static ZipFileSystem createOrBackupZipFile(Path zipPath) throws IOException {
            Files.createDirectories(zipPath.getParent(), new FileAttribute[0]);
            URI zipUri = URI.create("jar:" + zipPath.toUri().toString());
            Map<String, String> env = Collections.singletonMap("create", "true");
            try {
                return (ZipFileSystem)ourZipProvider.newFileSystem(zipUri, env);
            }
            catch (ZipError e) {
                block4: {
                    LOG.warn("Failed to open zip " + zipPath + ": " + e.getMessage());
                    Path backup = null;
                    try {
                        backup = Files.createTempFile(zipPath.getParent(), String.valueOf(zipPath.getFileName()), ".bak", new FileAttribute[0]);
                        Files.move(zipPath, backup, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException ex) {
                        LOG.warn("Backup failed: " + ex.getMessage());
                        if (backup == null) break block4;
                        Files.deleteIfExists(backup);
                    }
                }
                return (ZipFileSystem)ourZipProvider.newFileSystem(zipUri, env);
            }
        }

        private static void closeAndRemoveEmpty(@NotNull ZipFileSystem fs, @NotNull String path) throws IOException {
            boolean empty;
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "closeAndRemoveEmpty"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "closeAndRemoveEmpty"));
            }
            try {
                empty = JBIterable.from(fs.getRootDirectories()).filter(p -> ZipWriteSharedSession.isNotEmpty(p)).isEmpty();
            }
            finally {
                fs.close();
            }
            if (empty) {
                FileSystem defaultFs = FileSystems.getDefault();
                path = DbSrcStorageLayouts.pathForFs(path, defaultFs);
                Path zipPath = defaultFs.getPath(path, new String[0]);
                try {
                    Files.deleteIfExists(zipPath);
                }
                catch (IOException e) {
                    LOG.warn("Failed to delete: " + e.getMessage());
                }
            }
        }

        private static boolean isNotEmpty(@NotNull Path path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "isNotEmpty"));
            }
            try {
                return !DbSrcStorageLayouts.isEmpty(path);
            }
            catch (IOException e) {
                return true;
            }
        }

        private static void close(@NotNull ZipFileSystem fs, @NotNull String path) throws IOException {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "close"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "close"));
            }
            try {
                ZipHandler.clearFileAccessorCache();
            }
            finally {
                try {
                    ZipWriteSharedSession.closeAndRemoveEmpty(fs, path);
                }
                catch (IOException e) {
                    LOG.warn("Close failed, data lost: ", (Throwable)e);
                }
            }
        }

        private void close() throws IOException {
            ZipWriteSharedSession.close(this.fs, this.path);
            if (this.myWrite) {
                ZipWriteSharedSession.markDirty(this.path, this.myFsAccess);
            }
        }

        private static void markDirty(String finalPath, DbSrcStorage.FsAccess fsAccess) {
            DbSrcStorage.BiPath path = new DbSrcStorage.BiPath(finalPath, null);
            VirtualFile file = fsAccess.findFileByPath(path);
            if (file != null) {
                DbSrcStorageLayouts.kickZipUpdate(file);
            }
            fsAccess.markDirty(path);
            fsAccess.markDirty(new DbSrcStorage.BiPath(PathUtil.getParentPath((String)finalPath), null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Contract(value="_,_,true->!null")
        public static ZipWriteSharedSession acquire(@NotNull String path, @NotNull DbSrcStorage.FsAccess fsAccess, boolean create) throws IOException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "acquire"));
            }
            if (fsAccess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fsAccess", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "acquire"));
            }
            path = ZipWriteSharedSession.normalizePath(path);
            Map<String, ZipWriteSharedSession> map = ourShared;
            synchronized (map) {
                ZipWriteSharedSession session = ourShared.get(path);
                if (session == null) {
                    if (!create) {
                        return null;
                    }
                    ZipFileSystem fs = ZipWriteSharedSession.create(path);
                    session = new ZipWriteSharedSession(path, (ZipFileSystem)ObjectUtils.assertNotNull((Object)fs), fsAccess);
                    ourShared.put(path, session);
                }
                ++session.myCounter;
                return session;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        public static ZipWriteSharedSession acquire(@NotNull ZipWriteSharedSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "acquire"));
            }
            Map<String, ZipWriteSharedSession> map = ourShared;
            // MONITORENTER : map
            ZipWriteSharedSession stored = ourShared.get(session.path);
            if (session != stored) {
                throw new AssertionError((Object)"Session leaked");
            }
            ++session.myCounter;
            ZipWriteSharedSession zipWriteSharedSession = session;
            // MONITOREXIT : map
            if (zipWriteSharedSession != null) return zipWriteSharedSession;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "acquire"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void release(@NotNull ZipWriteSharedSession session) throws IOException {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSharedSession", "release"));
            }
            ZipWriteSharedSession toClear = null;
            try {
                Map<String, ZipWriteSharedSession> map = ourShared;
                synchronized (map) {
                    ZipWriteSharedSession stored = ourShared.get(session.path);
                    if (stored != session) {
                        throw new AssertionError((Object)"Session leak");
                    }
                    --session.myCounter;
                    if (session.myCounter == 0) {
                        toClear = session;
                        ourShared.remove(session.path);
                    }
                }
                if (toClear == null) return;
            }
            catch (Throwable throwable) {
                if (toClear == null) throw throwable;
                super.close();
                throw throwable;
            }
            toClear.close();
        }
    }

    private static class BiSeq {
        @NotNull
        public final List<String> local;
        @Nullable
        public final List<String> zip;

        public BiSeq(@NotNull List<String> local, @Nullable List<String> zip) {
            if (local == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$BiSeq", "<init>"));
            }
            this.local = local;
            this.zip = zip;
        }
    }
}

