/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.zipfs;

class ZipConstants {
    static final int METHOD_STORED = 0;
    static final int METHOD_DEFLATED = 8;
    static final int METHOD_DEFLATED64 = 9;
    static final int METHOD_BZIP2 = 12;
    static final int METHOD_LZMA = 14;
    static final int METHOD_LZ77 = 19;
    static final int METHOD_AES = 99;
    static final int FLAG_ENCRYPTED = 1;
    static final int FLAG_DATADESCR = 8;
    static final int FLAG_EFS = 2048;
    static long LOCSIG = 67324752L;
    static long EXTSIG = 134695760L;
    static long CENSIG = 33639248L;
    static long ENDSIG = 101010256L;
    static final int LOCHDR = 30;
    static final int EXTHDR = 16;
    static final int CENHDR = 46;
    static final int ENDHDR = 22;
    static final int LOCVER = 4;
    static final int LOCFLG = 6;
    static final int LOCHOW = 8;
    static final int LOCTIM = 10;
    static final int LOCCRC = 14;
    static final int LOCSIZ = 18;
    static final int LOCLEN = 22;
    static final int LOCNAM = 26;
    static final int LOCEXT = 28;
    static final int EXTCRC = 4;
    static final int EXTSIZ = 8;
    static final int EXTLEN = 12;
    static final int CENVEM = 4;
    static final int CENVER = 6;
    static final int CENFLG = 8;
    static final int CENHOW = 10;
    static final int CENTIM = 12;
    static final int CENCRC = 16;
    static final int CENSIZ = 20;
    static final int CENLEN = 24;
    static final int CENNAM = 28;
    static final int CENEXT = 30;
    static final int CENCOM = 32;
    static final int CENDSK = 34;
    static final int CENATT = 36;
    static final int CENATX = 38;
    static final int CENOFF = 42;
    static final int ENDSUB = 8;
    static final int ENDTOT = 10;
    static final int ENDSIZ = 12;
    static final int ENDOFF = 16;
    static final int ENDCOM = 20;
    static final long ZIP64_ENDSIG = 101075792L;
    static final long ZIP64_LOCSIG = 117853008L;
    static final int ZIP64_ENDHDR = 56;
    static final int ZIP64_LOCHDR = 20;
    static final int ZIP64_EXTHDR = 24;
    static final int ZIP64_EXTID = 1;
    static final int ZIP64_MINVAL32 = 65535;
    static final long ZIP64_MINVAL = 0xFFFFFFFFL;
    static final int ZIP64_ENDLEN = 4;
    static final int ZIP64_ENDVEM = 12;
    static final int ZIP64_ENDVER = 14;
    static final int ZIP64_ENDNMD = 16;
    static final int ZIP64_ENDDSK = 20;
    static final int ZIP64_ENDTOD = 24;
    static final int ZIP64_ENDTOT = 32;
    static final int ZIP64_ENDSIZ = 40;
    static final int ZIP64_ENDOFF = 48;
    static final int ZIP64_ENDEXT = 56;
    static final int ZIP64_LOCDSK = 4;
    static final int ZIP64_LOCOFF = 8;
    static final int ZIP64_LOCTOT = 16;
    static final int ZIP64_EXTCRC = 4;
    static final int ZIP64_EXTSIZ = 8;
    static final int ZIP64_EXTLEN = 16;
    static final int EXTID_ZIP64 = 1;
    static final int EXTID_NTFS = 10;
    static final int EXTID_UNIX = 13;
    static final int EXTID_EFS = 23;
    static final int EXTID_EXTT = 21589;
    static final long END_MAXLEN = 65557L;
    static final int READBLOCKSZ = 128;

    ZipConstants() {
    }

    static final int CH(byte[] b, int n) {
        return Byte.toUnsignedInt(b[n]);
    }

    static final int SH(byte[] b, int n) {
        return Byte.toUnsignedInt(b[n]) | Byte.toUnsignedInt(b[n + 1]) << 8;
    }

    static final long LG(byte[] b, int n) {
        return (long)(ZipConstants.SH(b, n) | ZipConstants.SH(b, n + 2) << 16) & 0xFFFFFFFFL;
    }

    static final long LL(byte[] b, int n) {
        return ZipConstants.LG(b, n) | ZipConstants.LG(b, n + 4) << 32;
    }

    static final long GETSIG(byte[] b) {
        return ZipConstants.LG(b, 0);
    }

    static final long LOCSIG(byte[] b) {
        return ZipConstants.LG(b, 0);
    }

    static final int LOCVER(byte[] b) {
        return ZipConstants.SH(b, 4);
    }

    static final int LOCFLG(byte[] b) {
        return ZipConstants.SH(b, 6);
    }

    static final int LOCHOW(byte[] b) {
        return ZipConstants.SH(b, 8);
    }

    static final long LOCTIM(byte[] b) {
        return ZipConstants.LG(b, 10);
    }

    static final long LOCCRC(byte[] b) {
        return ZipConstants.LG(b, 14);
    }

    static final long LOCSIZ(byte[] b) {
        return ZipConstants.LG(b, 18);
    }

    static final long LOCLEN(byte[] b) {
        return ZipConstants.LG(b, 22);
    }

    static final int LOCNAM(byte[] b) {
        return ZipConstants.SH(b, 26);
    }

    static final int LOCEXT(byte[] b) {
        return ZipConstants.SH(b, 28);
    }

    static final long EXTCRC(byte[] b) {
        return ZipConstants.LG(b, 4);
    }

    static final long EXTSIZ(byte[] b) {
        return ZipConstants.LG(b, 8);
    }

    static final long EXTLEN(byte[] b) {
        return ZipConstants.LG(b, 12);
    }

    static final int ENDSUB(byte[] b) {
        return ZipConstants.SH(b, 8);
    }

    static final int ENDTOT(byte[] b) {
        return ZipConstants.SH(b, 10);
    }

    static final long ENDSIZ(byte[] b) {
        return ZipConstants.LG(b, 12);
    }

    static final long ENDOFF(byte[] b) {
        return ZipConstants.LG(b, 16);
    }

    static final int ENDCOM(byte[] b) {
        return ZipConstants.SH(b, 20);
    }

    static final int ENDCOM(byte[] b, int off) {
        return ZipConstants.SH(b, off + 20);
    }

    static final long ZIP64_ENDTOD(byte[] b) {
        return ZipConstants.LL(b, 24);
    }

    static final long ZIP64_ENDTOT(byte[] b) {
        return ZipConstants.LL(b, 32);
    }

    static final long ZIP64_ENDSIZ(byte[] b) {
        return ZipConstants.LL(b, 40);
    }

    static final long ZIP64_ENDOFF(byte[] b) {
        return ZipConstants.LL(b, 48);
    }

    static final long ZIP64_LOCOFF(byte[] b) {
        return ZipConstants.LL(b, 8);
    }

    static final long CENSIG(byte[] b, int pos) {
        return ZipConstants.LG(b, pos + 0);
    }

    static final int CENVEM(byte[] b, int pos) {
        return ZipConstants.SH(b, pos + 4);
    }

    static final int CENVER(byte[] b, int pos) {
        return ZipConstants.SH(b, pos + 6);
    }

    static final int CENFLG(byte[] b, int pos) {
        return ZipConstants.SH(b, pos + 8);
    }

    static final int CENHOW(byte[] b, int pos) {
        return ZipConstants.SH(b, pos + 10);
    }

    static final long CENTIM(byte[] b, int pos) {
        return ZipConstants.LG(b, pos + 12);
    }

    static final long CENCRC(byte[] b, int pos) {
        return ZipConstants.LG(b, pos + 16);
    }

    static final long CENSIZ(byte[] b, int pos) {
        return ZipConstants.LG(b, pos + 20);
    }

    static final long CENLEN(byte[] b, int pos) {
        return ZipConstants.LG(b, pos + 24);
    }

    static final int CENNAM(byte[] b, int pos) {
        return ZipConstants.SH(b, pos + 28);
    }

    static final int CENEXT(byte[] b, int pos) {
        return ZipConstants.SH(b, pos + 30);
    }

    static final int CENCOM(byte[] b, int pos) {
        return ZipConstants.SH(b, pos + 32);
    }

    static final int CENDSK(byte[] b, int pos) {
        return ZipConstants.SH(b, pos + 34);
    }

    static final int CENATT(byte[] b, int pos) {
        return ZipConstants.SH(b, pos + 36);
    }

    static final long CENATX(byte[] b, int pos) {
        return ZipConstants.LG(b, pos + 38);
    }

    static final long CENOFF(byte[] b, int pos) {
        return ZipConstants.LG(b, pos + 42);
    }
}

