/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModelBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterEditorModel
extends UrlEditorModelBase {
    private final Map<String, String> myParameters;
    private final List<JdbcUrlParser> myParsers;
    private final String myName;
    private int myActive;
    @NotNull
    private String myUrl;

    public ParameterEditorModel(@NotNull String name, @NotNull Collection<StatelessJdbcUrlParser> parsers) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "<init>"));
        }
        if (parsers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsers", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "<init>"));
        }
        this.myActive = 0;
        this.myUrl = "";
        this.myParameters = ContainerUtil.newLinkedHashMap((Map)JBIterable.from(parsers).flatten(parser -> parser.getParameters()).toMap(o -> ""));
        this.myParsers = ContainerUtil.newArrayListWithCapacity((int)parsers.size());
        for (StatelessJdbcUrlParser parser2 : parsers) {
            this.myParsers.add(parser2.createStatefull());
        }
        this.myName = name;
    }

    @Override
    @Nullable
    protected StatelessParametersHolder getParametersHolderDelegate() {
        return this.getActiveParser();
    }

    public boolean commit(@Nullable Object arg) {
        if (this.getState() == UrlEditorModelBase.State.VALID) {
            return false;
        }
        boolean changed = this.chooseParser();
        return this.validate(changed |= this.updateActiveParser(), arg);
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "setUrl"));
        }
        if (this.myUrl.equals(url)) {
            return;
        }
        this.invalidate(UrlEditorModelBase.State.URL_CHANGED);
        this.myUrl = url;
    }

    public void setParameter(@NotNull String param, @NotNull String value) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "setParameter"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "setParameter"));
        }
        String val = this.myParameters.get(param);
        if (val == null || val.equals(value)) {
            return;
        }
        this.invalidate(UrlEditorModelBase.State.PARAMS_CHANGED);
        this.myParameters.put(param, value);
    }

    @Nullable
    JdbcUrlParser getActiveParser() {
        return this.myParsers.isEmpty() ? null : this.myParsers.get(this.myActive);
    }

    private boolean updateActiveParser() {
        if (this.getActiveParser() == null) {
            return UrlEditorModelBase.State.URL_CHANGED == this.getState();
        }
        boolean changed = false;
        if (this.getState() == UrlEditorModelBase.State.PARAMS_CHANGED) {
            for (Map.Entry<String, String> entry : this.myParameters.entrySet()) {
                if (entry.getValue().equals(this.getActiveParser().getParameter(entry.getKey()))) continue;
                this.getActiveParser().setParameter(entry.getKey(), entry.getValue());
                changed = true;
            }
            String newUrl = this.getActiveParser().getUrlText();
            if (!this.myUrl.equals(newUrl)) {
                this.myUrl = newUrl;
                changed = true;
            }
        } else if (this.getState() == UrlEditorModelBase.State.URL_CHANGED) {
            if (!this.myUrl.equals(this.getActiveParser().getUrlText())) {
                this.getActiveParser().setUrlTextTolerantly(this.myUrl);
                changed = true;
            }
            for (Map.Entry<String, String> entry : this.myParameters.entrySet()) {
                String newVal = StringUtil.notNullize((String)this.getActiveParser().getParameter(entry.getKey()));
                if (entry.getValue().equals(newVal)) continue;
                this.myParameters.put(entry.getKey(), newVal);
                changed = true;
            }
        }
        return changed;
    }

    @Nullable
    public StatelessJdbcUrlParser getMeaningfullParser(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "getMeaningfullParser"));
        }
        for (JdbcUrlParser parser : this.myParsers) {
            if (!parser.isUrlValueValid(url)) continue;
            return parser;
        }
        return null;
    }

    private boolean chooseParser() {
        block6: {
            block5: {
                if (this.getActiveParser() == null) {
                    return false;
                }
                if (this.getState() != UrlEditorModelBase.State.URL_CHANGED) break block5;
                if (this.getActiveParser().isUrlValueValid(this.myUrl)) {
                    return false;
                }
                for (int i2 = 0; i2 < this.myParsers.size(); ++i2) {
                    if (i2 == this.myActive || !this.myParsers.get(i2).isUrlValueValid(this.myUrl)) continue;
                    this.myActive = i2;
                    return true;
                }
                break block6;
            }
            if (this.getState() != UrlEditorModelBase.State.PARAMS_CHANGED) break block6;
            if (this.areParametersValidFor(this.getActiveParser())) {
                return false;
            }
            for (int i3 = 0; i3 < this.myParsers.size(); ++i3) {
                if (i3 == this.myActive || !this.areParametersValidFor(this.myParsers.get(i3))) continue;
                this.myActive = i3;
                return true;
            }
        }
        return false;
    }

    private boolean areParametersValidFor(@NotNull JdbcUrlParser parser) {
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "areParametersValidFor"));
        }
        for (Map.Entry<String, String> entry : this.myParameters.entrySet()) {
            if (StringUtil.isEmpty((String)entry.getValue()) || parser.isParameterValueValid(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public String getUrl() {
        assert (this.getState() != UrlEditorModelBase.State.PARAMS_CHANGED);
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "getUrl"));
        }
        return string;
    }

    public boolean isUrlValueValid(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "isUrlValueValid"));
        }
        if (this.getActiveParser() == null || this.getActiveParser().isUrlValueValid(url)) {
            return true;
        }
        for (int i2 = 0; i2 < this.myParsers.size(); ++i2) {
            if (i2 == this.myActive || !this.myParsers.get(i2).isUrlValueValid(url)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "getName"));
        }
        return string;
    }

    @Override
    @Nullable
    public String getParameter(@NotNull String param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "getParameter"));
        }
        assert (this.getState() != UrlEditorModelBase.State.URL_CHANGED);
        return this.myParameters.get(param);
    }

    @NotNull
    public Collection<TextRange> getInvalidRanges() {
        List<TextRange> list = this.getActiveParser() == null ? Collections.emptyList() : this.getActiveParser().getInvalidRanges();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "getInvalidRanges"));
        }
        return list;
    }

    @Nullable
    public TextRange getParameterRange(@NotNull String param) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/database/dataSource/url/template/ParameterEditorModel", "getParameterRange"));
        }
        return this.getActiveParser() == null ? null : this.getActiveParser().getParameterRange(param);
    }

    public boolean isParserValid() {
        return this.getActiveParser() == null || this.getActiveParser().isValid();
    }
}

