/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.Grid;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.IndexSet;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ModelIndexSet<S>
extends IndexSet<ModelIndex<S>> {
    public static <Row> ModelIndexSet<Row> forRows(Grid<Row, ?> grid, int ... rows) {
        return ModelIndexSet.forRows(grid.getDataModel(DataAccessType.DATABASE_DATA), rows);
    }

    public static <Row> ModelIndexSet<Row> forRows(GridModel<Row, ?> model, int ... rows) {
        return new Rows(rows);
    }

    public static <Column> ModelIndexSet<Column> forColumns(Grid<?, Column> grid, int ... columns2) {
        return ModelIndexSet.forColumns(grid.getDataModel(DataAccessType.DATABASE_DATA), columns2);
    }

    public static <Column> ModelIndexSet<Column> forColumns(GridModel<?, Column> model, int ... columns2) {
        return new Columns(columns2);
    }

    private ModelIndexSet(int ... indices) {
        super(indices);
    }

    @NotNull
    public abstract ViewIndexSet<S> toView(@NotNull Grid<?, ?> var1);

    public String toString() {
        return "Model" + this.getClass().getSimpleName() + "{" + StringUtil.join((int[])this.values, (String)",") + "}";
    }

    private static class Columns<Column>
    extends ModelIndexSet<Column> {
        public Columns(int ... indices) {
            super(indices);
        }

        @Override
        @NotNull
        public ViewIndexSet<Column> toView(@NotNull Grid<?, ?> grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/ModelIndexSet$Columns", "toView"));
            }
            ViewIndexSet<?> viewIndexSet = ViewIndexSet.forColumns(grid, Columns.convert(ModelIndex.col2View(grid), this.asArray()));
            if (viewIndexSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/ModelIndexSet$Columns", "toView"));
            }
            return viewIndexSet;
        }

        @Override
        protected ModelIndex<Column> forValue(int value) {
            return ModelIndex.forColumn((GridModel)null, value);
        }
    }

    private static class Rows<Row>
    extends ModelIndexSet<Row> {
        Rows(int ... indices) {
            super(indices);
        }

        @Override
        @NotNull
        public ViewIndexSet<Row> toView(@NotNull Grid<?, ?> grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/ModelIndexSet$Rows", "toView"));
            }
            ViewIndexSet<?> viewIndexSet = ViewIndexSet.forRows(grid, Rows.convert(ModelIndex.row2View(grid), this.asArray()));
            if (viewIndexSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/ModelIndexSet$Rows", "toView"));
            }
            return viewIndexSet;
        }

        @Override
        protected ModelIndex<Row> forValue(int value) {
            return ModelIndex.forRow((GridModel)null, value);
        }
    }
}

