/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.mutating.MutationData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutationColumn
extends DataConsumer.Column {
    private final GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> myMutator;
    private final DataGrid myGrid;

    public MutationColumn(@NotNull DataConsumer.Column column, @NotNull GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator, @NotNull DataGrid grid) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/MutationColumn", "<init>"));
        }
        if (mutator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutator", "com/intellij/database/datagrid/MutationColumn", "<init>"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/MutationColumn", "<init>"));
        }
        super(column.columnNum, column.name, column.type, column.typeName, column.clazz, column.precision, column.scale, column.catalog, column.schema, column.table);
        this.myMutator = mutator;
        this.myGrid = grid;
    }

    @Override
    @Nullable
    public Object getValue(@NotNull DataConsumer.Row row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/MutationColumn", "getValue"));
        }
        MutationData mutation = this.myMutator.getMutation(ModelIndex.forRow(this.myGrid, DataConsumer.Row.toRealIdx(row)), ModelIndex.forColumn(this.myGrid, this.columnNum));
        return mutation == null ? super.getValue(row) : mutation.getValue();
    }
}

