/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.csv;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.TableEditorComponent;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvTableEditorComponent
extends TableEditorComponent<DataGrid> {
    private final Map<List<? extends ColumnDescriptor>, ImportDatabaseTableEditor<?>> myMap;

    public CsvTableEditorComponent(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/csv/CsvTableEditorComponent", "<init>"));
        }
        super(context);
        this.myMap = ContainerUtil.newHashMap();
    }

    @Override
    @NotNull
    public CompletionStage<ImportDatabaseTableEditor<?>> notifyChanged(@Nullable DataGrid object) {
        List<DataConsumer.Column> columns2;
        List<ColumnDescriptor> list = columns2 = object == null ? this.myContext.getBuilder().getProducers() : ImportUtil.getColumns(object);
        if (columns2 == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvTableEditorComponent", "notifyChanged"));
            }
            return completableFuture;
        }
        if (this.myMap.containsKey(columns2)) {
            ImportDatabaseTableEditor oldOne = (ImportDatabaseTableEditor)ObjectUtils.assertNotNull(this.getEditor());
            DeTable table = oldOne.getTable();
            ImportDatabaseTableEditor<?> newEditor = this.myMap.get(columns2);
            newEditor.update(table.name, table.comment);
            this.setEditor(newEditor);
            CompletableFuture<ImportDatabaseTableEditor<?>> completableFuture = CompletableFuture.completedFuture(newEditor);
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvTableEditorComponent", "notifyChanged"));
            }
            return completableFuture;
        }
        List<DataConsumer.Row> rows = object == null ? this.myContext.getBuilder().getRows() : ImportUtil.getRows(object);
        ImportDatabaseTableEditor<?> myEditor = this.createEditor(columns2, rows);
        this.setEditor(myEditor);
        this.myMap.put(columns2, myEditor);
        CompletableFuture<ImportDatabaseTableEditor<?>> completableFuture = CompletableFuture.completedFuture(myEditor);
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CsvTableEditorComponent", "notifyChanged"));
        }
        return completableFuture;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/database/dbimport/ui/csv/CsvTableEditorComponent", "dependsOn"));
        }
        return observer instanceof DdlPreviewComponent;
    }
}

