/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.tree;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbGoToSymbolProvider;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DatabaseGotoModel;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DatabaseChooseByNamePanel
extends ChooseByNamePanel {
    public DatabaseChooseByNamePanel(Project project, DatabaseChooseByNameModel model, String initialText, boolean isCheckboxVisible, PsiElement context) {
        super(project, (ChooseByNameModel)model, initialText, isCheckboxVisible, context);
    }

    protected boolean isCheckboxVisible() {
        return true;
    }

    protected static class DatabaseChooseByNameContributor
    extends DbGoToSymbolProvider {
        private final ObjectKind[] myKinds;

        public DatabaseChooseByNameContributor(ObjectKind ... kinds) {
            if (kinds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/database/dbimport/ui/tree/DatabaseChooseByNamePanel$DatabaseChooseByNameContributor", "<init>"));
            }
            this.myKinds = kinds;
        }

        @Override
        @NotNull
        protected JBTreeTraverser<DasObject> traverser(Project project) {
            JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)((JBTreeTraverser)super.traverser(project).expand(Conditions.not((Condition)DasUtil.byClass(DasSchemaChild.class)))).filter(obj -> ArrayUtil.contains((Object)obj.getKind(), (Object[])this.myKinds));
            if (jBTreeTraverser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/tree/DatabaseChooseByNamePanel$DatabaseChooseByNameContributor", "traverser"));
            }
            return jBTreeTraverser;
        }

        @NotNull
        public ObjectKind[] getKinds() {
            if (this.myKinds == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/tree/DatabaseChooseByNamePanel$DatabaseChooseByNameContributor", "getKinds"));
            }
            return this.myKinds;
        }
    }

    protected static class DatabaseChooseByNameModel
    extends DatabaseGotoModel {
        protected DatabaseChooseByNameModel(@NotNull Project project, DatabaseChooseByNameContributor ... contributors) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ui/tree/DatabaseChooseByNamePanel$DatabaseChooseByNameModel", "<init>"));
            }
            if (contributors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contributors", "com/intellij/database/dbimport/ui/tree/DatabaseChooseByNamePanel$DatabaseChooseByNameModel", "<init>"));
            }
            super(project, (ChooseByNameContributor[])contributors);
        }

        public String getPromptText() {
            THashSet myKinds = ContainerUtil.newIdentityTroveSet();
            for (ChooseByNameContributor contributor : this.getContributors()) {
                DatabaseChooseByNameContributor casted = (DatabaseChooseByNameContributor)contributor;
                myKinds.addAll(ContainerUtil.filter((Collection)ContainerUtil.list((Object[])casted.getKinds()), k -> k != ObjectKind.NONE));
            }
            String kinds = StringUtil.join((Collection)myKinds, k -> StringUtil.toLowerCase((String)k.toString()), (String)"/");
            return "Enter " + kinds + " name:";
        }
    }
}

