/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors.tz;

import com.intellij.database.extractors.tz.TimeZonedValue;
import com.intellij.openapi.util.Comparing;
import java.sql.Time;
import java.time.ZoneOffset;
import org.jetbrains.annotations.NotNull;

public class TimeZonedTime
extends TimeZonedValue<Time> {
    public TimeZonedTime(@NotNull Time time, @NotNull String stringRepresentation) {
        if (time == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "time", "com/intellij/database/extractors/tz/TimeZonedTime", "<init>"));
        }
        if (stringRepresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringRepresentation", "com/intellij/database/extractors/tz/TimeZonedTime", "<init>"));
        }
        super(time, stringRepresentation, 92);
    }

    @Override
    int getMinOffsetIndex() {
        return -1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeZonedTime)) {
            return false;
        }
        TimeZonedTime ttz = (TimeZonedTime)obj;
        return Comparing.equal(ttz.getValue(), this.getValue()) && Comparing.equal((Object)ttz.getZoneOffset(), (Object)this.getZoneOffset());
    }

    public int hashCode() {
        ZoneOffset offset = this.getZoneOffset();
        return ((Time)this.getValue()).hashCode() + 31 * (offset == null ? 0 : offset.hashCode());
    }
}

