/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SequenceIdentity
implements Cloneable,
Serializable {
    @Nullable
    public final BigInteger min;
    @Nullable
    public final BigInteger next;
    @NotNull
    public final BigInteger increment;
    @Nullable
    public final BigInteger max;
    private static final Pattern SPECIFICATION_PATTERN = Pattern.compile("^\\s*([-+]?\\d+)\\s*(\\(\\s*([-+]?\\d+)\\s*\\)\\s*)?(([-+]\\d+)\\s*)?(\\.\\.([-+]?\\d+)\\s*)?$");

    @NotNull
    public static SequenceIdentity of(@NotNull String specification) {
        if (specification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specification", "com/intellij/database/model/SequenceIdentity", "of"));
        }
        Matcher m = SPECIFICATION_PATTERN.matcher(specification);
        if (m.matches()) {
            int signum;
            BigInteger grpFrom = SequenceIdentity.grp(m, 1);
            BigInteger grpNext = SequenceIdentity.grp(m, 3);
            BigInteger grpInc = SequenceIdentity.grp(m, 5);
            BigInteger grpTill = SequenceIdentity.grp(m, 7);
            int n = signum = grpInc != null ? grpInc.signum() : 0;
            if (signum >= 0) {
                SequenceIdentity sequenceIdentity = SequenceIdentity.of(grpFrom, grpNext, grpInc, grpTill);
                if (sequenceIdentity == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/SequenceIdentity", "of"));
                }
                return sequenceIdentity;
            }
            SequenceIdentity sequenceIdentity = SequenceIdentity.of(grpTill, grpNext, grpInc, grpFrom);
            if (sequenceIdentity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/SequenceIdentity", "of"));
            }
            return sequenceIdentity;
        }
        throw new IllegalArgumentException("The string '" + specification + "' is not a valid sequence specification");
    }

    private static BigInteger grp(Matcher matcher, int groupNr) {
        String groupString = matcher.group(groupNr);
        return groupString != null ? new BigInteger(groupString) : null;
    }

    @NotNull
    public static SequenceIdentity of(@Nullable Long min, @Nullable Long next, @Nullable Long increment, @Nullable Long max) {
        SequenceIdentity sequenceIdentity = new SequenceIdentity(min == null ? null : BigInteger.valueOf(min), next == null ? null : BigInteger.valueOf(next), increment == null ? null : BigInteger.valueOf(increment), max == null ? null : BigInteger.valueOf(max));
        if (sequenceIdentity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/SequenceIdentity", "of"));
        }
        return sequenceIdentity;
    }

    @NotNull
    public static SequenceIdentity of(@Nullable BigInteger min, @Nullable BigInteger next, @Nullable BigInteger increment, @Nullable BigInteger max) {
        SequenceIdentity sequenceIdentity = new SequenceIdentity(min, next, increment, max);
        if (sequenceIdentity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/SequenceIdentity", "of"));
        }
        return sequenceIdentity;
    }

    private SequenceIdentity(@Nullable BigInteger min, @Nullable BigInteger next, @Nullable BigInteger increment, @Nullable BigInteger max) {
        this.min = min;
        this.next = next;
        this.increment = increment == null ? BigInteger.ONE : increment;
        this.max = max;
    }

    public final String getSpecification() {
        StringBuilder b = new StringBuilder(16);
        switch (this.increment.signum()) {
            case 1: {
                if (this.min != null) {
                    b.append(this.min);
                } else {
                    b.append("1");
                }
                if (!this.increment.equals(BigInteger.ONE)) {
                    b.append("+").append(this.increment);
                }
                if (this.max == null) break;
                b.append('.').append('.').append(this.max);
                break;
            }
            case -1: {
                b.append(this.max);
                b.append(this.increment);
                if (this.min == null) break;
                b.append('.').append('.').append(this.min);
                break;
            }
            default: {
                if (this.min != null) {
                    b.append(this.min);
                }
                b.append('.').append('.');
                if (this.max == null) break;
                b.append(this.max);
            }
        }
        return b.toString();
    }

    public String toString() {
        return this.getSpecification();
    }

    protected Object clone() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceIdentity that = (SequenceIdentity)o;
        return Objects.equals(this.min, that.min) && Objects.equals(this.next, that.next) && Objects.equals(this.increment, that.increment) && Objects.equals(this.max, that.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.next, this.increment, this.max);
    }
}

