/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelReader;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMateNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public interface BasicModel
extends DasModel {
    @NotNull
    default public Rdbms getRdbms() {
        Rdbms rdbms = UnknownDatabase.RDBMS;
        if (rdbms == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicModel", "getRdbms"));
        }
        return rdbms;
    }

    @NotNull
    public BasicRoot getRoot();

    default public <V> V read(@NotNull ModelReader<? super BasicModel, V> reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/model/basic/BasicModel", "read"));
        }
        return reader.perform(this);
    }

    @NotNull
    default public JBIterable<? extends DasObject> getModelRoots() {
        JBIterable jBIterable = JBIterable.from(this.getRoot().getNamespaces());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicModel", "getModelRoots"));
        }
        return jBIterable;
    }

    @Nullable
    default public DasNamespace getCurrentRootNamespace() {
        NamingFamily<? extends BasicMateNamespace> namespaces = this.getRoot().getNamespaces();
        for (BasicMateNamespace basicMateNamespace : namespaces) {
            if (!basicMateNamespace.isCurrent()) continue;
            return basicMateNamespace;
        }
        return null;
    }

    @NotNull
    default public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots(this.getRoot().getNamespaces());
        if (jBTreeTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicModel", "traverser"));
        }
        return jBTreeTraverser;
    }

    @NotNull
    default public JBTreeTraverser<BasicElement> traverser(boolean hidden) {
        if (hidden) {
            JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)new JBTreeTraverser(x -> x.getDbChildren()).withRoots(this.getRoot().getDbChildren());
            if (jBTreeTraverser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicModel", "traverser"));
            }
            return jBTreeTraverser;
        }
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)new JBTreeTraverser(x -> x.getDbChildren(BasicElement.class, ObjectKind.NONE)).withRoots(this.getRoot().getDbChildren(BasicElement.class, ObjectKind.NONE));
        if (jBTreeTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicModel", "traverser"));
        }
        return jBTreeTraverser;
    }

    @Deprecated
    @NotNull
    public JBIterable<? extends DasConstraint> getExportedKeys(DasTable var1);

    @Deprecated
    @NotNull
    default public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/model/basic/BasicModel", "getCasing"));
        }
        Casing casing = this.getRoot().getCasing(kind, context);
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicModel", "getCasing"));
        }
        return casing;
    }
}

