/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.generic;

import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.generic.GenericArgument;
import com.intellij.database.model.generic.GenericInnerRoutine;
import com.intellij.database.model.generic.GenericPackage;
import com.intellij.database.model.generic.GenericSchema;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GenericPackageRoutine
extends GenericInnerRoutine {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ROUTINE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericPackageRoutine", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public GenericPackage getPackage();

    @Override
    @Nullable
    default public GenericPackage getDbParent() {
        return this.getPackage();
    }

    @Nullable
    default public GenericPackage getMajorObject() {
        return this.getPackage();
    }

    default public @Nullable NamingFamily<@NotNull ? extends GenericPackageRoutine> getParentFamily() {
        return null;
    }

    @Nullable
    default public GenericSchema getSchema() {
        GenericPackage pack = this.getPackage();
        return pack != null ? pack.getSchema() : null;
    }

    @Override
    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends GenericArgument> getArguments();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.ARGUMENT);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericPackageRoutine", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Iterable> list = Collections.singletonList(this.getArguments());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericPackageRoutine", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getArguments());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericPackageRoutine", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public DasRoutine.Kind getRoutineKind() {
        DasRoutine.Kind kind = DasRoutine.Kind.NONE;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericPackageRoutine", "getRoutineKind"));
        }
        return kind;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        DasRoutine.Kind routineKind;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/generic/GenericPackageRoutine", "exportProperties"));
        }
        String name = this.getName();
        if (name != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((routineKind = this.getRoutineKind()) != null && routineKind != DasRoutine.Kind.NONE) {
            consumer.accept("RoutineKind", PropertyConverter.export((Enum)routineKind));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "RoutineKind");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericPackageRoutine", "getPropertyNames"));
        }
        return list;
    }

    @Override
    default public String getPackageName() {
        return ModelUtil.nameOf(this.getPackage());
    }
}

