/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mysql;

import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicModColumn;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.mysql.MysqlModLikeColumn;
import com.intellij.database.model.mysql.MysqlModSchema;
import com.intellij.database.model.mysql.MysqlModView;
import com.intellij.database.model.mysql.MysqlViewColumn;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MysqlModViewColumn
extends MysqlViewColumn,
MysqlModLikeColumn,
BasicModColumn {
    @Override
    @NotNull
    public MysqlModView getView();

    @Override
    @NotNull
    default public MysqlModView getDbParent() {
        MysqlModView mysqlModView = this.getView();
        if (mysqlModView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModViewColumn", "getDbParent"));
        }
        return mysqlModView;
    }

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends MysqlModViewColumn> getParentFamily();

    @Override
    @NotNull
    default public MysqlModSchema getSchema() {
        MysqlModSchema mysqlModSchema = this.getView().getSchema();
        if (mysqlModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModViewColumn", "getSchema"));
        }
        return mysqlModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModViewColumn", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModViewColumn", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setPosition(short var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setDataType(@NotNull DataType var1);

    @Override
    public void setNotNull(boolean var1);

    @Override
    public void setDefaultExpression(@Nullable String var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/mysql/MysqlModViewColumn", "importProperties"));
        }
        String position = properties.get("Position");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String dataType = properties.get("DataType");
        String notNull = properties.get("NotNull");
        String defaultExpression = properties.get("DefaultExpression");
        if (position != null) {
            this.setPosition(PropertyConverter.importShort(position));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (dataType != null) {
            this.setDataType(PropertyConverter.importDataType(dataType));
        }
        if (notNull != null) {
            this.setNotNull(PropertyConverter.importBoolean(notNull));
        }
        if (defaultExpression != null) {
            this.setDefaultExpression(PropertyConverter.importString(defaultExpression));
        }
    }
}

