/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.oracle.OraCheck;
import com.intellij.database.model.oracle.OraForeignKey;
import com.intellij.database.model.oracle.OraIndex;
import com.intellij.database.model.oracle.OraKey;
import com.intellij.database.model.oracle.OraLikeTable;
import com.intellij.database.model.oracle.OraMajorObject;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraStoredSchemaObject;
import com.intellij.database.model.oracle.OraTableColumn;
import com.intellij.database.model.oracle.OraTableTrigger;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraTable
extends OraMajorObject,
OraLikeTable,
OraStoredSchemaObject,
BasicTable {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraTable", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public OraSchema getSchema();

    @Override
    @Nullable
    default public OraSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraTable> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends OraTableColumn> getColumns();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraIndex> getIndices();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraKey> getKeys();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraForeignKey> getForeignKeys();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraCheck> getChecks();

    @NotNull
    public @NotNull NamingIdentifyingFamily<@NotNull ? extends OraTableTrigger> getTriggers();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.INDEX, ObjectKind.KEY, ObjectKind.FOREIGN_KEY, ObjectKind.CHECK, ObjectKind.TRIGGER);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraTable", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getColumns()).append((Iterable)this.getIndices()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys()).append((Iterable)this.getChecks()).append(this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public String getRowTypeSchemaName() {
        return null;
    }

    @Override
    @Nullable
    default public String getRowTypeObjectName() {
        return null;
    }

    @Override
    default public boolean isSystem() {
        return false;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public String getTablespaceName() {
        return null;
    }

    @Override
    default public boolean isTemporary() {
        return false;
    }

    default public boolean isTemporaryPreserve() {
        return false;
    }

    @NotNull
    default public TableOrganization getOrganization() {
        TableOrganization tableOrganization = TableOrganization.DEFAULT;
        if (tableOrganization == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraTable", "getOrganization"));
        }
        return tableOrganization;
    }

    @Nullable
    default public String getClusterName() {
        return null;
    }

    @NotNull
    default public List<String> getClusterColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraTable", "getClusterColNames"));
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        List<String> clusterColNames;
        String clusterName;
        TableOrganization organization;
        boolean temporaryPreserve;
        boolean temporary;
        String tablespaceName;
        Date modifiedTimestamp;
        Date createdTimestamp;
        boolean system;
        String rowTypeObjectName;
        String rowTypeSchemaName;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/oracle/OraTable", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((rowTypeSchemaName = this.getRowTypeSchemaName()) != null) {
            consumer.accept("RowTypeSchemaName", PropertyConverter.export(rowTypeSchemaName));
        }
        if ((rowTypeObjectName = this.getRowTypeObjectName()) != null) {
            consumer.accept("RowTypeObjectName", PropertyConverter.export(rowTypeObjectName));
        }
        if (system = this.isSystem()) {
            consumer.accept("System", PropertyConverter.export(system));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if ((tablespaceName = this.getTablespaceName()) != null) {
            consumer.accept("TablespaceName", PropertyConverter.export(tablespaceName));
        }
        if (temporary = this.isTemporary()) {
            consumer.accept("Temporary", PropertyConverter.export(temporary));
        }
        if (temporaryPreserve = this.isTemporaryPreserve()) {
            consumer.accept("TemporaryPreserve", PropertyConverter.export(temporaryPreserve));
        }
        if ((organization = this.getOrganization()) != null && organization != TableOrganization.DEFAULT) {
            consumer.accept("Organization", PropertyConverter.export(organization));
        }
        if ((clusterName = this.getClusterName()) != null) {
            consumer.accept("ClusterName", PropertyConverter.export(clusterName));
        }
        if (!(clusterColNames = this.getClusterColNames()).isEmpty()) {
            consumer.accept("ClusterColNames", PropertyConverter.exportListOfString(clusterColNames));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "RowTypeSchemaName", "RowTypeObjectName", "System", "CreatedTimestamp", "ModifiedTimestamp", "TablespaceName", "Temporary", "TemporaryPreserve", "Organization", "ClusterName", "ClusterColNames");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraTable", "getPropertyNames"));
        }
        return list;
    }
}

