/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.redshift;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.postgresbase.PostgresBaseModTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.RedshiftTableBackupMode;
import com.intellij.database.model.properties.RedshiftTableDistStyle;
import com.intellij.database.model.redshift.RedshiftModForeignKey;
import com.intellij.database.model.redshift.RedshiftModKey;
import com.intellij.database.model.redshift.RedshiftModLikeStoredTable;
import com.intellij.database.model.redshift.RedshiftModSchema;
import com.intellij.database.model.redshift.RedshiftModTableColumn;
import com.intellij.database.model.redshift.RedshiftTable;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RedshiftModTable
extends RedshiftTable,
RedshiftModLikeStoredTable,
PostgresBaseModTable {
    @Override
    @NotNull
    public RedshiftModSchema getSchema();

    @Override
    @NotNull
    default public RedshiftModSchema getDbParent() {
        RedshiftModSchema redshiftModSchema = this.getSchema();
        if (redshiftModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModTable", "getDbParent"));
        }
        return redshiftModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModTable> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends RedshiftModTableColumn> getColumns();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModKey> getKeys();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends RedshiftModForeignKey> getForeignKeys();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getKeys(), this.getForeignKeys());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/redshift/RedshiftModTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    @Override
    public void setStateNumber(long var1);

    public void setDistStyle(@NotNull RedshiftTableDistStyle var1);

    public void setBackupMode(@NotNull RedshiftTableBackupMode var1);

    @Override
    public void setTemporary(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/redshift/RedshiftModTable", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String system = properties.get("System");
        String stateNumber = properties.get("StateNumber");
        String distStyle = properties.get("DistStyle");
        String backupMode = properties.get("BackupMode");
        String temporary = properties.get("Temporary");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (system != null) {
            this.setSystem(PropertyConverter.importBoolean(system));
        }
        if (stateNumber != null) {
            this.setStateNumber(PropertyConverter.importLong(stateNumber));
        }
        if (distStyle != null) {
            this.setDistStyle(PropertyConverter.importRedshiftTableDistStyle(distStyle));
        }
        if (backupMode != null) {
            this.setBackupMode(PropertyConverter.importRedshiftTableBackupMode(backupMode));
        }
        if (temporary != null) {
            this.setTemporary(PropertyConverter.importBoolean(temporary));
        }
    }
}

