/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sqlite;

import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModColumn;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.model.sqlite.SqliteModLikeColumn;
import com.intellij.database.model.sqlite.SqliteModSchema;
import com.intellij.database.model.sqlite.SqliteModTable;
import com.intellij.database.model.sqlite.SqliteTableColumn;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqliteModTableColumn
extends SqliteTableColumn,
SqliteModLikeColumn,
BasicModColumn {
    @Override
    @NotNull
    public SqliteModTable getTable();

    @Override
    @NotNull
    default public SqliteModTable getDbParent() {
        SqliteModTable sqliteModTable = this.getTable();
        if (sqliteModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteModTableColumn", "getDbParent"));
        }
        return sqliteModTable;
    }

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends SqliteModTableColumn> getParentFamily();

    @Override
    @NotNull
    default public SqliteModSchema getSchema() {
        SqliteModSchema sqliteModSchema = this.getTable().getSchema();
        if (sqliteModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteModTableColumn", "getSchema"));
        }
        return sqliteModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteModTableColumn", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteModTableColumn", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setPosition(short var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setDataType(@NotNull DataType var1);

    @Override
    public void setNotNull(boolean var1);

    public void setCollation(@Nullable String var1);

    @Override
    public void setSequenceIdentity(@Nullable SequenceIdentity var1);

    @Override
    public void setDefaultExpression(@Nullable String var1);

    public void setOnNullConflict(@Nullable SqliteOnConflictAlgorithm var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/sqlite/SqliteModTableColumn", "importProperties"));
        }
        String position = properties.get("Position");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String dataType = properties.get("DataType");
        String notNull = properties.get("NotNull");
        String collation = properties.get("Collation");
        String sequenceIdentity = properties.get("SequenceIdentity");
        String defaultExpression = properties.get("DefaultExpression");
        String onNullConflict = properties.get("OnNullConflict");
        if (position != null) {
            this.setPosition(PropertyConverter.importShort(position));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (dataType != null) {
            this.setDataType(PropertyConverter.importDataType(dataType));
        }
        if (notNull != null) {
            this.setNotNull(PropertyConverter.importBoolean(notNull));
        }
        if (collation != null) {
            this.setCollation(PropertyConverter.importString(collation));
        }
        if (sequenceIdentity != null) {
            this.setSequenceIdentity(PropertyConverter.importSequenceIdentity(sequenceIdentity));
        }
        if (defaultExpression != null) {
            this.setDefaultExpression(PropertyConverter.importString(defaultExpression));
        }
        if (onNullConflict != null) {
            this.setOnNullConflict(PropertyConverter.importSqliteOnConflictAlgorithm(onNullConflict));
        }
    }
}

