/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakHashMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbPsiFacadeImpl
extends DbPsiFacade {
    @NotNull
    private final Project myProject;
    @NotNull
    private final EventDispatcher<ModificationTrackerListener> myDispatcher;
    @NotNull
    private final Map<DatabaseSystem, DbDataSource> myDataSourceMap;
    @Nullable
    private volatile State myState;
    @NotNull
    private final Alarm myAlarm;

    public DbPsiFacadeImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/psi/DbPsiFacadeImpl", "<init>"));
        }
        this.myDispatcher = EventDispatcher.create(ModificationTrackerListener.class);
        this.myDataSourceMap = new WeakHashMap();
        this.myProject = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myProject);
    }

    @NotNull
    public List<DbPsiManager> getDbManagers() {
        List<DbPsiManager> list = this.getState().managers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPsiFacadeImpl", "getDbManagers"));
        }
        return list;
    }

    public void clearCaches(@Nullable DbDataSource selectedElement) {
        this.incModificationCount();
        if (selectedElement == null) {
            this.myState = null;
        } else {
            selectedElement.clearCaches();
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> {
            ((ModificationTrackerListener)this.myDispatcher.getMulticaster()).modificationCountChanged((Object)this);
            PsiManager.getInstance((Project)this.myProject).dropResolveCaches();
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)this.getProject());
            String id = selectedElement == null ? null : selectedElement.getUniqueId();
            for (VirtualFile file : DatabaseVirtualFileSystem.getDatabaseFileSystem().getCachedFiles()) {
                DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)((Object)((Object)ObjectUtils.tryCast((Object)file, DatabaseElementVirtualFileImpl.class)));
                if (dbFile == null || id != null && dbFile.getDataSourceId() == id) continue;
                fileEditorManagerEx.updateFilePresentation(file);
            }
        }, 300, ModalityState.defaultModalityState());
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPsiFacadeImpl", "getProject"));
        }
        return project;
    }

    @NotNull
    public List<DbDataSource> getDataSources() {
        List<DbDataSource> list = this.getState().dataSources;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPsiFacadeImpl", "getDataSources"));
        }
        return list;
    }

    @Nullable
    public DbDataSource findDataSource(String id) {
        return this.getState().dataSourcesMap.get(id);
    }

    public void addModificationTrackerListener(ModificationTrackerListener<DbPsiFacade> listener, Disposable parent) {
        this.myDispatcher.addListener(listener, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public DbDataSource createDataSourceWrapperElement(@NotNull DatabaseSystem info, @NotNull DbPsiManagerSpi manager) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/psi/DbPsiFacadeImpl", "createDataSourceWrapperElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/psi/DbPsiFacadeImpl", "createDataSourceWrapperElement"));
        }
        Map<DatabaseSystem, DbDataSource> map = this.myDataSourceMap;
        // MONITORENTER : map
        DbDataSource dataSource = this.myDataSourceMap.get(info);
        if (dataSource == null) {
            dataSource = new DbDataSourceImpl(this.getProject(), info, manager);
            this.myDataSourceMap.put(info, dataSource);
        }
        DbDataSource dbDataSource = dataSource;
        // MONITOREXIT : map
        if (dbDataSource != null) return dbDataSource;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPsiFacadeImpl", "createDataSourceWrapperElement"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private State getState() {
        State state;
        State curState = this.myState;
        if (curState != null) {
            State state2 = curState;
            if (state2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPsiFacadeImpl", "getState"));
            }
            return state2;
        }
        if (this.myProject.isDefault()) {
            state = new State(Collections.emptyList(), Collections.emptyList());
        } else {
            DbPsiManagerSpi[] managers = (DbPsiManagerSpi[])Extensions.getExtensions(DbPsiManagerSpi.EP_NAME, (AreaInstance)this.myProject);
            ArrayList result2 = ContainerUtil.newArrayList();
            for (DbPsiManagerSpi manager : managers) {
                result2.addAll(manager.getDataSources());
            }
            state = new State((List<DbPsiManagerSpi>)ContainerUtil.immutableList((Object[])managers), (List<DbDataSource>)ContainerUtil.immutableList((List)result2));
        }
        this.myState = state;
        Map<DatabaseSystem, DbDataSource> map = this.myDataSourceMap;
        synchronized (map) {
            this.myDataSourceMap.values().retainAll(state.dataSources);
        }
        State state3 = state;
        if (state3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPsiFacadeImpl", "getState"));
        }
        return state3;
    }

    private static class State {
        @NotNull
        final List<DbPsiManagerSpi> managers;
        @NotNull
        final List<DbDataSource> dataSources;
        @NotNull
        final Map<String, DbDataSource> dataSourcesMap;

        State(@NotNull List<DbPsiManagerSpi> managers, @NotNull List<DbDataSource> dataSources) {
            if (managers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managers", "com/intellij/database/psi/DbPsiFacadeImpl$State", "<init>"));
            }
            if (dataSources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/psi/DbPsiFacadeImpl$State", "<init>"));
            }
            this.managers = managers;
            this.dataSources = dataSources;
            this.dataSourcesMap = dataSources.isEmpty() ? Collections.emptyMap() : new THashMap();
            for (DbDataSource dataSource : dataSources) {
                this.dataSourcesMap.put(dataSource.getUniqueId(), dataSource);
            }
        }
    }
}

