/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class SubmitMutations
extends DumbAwareAction
implements GridAction {
    public void update(AnActionEvent e) {
        if (!SubmitMutations.isVisible(e)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(SubmitMutations.hasChangesToSubmit(e));
    }

    public void actionPerformed(AnActionEvent e) {
        SubmitMutations.submitChangesIfExists(e);
    }

    public static boolean hasChangesToSubmit(AnActionEvent e) {
        if (!SubmitMutations.isVisible(e)) {
            return false;
        }
        DataGrid dataGrid = (DataGrid)ObjectUtils.notNull((Object)DataGridUtil.getDataGrid(e.getDataContext()));
        GridDataSupport support = dataGrid.getDataSupport();
        return support.hasPendingChanges() && !dataGrid.isEditing();
    }

    @NotNull
    public static ActionCallback submitChangesIfExists(AnActionEvent e) {
        if (!SubmitMutations.hasChangesToSubmit(e)) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/SubmitMutations", "submitChangesIfExists"));
            }
            return actionCallback;
        }
        DataGrid dataGrid = (DataGrid)ObjectUtils.notNull((Object)DataGridUtil.getDataGrid(e.getDataContext()));
        ActionCallback actionCallback = dataGrid.submit();
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/SubmitMutations", "submitChangesIfExists"));
        }
        return actionCallback;
    }

    private static boolean isVisible(AnActionEvent e) {
        DataGrid dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
        if (dataGrid == null) {
            return false;
        }
        GridDataSupport support = dataGrid.getDataSupport();
        return (!support.isSubmitImmediately() || support.hasPendingChanges()) && !dataGrid.getDataHookup().isReadOnly();
    }
}

