/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.sql.Timestamp;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BoundaryValueResolver {
    ALWAYS_NULL{

        @Override
        Object create(long time, @NotNull String string) {
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$1", "create"));
            }
            return null;
        }

        @Override
        long getValue(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$1", "getValue"));
            }
            return value instanceof Date ? ((Date)value).getTime() : 0L;
        }
    }
    ,
    DATE((Class)java.sql.Date.class, (DatabaseDialect)PostgresDialect.INSTANCE, (Long)185331707067600000L, (Long)-210870001784001L, (Long)9223372036825200000L, (Long)-9223372036832400000L, "infinity", "-infinity", new String[]{"date", "daterange"}){

        @Override
        Object create(long time, @NotNull String string) {
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$2", "create"));
            }
            return new java.sql.Date(time);
        }

        @Override
        long getValue(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$2", "getValue"));
            }
            return ((Date)value).getTime();
        }
    }
    ,
    TIMESTAMP((Class)Timestamp.class, (DatabaseDialect)PostgresDialect.INSTANCE, (Long)9224318710854775L, (Long)-210870001784001L, (Long)9223372036825200000L, (Long)-9223372036832400000L, "infinity", "-infinity", new String[]{"timestamp", "tsrange"}){

        @Override
        Object create(long time, @NotNull String string) {
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$3", "create"));
            }
            return new Timestamp(time);
        }

        @Override
        long getValue(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$3", "getValue"));
            }
            Timestamp timestamp = (Timestamp)value;
            return timestamp.getTime();
        }
    }
    ,
    TIMESTAMP_TZ((Class)TimeZonedTimestamp.class, (DatabaseDialect)PostgresDialect.INSTANCE, (Long)9224318710854775L, (Long)-210870001784001L, (Long)9223372036825200000L, (Long)-9223372036832400000L, "infinity", "-infinity", new String[]{"timestamptz", "tstzrange"}){

        /*
         * WARNING - void declaration
         */
        @Override
        Object create(long time, @NotNull String string) {
            void value;
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$4", "create"));
            }
            Timestamp timestamp = new Timestamp(time);
            return new TimeZonedTimestamp(timestamp, (String)value);
        }

        @Override
        long getValue(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver$4", "getValue"));
            }
            TimeZonedTimestamp zonedTimestamp = (TimeZonedTimestamp)value;
            return ((Timestamp)zonedTimestamp.getValue()).getTime();
        }
    };

    @NotNull
    private final String[] myTypeNames;
    @Nullable
    private final Class<?> myObjectClass;
    @Nullable
    private final DatabaseDialect myDialect;
    @Nullable
    private final Long myPositiveInfinityMinValue;
    @Nullable
    private final Long myPositiveInfinityValue;
    @Nullable
    private final Long myNegativeInfinityMaxValue;
    @Nullable
    private final Long myNegativeInfinityValue;
    @Nullable
    private final String myPositiveInfinityString;
    @Nullable
    private final String myNegativeInfinityString;

    private BoundaryValueResolver() {
        this(null, null, null, null, null, null, null, null, new String[0]);
    }

    private BoundaryValueResolver(@Nullable Class<?> objectClass, @Nullable DatabaseDialect dialect, @Nullable Long positiveInfinityMinValue, @Nullable Long negativeInfinityMaxValue, @Nullable Long positiveInfinityValue, @Nullable Long negativeInfinityValue, @NotNull String positiveInfinityString, String negativeInfinityString, String ... typeNames) {
        if (typeNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeNames", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver", "<init>"));
        }
        this.myObjectClass = objectClass;
        this.myDialect = dialect;
        this.myTypeNames = typeNames;
        this.myPositiveInfinityMinValue = positiveInfinityMinValue;
        this.myNegativeInfinityMaxValue = negativeInfinityMaxValue;
        this.myPositiveInfinityValue = positiveInfinityValue;
        this.myNegativeInfinityValue = negativeInfinityValue;
        this.myPositiveInfinityString = positiveInfinityString;
        this.myNegativeInfinityString = negativeInfinityString;
    }

    @Nullable
    public String resolve(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver", "resolve"));
        }
        if (value.getClass() != this.myObjectClass) {
            return null;
        }
        long objectValue = this.getValue(value);
        return this.getBoundaryString(objectValue);
    }

    @Nullable
    public Object createFromBoundary(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver", "createFromBoundary"));
        }
        if (StringUtil.equalsIgnoreWhitespaces((CharSequence)value, (CharSequence)this.myPositiveInfinityString)) {
            return this.create((Long)ObjectUtils.assertNotNull((Object)this.myPositiveInfinityValue), value);
        }
        if (StringUtil.equalsIgnoreWhitespaces((CharSequence)value, (CharSequence)this.myNegativeInfinityString)) {
            return this.create((Long)ObjectUtils.assertNotNull((Object)this.myNegativeInfinityValue), value);
        }
        return null;
    }

    @NotNull
    public static BoundaryValueResolver getResolver(@Nullable DatabaseDialect dialect, @Nullable DataConsumer.Column column) {
        for (BoundaryValueResolver resolver : BoundaryValueResolver.values()) {
            boolean columnTypeEquals = StringUtil.findIgnoreCase((String)(column == null ? null : column.typeName), (String[])resolver.myTypeNames);
            if (dialect != resolver.myDialect || !columnTypeEquals) continue;
            BoundaryValueResolver boundaryValueResolver = resolver;
            if (boundaryValueResolver == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver", "getResolver"));
            }
            return boundaryValueResolver;
        }
        BoundaryValueResolver boundaryValueResolver = ALWAYS_NULL;
        if (boundaryValueResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver", "getResolver"));
        }
        return boundaryValueResolver;
    }

    @Nullable
    public static String getBoundaryString(@Nullable DatabaseDialect dialect, @Nullable DataConsumer.Column column, long time) {
        return BoundaryValueResolver.getResolver(dialect, column).getBoundaryString(time);
    }

    @Nullable
    public String getBoundaryString(long value) {
        if (this.myPositiveInfinityMinValue != null && this.myPositiveInfinityMinValue <= value) {
            return this.myPositiveInfinityString;
        }
        if (this.myNegativeInfinityMaxValue != null && this.myNegativeInfinityMaxValue >= value) {
            return this.myNegativeInfinityString;
        }
        return null;
    }

    long getLowerBound(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/run/ui/grid/editors/BoundaryValueResolver", "getLowerBound"));
        }
        long time = this.getValue(object);
        if (this.myPositiveInfinityMinValue != null && this.myPositiveInfinityMinValue <= time) {
            return this.myPositiveInfinityMinValue;
        }
        if (this.myNegativeInfinityMaxValue != null && this.myNegativeInfinityMaxValue >= time) {
            return this.myNegativeInfinityMaxValue;
        }
        return time;
    }

    @Nullable
    abstract Object create(long var1, @NotNull String var3);

    abstract long getValue(@NotNull Object var1);

    static class Infinity {
        static final String PG_POSITIVE_INFINITY = "infinity";
        static final String PG_NEGATIVE_INFINITY = "-infinity";
        static final long PG_TS_MIN_POSITIVE_INFINITY_TIME = 9224318710854775L;
        static final long PG_POSITIVE_INFINITY_TIME = 9223372036825200000L;
        static final long PG_DATE_MIN_POSITIVE_INFINITY_TIME = 185331707067600000L;
        static final long PG_NEGATIVE_INFINITY_TIME = -9223372036832400000L;
        static final long PG_MAX_NEGATIVE_INFINITY_TIME = -210870001784001L;

        Infinity() {
        }
    }
}

