/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.google.common.collect.Iterables;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeArgument;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeConstraint;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeRoutine;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.schemaEditor.model.DeTrigger;
import com.intellij.database.schemaEditor.model.DeView;
import com.intellij.database.schemaEditor.model.DeWrapper;
import com.intellij.database.schemaEditor.model.DeWrapperImpl;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DasSchemaExporters {
    public static SchemaExporters createDefaultExporters() {
        SchemaExporters dasSchemaExporter = new SchemaExporters();
        dasSchemaExporter.add(new DeObjectCloner());
        dasSchemaExporter.add(new DeTableExporter());
        dasSchemaExporter.add(new DeColumnExporter());
        dasSchemaExporter.add(new DeIndexExporter());
        dasSchemaExporter.add(new DeForeignKeyExporter());
        dasSchemaExporter.add(new DeTableKeyExporter());
        dasSchemaExporter.add(new DeNamespaceExporter());
        dasSchemaExporter.add(new DeRoutineExporter());
        dasSchemaExporter.add(new DeArgumentExporter());
        dasSchemaExporter.add(new DeViewExporter());
        dasSchemaExporter.add(new DeMatViewExporter());
        dasSchemaExporter.add(new DeObjectTypeExporter());
        dasSchemaExporter.add(new DePackageExporter());
        dasSchemaExporter.add(new DeBodyExporter());
        dasSchemaExporter.add(new DeTriggerExporter());
        return dasSchemaExporter;
    }

    protected static class DeMatViewExporter
    extends DeGenericExporter {
        public DeMatViewExporter() {
            super(ObjectKind.MAT_VIEW);
        }
    }

    protected static class DeBodyExporter
    extends DeGenericExporter {
        public DeBodyExporter() {
            super(ObjectKind.BODY);
        }
    }

    protected static class DePackageExporter
    extends DeGenericExporter {
        public DePackageExporter() {
            super(ObjectKind.PACKAGE);
        }
    }

    protected static class DeObjectTypeExporter
    extends DeGenericExporter {
        public DeObjectTypeExporter() {
            super(ObjectKind.OBJECT_TYPE);
        }
    }

    protected static class DeGenericExporter
    extends DeObjectExporter<DeWrapperImpl<DasObject>, DasObject> {
        public DeGenericExporter(@NotNull ObjectKind kindFilter) {
            if (kindFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kindFilter", "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter", "<init>"));
            }
            super(DeWrapperImpl.class, DasObject.class, kindFilter);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeWrapperImpl<DasObject> to, @NotNull DasObject from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter", "lightExport"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter", "lightExport"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter", "lightExport"));
            }
            super.lightExport(helper, to, from);
            to.parent = helper.export(from.getDbParent(), false);
            if (to.parent == null) {
                to.model.addRoot(to);
            }
        }

        @Override
        @NotNull
        public DeWrapperImpl<DasObject> create(@NotNull SchemaExportHelper helper, @NotNull DasObject from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter", "create"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter", "create"));
            }
            DeWrapperImpl<DasObject> deWrapperImpl = new DeWrapperImpl<DasObject>(DeGenericExporter.getName(helper, from), helper.getModel(), null);
            if (deWrapperImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter", "create"));
            }
            return deWrapperImpl;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull DeWrapperImpl<DasObject> to, @NotNull DasObject from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter", "exportChildren"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter", "exportChildren"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter", "exportChildren"));
            }
        }
    }

    protected static class DeNamespaceExporter
    extends DeObjectExporter<DeNamespace, DasNamespace> {
        public DeNamespaceExporter() {
            super(DeNamespace.class, DasNamespace.class, null);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeNamespace to, @NotNull DasNamespace from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter", "lightExport"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter", "lightExport"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter", "lightExport"));
            }
            super.lightExport(helper, to, from);
            to.parent = (DeNamespace)helper.export((DasObject)ObjectUtils.tryCast((Object)from.getDbParent(), DasNamespace.class), false);
            if (to.parent == null) {
                to.model.addRoot(to);
            }
        }

        @Override
        @NotNull
        public DeNamespace create(@NotNull SchemaExportHelper helper, @NotNull DasNamespace from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter", "create"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter", "create"));
            }
            DeNamespace deNamespace = new DeNamespace(DeNamespaceExporter.getName(helper, (DasObject)from), from.getKind(), helper.getModel());
            if (deNamespace == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter", "create"));
            }
            return deNamespace;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull DeNamespace to, @NotNull DasNamespace from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter", "exportChildren"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter", "exportChildren"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter", "exportChildren"));
            }
            for (DasObject object : DasUtil.getDbChildren((DasObject)from, (DasModel)helper.getContext().getModel(), DasObject.class, (ObjectKind)ObjectKind.NONE)) {
                if (!helper.canExport(object)) continue;
                to.children.add((DeObject)helper.export(object, true));
            }
        }
    }

    protected static class DeArgumentExporter
    extends DeObjectExporter<DeArgument, DasArgument> {
        public DeArgumentExporter() {
            super(DeArgument.class, DasArgument.class, ObjectKind.ARGUMENT);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeArgument to, @NotNull DasArgument from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeArgumentExporter", "lightExport"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeArgumentExporter", "lightExport"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeArgumentExporter", "lightExport"));
            }
            super.lightExport(helper, to, from);
            to.routine = (DeRoutine)helper.export(from.getDbParent(), false);
        }

        @Override
        @NotNull
        public DeArgument create(@NotNull SchemaExportHelper helper, @NotNull DasArgument from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeArgumentExporter", "create"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeArgumentExporter", "create"));
            }
            DeArgument deArgument = new DeArgument(DeArgumentExporter.getName(helper, (DasObject)from), helper.getModel(), null);
            if (deArgument == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeArgumentExporter", "create"));
            }
            return deArgument;
        }
    }

    protected static class DeTriggerExporter
    extends DeDumbExporter<DeTrigger, DasTrigger> {
        public DeTriggerExporter() {
            super(DeTrigger.class, DasTrigger.class, ObjectKind.TRIGGER);
        }

        @Override
        @NotNull
        public DeTrigger create(@NotNull SchemaExportHelper helper, @NotNull DasTrigger from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTriggerExporter", "create"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTriggerExporter", "create"));
            }
            DeTrigger deTrigger = new DeTrigger(DeTriggerExporter.getName(helper, (DasObject)from), helper.getModel(), null);
            if (deTrigger == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTriggerExporter", "create"));
            }
            return deTrigger;
        }
    }

    protected static class DeViewExporter
    extends DeDumbExporter<DeView, DasTable> {
        public DeViewExporter() {
            super(DeView.class, DasTable.class, ObjectKind.VIEW);
        }

        @Override
        @NotNull
        public DeView create(@NotNull SchemaExportHelper helper, @NotNull DasTable from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeViewExporter", "create"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeViewExporter", "create"));
            }
            DeView deView = new DeView(DeViewExporter.getName(helper, (DasObject)from), helper.getModel(), null);
            if (deView == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeViewExporter", "create"));
            }
            return deView;
        }
    }

    protected static class DeRoutineExporter
    extends DeDumbExporter<DeRoutine, DasRoutine> {
        public DeRoutineExporter() {
            super(DeRoutine.class, DasRoutine.class, ObjectKind.ROUTINE);
        }

        @Override
        @NotNull
        public DeRoutine create(@NotNull SchemaExportHelper helper, @NotNull DasRoutine from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeRoutineExporter", "create"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeRoutineExporter", "create"));
            }
            DeRoutine deRoutine = new DeRoutine(DeRoutineExporter.getName(helper, (DasObject)from), helper.getModel(), null);
            if (deRoutine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeRoutineExporter", "create"));
            }
            return deRoutine;
        }
    }

    protected static abstract class DeDumbExporter<De extends DeWrapper, Das extends DasObject>
    extends DeObjectExporter<De, Das> {
        public DeDumbExporter(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportedClass", "com/intellij/database/schemaEditor/DasSchemaExporters$DeDumbExporter", "<init>"));
            }
            if (exportableClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportableClass", "com/intellij/database/schemaEditor/DasSchemaExporters$DeDumbExporter", "<init>"));
            }
            super(exportedClass, exportableClass, kindFilter);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeDumbExporter", "lightExport"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeDumbExporter", "lightExport"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeDumbExporter", "lightExport"));
            }
            super.lightExport(helper, to, from);
            ((DeWrapper)to).parent = helper.export(from.getDbParent(), false);
            if (((DeWrapper)to).parent == null) {
                ((DeWrapper)to).model.addRoot((DeObject)to);
            }
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeDumbExporter", "exportChildren"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeDumbExporter", "exportChildren"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeDumbExporter", "exportChildren"));
            }
        }
    }

    protected static class DeTableKeyExporter
    extends DeTableChildExporter<DeTableKey, DasTableKey> {
        public DeTableKeyExporter() {
            super(DeTableKey.class, DasTableKey.class, ObjectKind.KEY);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeTableKey to, @NotNull DasTableKey from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableKeyExporter", "lightExport"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableKeyExporter", "lightExport"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableKeyExporter", "lightExport"));
            }
            super.lightExport(helper, to, from);
            if (from.isPrimary()) {
                DeTable table = to.table;
                if (table.keys.getPrimaryKey() != to) {
                    if (table.keys.getPrimaryKey() != null) {
                        this.myLogger.warn("Already have primary key");
                    }
                    table.keys.setPrimaryKey(to);
                }
            }
            to.columns.addAll(DeTableKeyExporter.getColumnsOrStubs(helper, to.table, (MultiRef<? extends DasTypedObject>)from.getColumnsRef()));
        }

        @Override
        @NotNull
        public DeTableKey create(@NotNull SchemaExportHelper helper, @NotNull DasTableKey from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableKeyExporter", "create"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableKeyExporter", "create"));
            }
            DeTableKey deTableKey = new DeTableKey(DeTableKeyExporter.getName(helper, (DasObject)from), DeTable.STUB, helper.getModel());
            if (deTableKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableKeyExporter", "create"));
            }
            return deTableKey;
        }
    }

    protected static class DeForeignKeyExporter
    extends DeTableChildExporter<DeForeignKey, DasForeignKey> {
        public DeForeignKeyExporter() {
            super(DeForeignKey.class, DasForeignKey.class, ObjectKind.FOREIGN_KEY);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeForeignKey to, @NotNull DasForeignKey from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeForeignKeyExporter", "lightExport"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeForeignKeyExporter", "lightExport"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeForeignKeyExporter", "lightExport"));
            }
            super.lightExport(helper, to, from);
            DasTable refTable = from.getRefTable();
            to.target = refTable == null || refTable.getKind() != ObjectKind.TABLE ? null : DeForeignKeyExporter.getTable(helper, refTable, true);
            to.deferrability = (DasForeignKey.Deferrability)ObjectUtils.chooseNotNull((Object)from.getDeferrability(), (Object)DasForeignKey.Deferrability.NOT_DEFERRABLE);
            to.updateRule = (DasForeignKey.RuleAction)ObjectUtils.chooseNotNull((Object)from.getUpdateRule(), (Object)DasForeignKey.RuleAction.NO_ACTION);
            to.deleteRule = (DasForeignKey.RuleAction)ObjectUtils.chooseNotNull((Object)from.getDeleteRule(), (Object)DasForeignKey.RuleAction.NO_ACTION);
            List<DeColumn> refs = DeForeignKeyExporter.getColumnsOrStubs(helper, to.table, (MultiRef<? extends DasTypedObject>)from.getColumnsRef());
            List<DeColumn> targets = DeForeignKeyExporter.getColumnsOrStubs(helper, to.table, (MultiRef<? extends DasTypedObject>)from.getRefColumns());
            int cnt = Math.max(refs.size(), targets.size());
            for (int i2 = 0; i2 < cnt; ++i2) {
                DeColumn ref = i2 < refs.size() ? refs.get(i2) : null;
                DeColumn target = i2 < targets.size() ? targets.get(i2) : null;
                to.refs.add(new DeForeignKey.Ref(ref, target));
            }
        }

        @Override
        @NotNull
        public DeForeignKey create(@NotNull SchemaExportHelper helper, @NotNull DasForeignKey from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeForeignKeyExporter", "create"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeForeignKeyExporter", "create"));
            }
            DeForeignKey deForeignKey = new DeForeignKey(DeForeignKeyExporter.getName(helper, (DasObject)from), DeTable.STUB, helper.getModel());
            if (deForeignKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeForeignKeyExporter", "create"));
            }
            return deForeignKey;
        }
    }

    protected static class DeIndexExporter
    extends DeTableChildExporter<DeIndex, DasIndex> {
        public DeIndexExporter() {
            super(DeIndex.class, DasIndex.class, ObjectKind.INDEX);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeIndex to, @NotNull DasIndex from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeIndexExporter", "lightExport"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeIndexExporter", "lightExport"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeIndexExporter", "lightExport"));
            }
            super.lightExport(helper, to, from);
            for (DeColumn column : DeIndexExporter.getColumnsOrStubs(helper, to.table, (MultiRef<? extends DasTypedObject>)from.getColumnsRef())) {
                DasTypedObject editedColumn = (DasTypedObject)column.editedObject;
                to.items.add(new DeIndex.Item(column, editedColumn == null ? DasIndex.Sorting.NONE : from.getColumnSorting(editedColumn)));
            }
            to.unique = from.isUnique();
        }

        @Override
        @NotNull
        public DeIndex create(@NotNull SchemaExportHelper helper, @NotNull DasIndex from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeIndexExporter", "create"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeIndexExporter", "create"));
            }
            DeIndex deIndex = new DeIndex(DeIndexExporter.getName(helper, (DasObject)from), DeTable.STUB, helper.getModel());
            if (deIndex == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeIndexExporter", "create"));
            }
            return deIndex;
        }
    }

    protected static class DeColumnExporter
    extends DeTableChildExporter<DeColumn, DasColumn> {
        public DeColumnExporter() {
            super(DeColumn.class, DasColumn.class, ObjectKind.COLUMN);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeColumn to, @NotNull DasColumn from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeColumnExporter", "lightExport"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeColumnExporter", "lightExport"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeColumnExporter", "lightExport"));
            }
            super.lightExport(helper, to, from);
            to.dataType = DatabaseDialogsHelper.createDdlBuilder(helper.getContext(), true).type((DasTypedObject)from).getStatement();
            to.defaultValue = from.getDefault();
            Set attrs = from.getTable().getColumnAttrs(from);
            if (attrs.contains(DasColumn.Attribute.AUTO_GENERATED)) {
                to.flags.add(DeColumn.Flag.AUTO_INC);
            }
            if (from.isNotNull()) {
                to.flags.add(DeColumn.Flag.NOT_NULL);
            }
        }

        @Override
        @NotNull
        public DeColumn create(@NotNull SchemaExportHelper helper, @NotNull DasColumn from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeColumnExporter", "create"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeColumnExporter", "create"));
            }
            DeColumn deColumn = new DeColumn(DeColumnExporter.getName(helper, (DasObject)from), DeTable.STUB, helper.getModel());
            if (deColumn == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeColumnExporter", "create"));
            }
            return deColumn;
        }
    }

    protected static abstract class DeTableChildExporter<De extends DeTableChild, Das extends DasTableChild>
    extends DeObjectExporter<De, Das> {
        public DeTableChildExporter(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportedClass", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "<init>"));
            }
            if (exportableClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportableClass", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "<init>"));
            }
            super(exportedClass, exportableClass, kindFilter);
        }

        @NotNull
        public static DeTable getTable(@NotNull SchemaExportHelper helper, @NotNull DasTable table, boolean withChildren) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "getTable"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "getTable"));
            }
            DeTable deTable = (DeTable)helper.export((DasObject)table, withChildren);
            if (deTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "getTable"));
            }
            return deTable;
        }

        @NotNull
        public DeTable getTable(@NotNull SchemaExportHelper helper, @NotNull Das object) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "getTable"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "getTable"));
            }
            DeTable deTable = DeTableChildExporter.getTable(helper, object.getTable(), true);
            if (deTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "getTable"));
            }
            return deTable;
        }

        @NotNull
        public static List<DeColumn> getColumnsOrStubs(@NotNull SchemaExportHelper helper, @NotNull DeTable table, @NotNull MultiRef<? extends DasTypedObject> ref) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "getColumnsOrStubs"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "getColumnsOrStubs"));
            }
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "getColumnsOrStubs"));
            }
            ArrayList res = ContainerUtil.newArrayListWithCapacity((int)ref.size());
            MultiRef.It it = ref.iterate();
            while (it.hasNext()) {
                String name = (String)it.next();
                DeColumn column = (DeColumn)helper.export((DasObject)it.resolve(), true);
                res.add(EditorModelUtil.stubbize(column, name, table, table.model));
            }
            ArrayList arrayList = res;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "getColumnsOrStubs"));
            }
            return arrayList;
        }

        @Override
        public boolean canExport(@NotNull Das object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "canExport"));
            }
            DasObject parent = object.getDbParent();
            return super.canExport(object) && parent != null && parent.getKind() == ObjectKind.TABLE;
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "lightExport"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "lightExport"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter", "lightExport"));
            }
            super.lightExport(helper, to, from);
            ((DeTableChild)to).table = this.getTable(helper, from);
        }
    }

    protected static class DeTableExporter
    extends DeObjectExporter<DeTable, DasTable> {
        public DeTableExporter() {
            super(DeTable.class, DasTable.class, ObjectKind.TABLE);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeTable to, @NotNull DasTable from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "lightExport"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "lightExport"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "lightExport"));
            }
            super.lightExport(helper, to, from);
            to.parent = helper.export(from.getDbParent(), false);
            to.temporary = from.isTemporary();
        }

        @Override
        @NotNull
        public DeTable create(@NotNull SchemaExportHelper helper, @NotNull DasTable from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "create"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "create"));
            }
            DeTable deTable = new DeTable(DeTableExporter.getName(helper, (DasObject)from), null, helper.getModel());
            if (deTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "create"));
            }
            return deTable;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull DeTable to, @NotNull DasTable from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "exportChildren"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "exportChildren"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "exportChildren"));
            }
            for (DasObject child : DasUtil.getDbChildren((DasObject)from, (DasModel)helper.getContext().getModel(), DasObject.class, (ObjectKind)ObjectKind.NONE)) {
                this.processTableChild(helper, to, child);
            }
            if (to.keys.getPrimaryKey() == null) {
                this.processTableInlinePk(helper, to, from);
            }
        }

        protected void processTableChild(@NotNull SchemaExportHelper helper, @NotNull DeTable table, @NotNull DasObject child) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "processTableChild"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "processTableChild"));
            }
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "processTableChild"));
            }
            if (!helper.canExport(child)) {
                return;
            }
            Object exported = helper.export(child, true);
            if (exported instanceof DeColumn) {
                table.columns.add((DeColumn)exported);
            } else if (exported instanceof DeIndex) {
                table.indices.add((DeIndex)exported);
            } else if (exported instanceof DeForeignKey) {
                table.foreignKeys.add((DeForeignKey)exported);
            } else if (exported instanceof DeTableKey) {
                table.keys.add((DeTableKey)exported);
            } else if (exported instanceof DeConstraint) {
                table.constraints.add((DeConstraint)exported);
            }
        }

        protected void processTableInlinePk(@NotNull SchemaExportHelper helper, @NotNull DeTable table, @NotNull DasTable object) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "processTableInlinePk"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "processTableInlinePk"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter", "processTableInlinePk"));
            }
            ArrayList key = ContainerUtil.newArrayList();
            for (DasColumn child : DasUtil.getDbChildren((DasObject)object, (DasModel)helper.getContext().getModel(), DasColumn.class, (ObjectKind)ObjectKind.COLUMN)) {
                if (!object.getColumnAttrs(child).contains(DasColumn.Attribute.PRIMARY_KEY)) continue;
                key.add(child);
            }
            if (!key.isEmpty()) {
                DeTableKey primaryKey = new DeTableKey(table.name + "_autogenerated_pk", table, helper.getModel());
                for (DasColumn column : key) {
                    primaryKey.columns.add(helper.export((DasObject)column, true));
                }
                if (table.keys.getPrimaryKey() != null) {
                    this.myLogger.warn("Already have primary key");
                }
                table.keys.setPrimaryKey(primaryKey);
            }
        }
    }

    protected static class DeObjectCloner
    extends DeObjectExporter<DeObject, DeObject> {
        public DeObjectCloner() {
            super(DeObject.class, DeObject.class, null);
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull DeObject to, @NotNull DeObject from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner", "lightExport"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner", "lightExport"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner", "lightExport"));
            }
            to.copyFrom(from, false, helper.getCopier());
            DeObject parent = to.getParent();
            if (parent != null && parent instanceof DeTable) {
                helper.export(parent.editedObject, true);
            }
            to.editedObject = from;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull DeObject to, @NotNull DeObject from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner", "exportChildren"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner", "exportChildren"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner", "exportChildren"));
            }
            to.copyChildrenFrom(from, helper.getCopier());
        }

        @Override
        @NotNull
        public DeObject create(@NotNull SchemaExportHelper helper, @NotNull DeObject from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner", "create"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner", "create"));
            }
            DeObject object = from.emptyClone(helper.getModel());
            if (from.getParent() == null && Iterables.contains(from.model.getModelRoots(), (Object)from)) {
                object.model.addRoot(object);
            }
            DeObject deObject = object;
            if (deObject == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectCloner", "create"));
            }
            return deObject;
        }
    }

    protected static abstract class DeObjectExporter<De extends DeObject, Das extends DasObject>
    implements SchemaExporters.Exporter<De, Das> {
        protected final Logger myLogger;
        private final Class<De> myExportedClass;
        private final Class<Das> myExportableClass;
        private final ObjectKind myKindFilter;

        public DeObjectExporter(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportedClass", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "<init>"));
            }
            if (exportableClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportableClass", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "<init>"));
            }
            this.myLogger = Logger.getInstance(this.getClass());
            this.myExportedClass = exportedClass;
            this.myExportableClass = exportableClass;
            this.myKindFilter = kindFilter;
        }

        @Override
        @NotNull
        public Class<De> getExportedClass() {
            Class<De> clazz = this.myExportedClass;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "getExportedClass"));
            }
            return clazz;
        }

        @Override
        @NotNull
        public Class<Das> getExportableClass() {
            Class<Das> clazz = this.myExportableClass;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "getExportableClass"));
            }
            return clazz;
        }

        @Override
        public int compareTo(SchemaExporters.Exporter<? extends DeObject, ? extends DasObject> o) {
            return Comparing.compare((int)System.identityHashCode(this), (int)System.identityHashCode(o));
        }

        @Override
        public boolean canExport(@NotNull Das object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "canExport"));
            }
            return this.myKindFilter == null || this.myKindFilter == object.getKind();
        }

        @Override
        public void lightExport(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "lightExport"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "lightExport"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "lightExport"));
            }
            ((DeObject)to).comment = StringUtil.nullize((String)from.getComment());
            ((DeObject)to).editedObject = from;
        }

        @Override
        public void exportChildren(@NotNull SchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "exportChildren"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "exportChildren"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "exportChildren"));
            }
            assert (DasUtil.getDbChildren(from, (DasModel)helper.getContext().getModel(), DasObject.class, (ObjectKind)ObjectKind.NONE).isEmpty());
        }

        @NotNull
        protected static String getName(@NotNull SchemaExportHelper helper, @NotNull DasObject object) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "getName"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "getName"));
            }
            SqlDefinition element = DbRenamePsiElementProcessor.getElementOfType(object, SqlDefinition.class);
            String name = object.getName();
            if (element == null) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "getName"));
                }
                return string;
            }
            SqlNameElement nm = element.getNameElement();
            if (nm == null || !nm.isQuotedIdentifier()) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "getName"));
                }
                return string;
            }
            String string = helper.getContext().getDialect().quoteIdentifier(name, true, false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter", "getName"));
            }
            return string;
        }
    }
}

