/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.fix;

import com.intellij.database.schemaEditor.fix.FixCyclicCreateTableFk;
import com.intellij.database.schemaEditor.fix.FixCyclicRename;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DdlGraphFixing {
    private static final CycleFixer[] CYCLE_FIXERS = new CycleFixer[]{new FixCyclicCreateTableFk(), new FixCyclicRename()};

    public static void fix(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/fix/DdlGraphFixing", "fix"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/fix/DdlGraphFixing", "fix"));
        }
        DdlGraphFixing.fix(generator, builder, CYCLE_FIXERS);
    }

    public static void fix(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull CycleFixer[] cycleFixers) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/fix/DdlGraphFixing", "fix"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/fix/DdlGraphFixing", "fix"));
        }
        if (cycleFixers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycleFixers", "com/intellij/database/schemaEditor/fix/DdlGraphFixing", "fix"));
        }
        int i2 = 0;
        while (DdlGraphFixing.fixGraphs(generator, builder, cycleFixers)) {
            if (i2 > 50) {
                throw new UnsupportedOperationException("Unable to fix graph");
            }
            ++i2;
        }
    }

    private static boolean fixGraphs(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull CycleFixer[] cycleFixers) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/fix/DdlGraphFixing", "fixGraphs"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/fix/DdlGraphFixing", "fixGraphs"));
        }
        if (cycleFixers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycleFixers", "com/intellij/database/schemaEditor/fix/DdlGraphFixing", "fixGraphs"));
        }
        boolean changed = false;
        for (DdlGraph graph : ContainerUtil.newArrayList(builder.buildComponents())) {
            changed |= DdlGraphFixing.fixGraph(generator, builder, graph, cycleFixers);
        }
        return changed;
    }

    private static boolean fixGraph(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull DdlGraph graph, @NotNull CycleFixer[] cycleFixers) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/fix/DdlGraphFixing", "fixGraph"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/fix/DdlGraphFixing", "fixGraph"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/database/schemaEditor/fix/DdlGraphFixing", "fixGraph"));
        }
        if (cycleFixers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cycleFixers", "com/intellij/database/schemaEditor/fix/DdlGraphFixing", "fixGraph"));
        }
        final Stack cycle = ContainerUtil.newStack();
        if (graph.hasCycles() == ThreeState.NO) {
            return false;
        }
        boolean noCycle = DdlGraph.visitDfs(graph, DdlGraph.selectDfsRoot(graph), new DdlGraph.DfsVisitor<DdlOperationKey>(){

            @Override
            public boolean visit(@NotNull DdlOperationKey node, @NotNull DdlGraph.DfsVisitor.Reason reason) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/schemaEditor/fix/DdlGraphFixing$1", "visit"));
                }
                if (reason == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/database/schemaEditor/fix/DdlGraphFixing$1", "visit"));
                }
                if (reason == DdlGraph.DfsVisitor.Reason.CYCLE) {
                    int i2;
                    for (i2 = 0; i2 < cycle.size() && cycle.get(i2) != node; ++i2) {
                    }
                    assert (i2 < cycle.size());
                    cycle.subList(0, i2).clear();
                    return false;
                }
                if (reason == DdlGraph.DfsVisitor.Reason.ENTER) {
                    cycle.push((Object)node);
                } else if (reason == DdlGraph.DfsVisitor.Reason.LEAVE) {
                    cycle.pop();
                }
                return true;
            }
        });
        graph.setHasCycles(ThreeState.fromBoolean((!noCycle ? 1 : 0) != 0));
        if (noCycle) {
            return false;
        }
        for (CycleFixer fixer : cycleFixers) {
            if (!fixer.fixCycle(generator, builder, graph, (List<DdlOperationKey>)cycle)) continue;
            return true;
        }
        return false;
    }

    public static interface CycleFixer {
        public boolean fixCycle(@NotNull DdlGenerator var1, @NotNull DdlGraphBuilder var2, @NotNull DdlGraph var3, @NotNull List<DdlOperationKey> var4);
    }
}

