/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.Casing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntrospectionScopeUpdater {
    private final Set<Pair<ObjectName, ObjectName>> mySchemasToRemove = ContainerUtil.newLinkedHashSet();
    private final Set<Pair<ObjectName, ObjectName>> mySchemasToAdd = ContainerUtil.newLinkedHashSet();

    public IntrospectionScopeUpdater addAll(IntrospectionScopeUpdater other) {
        this.mySchemasToRemove.addAll(other.mySchemasToRemove);
        this.mySchemasToAdd.addAll(other.mySchemasToAdd);
        return this;
    }

    public IntrospectionScopeUpdater toRemove(@Nullable ObjectName db, @Nullable ObjectName sc) {
        if (db != null || sc != null) {
            this.mySchemasToRemove.add((Pair<ObjectName, ObjectName>)Pair.create((Object)db, (Object)sc));
        }
        return this;
    }

    public IntrospectionScopeUpdater toAdd(@Nullable ObjectName db, @Nullable ObjectName sc) {
        if (db != null || sc != null) {
            this.mySchemasToAdd.add((Pair<ObjectName, ObjectName>)Pair.create((Object)db, (Object)sc));
        }
        return this;
    }

    @NotNull
    public IntrospectionScope updateVisibleNamespaces(@NotNull IntrospectionScope introspectionScope, @NotNull DasModel model) {
        if (introspectionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "introspectionScope", "com/intellij/database/util/IntrospectionScopeUpdater", "updateVisibleNamespaces"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/util/IntrospectionScopeUpdater", "updateVisibleNamespaces"));
        }
        if (this.mySchemasToRemove.isEmpty() && this.mySchemasToAdd.isEmpty()) {
            IntrospectionScope introspectionScope2 = introspectionScope;
            if (introspectionScope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/IntrospectionScopeUpdater", "updateVisibleNamespaces"));
            }
            return introspectionScope2;
        }
        HashSet toCheck = ContainerUtil.newHashSet(this.mySchemasToRemove);
        toCheck.addAll(this.mySchemasToAdd);
        HashMap matches = ContainerUtil.newHashMap();
        JBIterable roots = model.getModelRoots().filter(DasNamespace.class);
        DasNamespace first = (DasNamespace)roots.first();
        if (first != null) {
            if (first.getKind() == ObjectKind.SCHEMA) {
                IntrospectionScopeUpdater.processSchemas(model, null, (JBIterable<DasNamespace>)roots, toCheck, matches);
            } else if (first.getKind() == ObjectKind.DATABASE) {
                IntrospectionScopeUpdater.processDatabases(model, (JBIterable<DasNamespace>)roots, toCheck, matches);
            }
        }
        HashSet toAdd = ContainerUtil.newHashSet((Iterable)JBIterable.from(this.mySchemasToAdd).transform(matches::get).filter(Conditions.notNull()));
        LinkedHashSet toRemove = ContainerUtil.newLinkedHashSet(this.mySchemasToRemove);
        toRemove.retainAll(toCheck);
        if (toAdd.isEmpty() && toRemove.isEmpty()) {
            IntrospectionScope introspectionScope3 = introspectionScope;
            if (introspectionScope3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/IntrospectionScopeUpdater", "updateVisibleNamespaces"));
            }
            return introspectionScope3;
        }
        MultiMap<String, String> map = introspectionScope.to((MultiMap<String, String>)MultiMap.createLinked());
        IntrospectionScopeUpdater.processRemove(map, toRemove);
        IntrospectionScopeUpdater.processAdd(map, toAdd);
        IntrospectionScope introspectionScope4 = IntrospectionScopes.collapse(map);
        if (introspectionScope4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/IntrospectionScopeUpdater", "updateVisibleNamespaces"));
        }
        return introspectionScope4;
    }

    public void merge(@NotNull IntrospectionScopeUpdater updater) {
        if (updater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/database/util/IntrospectionScopeUpdater", "merge"));
        }
        this.mySchemasToAdd.addAll(updater.mySchemasToAdd);
        this.mySchemasToRemove.addAll(updater.mySchemasToRemove);
    }

    private static void processAdd(MultiMap<String, String> map, Set<Pair<ObjectName, ObjectName>> toAdd) {
        for (Pair<ObjectName, ObjectName> p : toAdd) {
            Collection all;
            if (p.first != null && ((all = map.get((Object)"*")).contains("*") || p.second != null && all.contains(((ObjectName)p.second).name))) continue;
            Collection schemas = map.getModifiable((Object)(p.first == null ? "*" : ((ObjectName)p.first).name));
            if (p.second == null) continue;
            schemas.add(((ObjectName)p.second).name);
        }
    }

    private static void processRemove(MultiMap<String, String> map, Set<Pair<ObjectName, ObjectName>> toRemove) {
        for (Pair<ObjectName, ObjectName> p : toRemove) {
            if (p.second == null) {
                if (p.first == null) {
                    map.remove((Object)"*");
                    continue;
                }
                map.entrySet().removeIf(e -> ((String)e.getKey()).equalsIgnoreCase(((ObjectName)p.first).name));
                continue;
            }
            if (p.first == null) {
                Collection schs = map.get((Object)"*");
                if (schs.isEmpty()) continue;
                schs.removeIf(s -> s.equalsIgnoreCase(((ObjectName)p.second).name));
                continue;
            }
            for (Map.Entry e2 : map.entrySet()) {
                if (!((String)e2.getKey()).equalsIgnoreCase(((ObjectName)p.first).name)) continue;
                ((Collection)e2.getValue()).removeIf(s -> s.equalsIgnoreCase(((ObjectName)p.second).name));
            }
        }
    }

    private static void processSchemas(@NotNull DasModel model, @Nullable ObjectName db, @NotNull JBIterable<DasNamespace> schemas, @NotNull Set<Pair<ObjectName, ObjectName>> toCheck, @NotNull Map<Pair<ObjectName, ObjectName>, Pair<ObjectName, ObjectName>> matches) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/util/IntrospectionScopeUpdater", "processSchemas"));
        }
        if (schemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/database/util/IntrospectionScopeUpdater", "processSchemas"));
        }
        if (toCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCheck", "com/intellij/database/util/IntrospectionScopeUpdater", "processSchemas"));
        }
        if (matches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matches", "com/intellij/database/util/IntrospectionScopeUpdater", "processSchemas"));
        }
        for (DasNamespace sc : schemas) {
            IntrospectionScopeUpdater.processSchema(db, ObjectName.quoted((String)sc.getName()), toCheck, matches, model.getCasing(ObjectKind.SCHEMA, (DasObject)sc));
        }
    }

    private static void processSchema(@Nullable ObjectName db, @Nullable ObjectName sc, @NotNull Set<Pair<ObjectName, ObjectName>> toCheck, @NotNull Map<Pair<ObjectName, ObjectName>, Pair<ObjectName, ObjectName>> matches, @NotNull Casing casing) {
        if (toCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCheck", "com/intellij/database/util/IntrospectionScopeUpdater", "processSchema"));
        }
        if (matches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matches", "com/intellij/database/util/IntrospectionScopeUpdater", "processSchema"));
        }
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/util/IntrospectionScopeUpdater", "processSchema"));
        }
        toCheck.removeIf(p -> {
            if (casing == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/util/IntrospectionScopeUpdater", "lambda$processSchema$3"));
            }
            if (matches == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matches", "com/intellij/database/util/IntrospectionScopeUpdater", "lambda$processSchema$3"));
            }
            boolean res = IntrospectionScopeUpdater.matches(db, sc, (Pair<ObjectName, ObjectName>)p, casing);
            if (res) {
                matches.put((Pair<ObjectName, ObjectName>)p, (Pair<ObjectName, ObjectName>)Pair.create((Object)db, (Object)sc));
            }
            return res;
        });
    }

    private static boolean matches(@Nullable ObjectName db, @Nullable ObjectName sc, @NotNull Pair<ObjectName, ObjectName> p, @NotNull Casing casing) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/database/util/IntrospectionScopeUpdater", "matches"));
        }
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/util/IntrospectionScopeUpdater", "matches"));
        }
        boolean dbEq = db == null || ObjectName.equals((ObjectName)((ObjectName)p.first), (ObjectName)db, (Casing)casing);
        return dbEq && ObjectName.equals((ObjectName)((ObjectName)p.second), (ObjectName)sc, (Casing)casing);
    }

    private static void processDatabases(@NotNull DasModel model, @NotNull JBIterable<DasNamespace> databases, @NotNull Set<Pair<ObjectName, ObjectName>> toCheck, @NotNull Map<Pair<ObjectName, ObjectName>, Pair<ObjectName, ObjectName>> matches) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/util/IntrospectionScopeUpdater", "processDatabases"));
        }
        if (databases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databases", "com/intellij/database/util/IntrospectionScopeUpdater", "processDatabases"));
        }
        if (toCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCheck", "com/intellij/database/util/IntrospectionScopeUpdater", "processDatabases"));
        }
        if (matches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matches", "com/intellij/database/util/IntrospectionScopeUpdater", "processDatabases"));
        }
        for (DasNamespace db : databases) {
            ObjectName dbName = ObjectName.quoted((String)db.getName());
            IntrospectionScopeUpdater.processSchema(dbName, null, toCheck, matches, model.getCasing(ObjectKind.DATABASE, (DasObject)db));
            IntrospectionScopeUpdater.processSchemas(model, dbName, (JBIterable<DasNamespace>)db.getDbChildren(DasNamespace.class, ObjectKind.SCHEMA), toCheck, matches);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntrospectionScopeUpdater updater = (IntrospectionScopeUpdater)o;
        if (!this.mySchemasToRemove.equals(updater.mySchemasToRemove)) {
            return false;
        }
        return this.mySchemasToAdd.equals(updater.mySchemasToAdd);
    }

    public int hashCode() {
        int result2 = this.mySchemasToRemove.hashCode();
        result2 = 31 * result2 + this.mySchemasToAdd.hashCode();
        return result2;
    }
}

