/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import dk.brics.automaton.RunAutomaton;
import java.util.regex.MatchResult;

public class TokenPatternMatcher
implements MatchResult {
    private final RunAutomaton automaton;
    private final CharSequence chars;
    private int startFrom = 0;
    private int startTo = 0;
    private int matchStart = -1;
    private int matchEnd = -1;

    TokenPatternMatcher(CharSequence chars, RunAutomaton automaton) {
        this.chars = chars;
        this.automaton = automaton;
    }

    public void reset(int startFrom, int startTo) {
        assert (startTo <= this.chars.length());
        this.startFrom = startFrom;
        this.startTo = startTo;
        this.matchStart = -1;
        this.matchEnd = -1;
    }

    public boolean find() {
        int match_end;
        int match_start;
        if (this.getMatchStart() == -2) {
            return false;
        }
        int begin = this.getMatchStart() == -1 ? this.startFrom : this.getMatchEnd();
        if (this.automaton.isAccept(this.automaton.getInitialState())) {
            match_start = begin;
            match_end = begin;
        } else {
            match_start = -1;
            match_end = -1;
        }
        int l = this.getChars().length();
        while (begin < this.startTo) {
            int new_state;
            int p = this.automaton.getInitialState();
            for (int i2 = begin; i2 < l && (new_state = this.automaton.step(p, this.getChars().charAt(i2))) != -1; ++i2) {
                if (this.automaton.isAccept(new_state)) {
                    if (match_start == -1) {
                        match_start = begin;
                    }
                    match_end = i2;
                }
                p = new_state;
            }
            if (match_start != -1) {
                this.setMatch(match_start, match_end + 1);
                return true;
            }
            ++begin;
        }
        if (match_start != -1) {
            this.setMatch(match_start, match_end + 1);
            return true;
        }
        this.setMatch(-2, -2);
        return false;
    }

    private void setMatch(int matchStart, int matchEnd) throws IllegalArgumentException {
        if (matchStart > matchEnd) {
            throw new IllegalArgumentException("Start must be less than or equal to end: " + matchStart + ", " + matchEnd);
        }
        this.matchStart = matchStart;
        this.matchEnd = matchEnd;
    }

    private int getMatchStart() {
        return this.matchStart;
    }

    private int getMatchEnd() {
        return this.matchEnd;
    }

    private CharSequence getChars() {
        return this.chars;
    }

    @Override
    public int end() throws IllegalStateException {
        this.matchGood();
        return this.matchEnd;
    }

    @Override
    public int end(int group2) throws IndexOutOfBoundsException, IllegalStateException {
        TokenPatternMatcher.onlyZero(group2);
        return this.end();
    }

    @Override
    public String group() throws IllegalStateException {
        this.matchGood();
        return this.chars.subSequence(this.matchStart, this.matchEnd).toString();
    }

    @Override
    public String group(int group2) throws IndexOutOfBoundsException, IllegalStateException {
        TokenPatternMatcher.onlyZero(group2);
        return this.group();
    }

    @Override
    public int groupCount() {
        return 0;
    }

    @Override
    public int start() throws IllegalStateException {
        this.matchGood();
        return this.matchStart;
    }

    @Override
    public int start(int group2) throws IndexOutOfBoundsException, IllegalStateException {
        TokenPatternMatcher.onlyZero(group2);
        return this.start();
    }

    private static void onlyZero(int group2) throws IndexOutOfBoundsException {
        if (group2 != 0) {
            throw new IndexOutOfBoundsException("The only group supported is 0.");
        }
    }

    private void matchGood() throws IllegalStateException {
        if (this.matchStart < 0 || this.matchEnd < 0) {
            throw new IllegalStateException("There was no available match.");
        }
    }
}

