/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.derby.dataSource.inspections;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.UrlEditorInspector;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class DerbyEmptyDatabaseInspector
extends UrlEditorInspector {
    @Override
    protected boolean canInspectInstanceOf(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/vendors/derby/dataSource/inspections/DerbyEmptyDatabaseInspector", "canInspectInstanceOf"));
        }
        return "Derby".equals(driver.getSqlDialect());
    }

    @Override
    protected void runInspection(@NotNull DatabaseDriver driver, @NotNull UrlEditorModel model, @NotNull UrlEditorInspector.InspectionConsumer consumer) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/vendors/derby/dataSource/inspections/DerbyEmptyDatabaseInspector", "runInspection"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/vendors/derby/dataSource/inspections/DerbyEmptyDatabaseInspector", "runInspection"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/vendors/derby/dataSource/inspections/DerbyEmptyDatabaseInspector", "runInspection"));
        }
        String database = model.getParameter("database");
        String host = model.getParameter("host");
        if (StringUtil.isNotEmpty((String)host) && database != null && database.isEmpty()) {
            consumer.warning("Database can't be empty", null, new Pair[0]);
        }
    }
}

