/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDialogsHelper {
    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull Project project, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @NotNull String query) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseDialogsHelper", "createLanguageEditorArea"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/view/DatabaseDialogsHelper", "createLanguageEditorArea"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/view/DatabaseDialogsHelper", "createLanguageEditorArea"));
        }
        EditorTextField editorTextField = DatabaseDialogsHelper.createLanguageEditorArea(project, DbImplUtil.getDatabaseDialect((DbElement)dataSource), dataSource, searchPath, query);
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseDialogsHelper", "createLanguageEditorArea"));
        }
        return editorTextField;
    }

    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull DatabaseEditorContext context, @Nullable List<DasNamespace> searchPath, @NotNull String query) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/DatabaseDialogsHelper", "createLanguageEditorArea"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/view/DatabaseDialogsHelper", "createLanguageEditorArea"));
        }
        EditorTextField editorTextField = DatabaseDialogsHelper.createLanguageEditorArea((Project)ObjectUtils.assertNotNull((Object)context.getProject()), context.getDialect(), context.getDataSource(), searchPath, query);
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseDialogsHelper", "createLanguageEditorArea"));
        }
        return editorTextField;
    }

    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @Nullable DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @NotNull String query) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseDialogsHelper", "createLanguageEditorArea"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/view/DatabaseDialogsHelper", "createLanguageEditorArea"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/view/DatabaseDialogsHelper", "createLanguageEditorArea"));
        }
        SqlLanguageDialect language = dataSource != null ? DbSqlUtil.getSqlDialect((DbElement)dataSource) : DbSqlUtil.getSqlDialect(dialect);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)language, (CharSequence)query);
        psiFile.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, (Object)dataSource);
        psiFile.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, searchPath);
        EditorTextField area = DatabaseDialogsHelper.createEditorTextField(psiFile, false);
        area.setFontInheritedFromLAF(false);
        area.addSettingsProvider(editor -> {
            editor.getSettings().setWheelFontChangeEnabled(true);
            editor.getSettings().setFoldingOutlineShown(true);
            editor.setHorizontalScrollbarVisible(true);
            editor.setVerticalScrollbarVisible(true);
            editor.getSettings().setAdditionalLinesCount(2);
            editor.getSettings().setUseSoftWraps(true);
        });
        EditorTextField editorTextField = area;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseDialogsHelper", "createLanguageEditorArea"));
        }
        return editorTextField;
    }

    @NotNull
    public static EditorTextField createLanguageEditorField(PsiFile psiFile) {
        EditorTextField editorTextField = DatabaseDialogsHelper.createEditorTextField(psiFile, true);
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseDialogsHelper", "createLanguageEditorField"));
        }
        return editorTextField;
    }

    @NotNull
    public static EditorTextField createEditorTextField(PsiFile psiFile, boolean oneLine) {
        Project project = psiFile.getProject();
        Language dialect = psiFile.getLanguage();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        EditorTextField textField = new EditorTextField(document, project, psiFile.getFileType(), false, oneLine);
        textField.addSettingsProvider(editor -> {
            SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, (Project)project, (VirtualFile)psiFile.getVirtualFile());
            editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
            editor.setEmbeddedIntoDialogWrapper(true);
            editor.getSettings().setLineNumbersShown(false);
        });
        EditorTextField editorTextField = textField;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseDialogsHelper", "createEditorTextField"));
        }
        return editorTextField;
    }

    public static String concatQueries(DdlBuilder builder) {
        List<String> statements2 = builder.getStatements();
        DatabaseDialectEx dialect = builder.getDialect();
        if (statements2.isEmpty()) {
            return "";
        }
        boolean noSemi = dialect.getFamilyId().isTransactSql();
        String join = StringUtil.join(statements2, (String)(noSemi ? "\n" : ";\n"));
        return noSemi || StringUtil.endsWith((CharSequence)join, (CharSequence)";") ? join : join + ";";
    }

    public static DdlBuilder createDdlBuilder(@NotNull DatabaseEditorContext context, boolean forCreate) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/DatabaseDialogsHelper", "createDdlBuilder"));
        }
        return DatabaseDialogsHelper.createDdlBuilder(context.getProject(), context.getDialect(), (CasingProvider)context.getModel(), forCreate).pushDefaultSchema(context.getCurrentNamespace());
    }

    public static DdlBuilder createDdlBuilder(@NotNull DbElement source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/view/DatabaseDialogsHelper", "createDdlBuilder"));
        }
        return DatabaseDialogsHelper.createDdlBuilder(source, true).pushDefaultSchema(DbImplUtil.getSearchPathObject(source));
    }

    public static DdlBuilder createDdlBuilder(@Nullable Project project, @NotNull DatabaseDialectEx dialect, @NotNull CasingProvider provider, boolean forCreate) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/view/DatabaseDialogsHelper", "createDdlBuilder"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/view/DatabaseDialogsHelper", "createDdlBuilder"));
        }
        return DatabaseDialogsHelper.createDdlBuilder(forCreate).withDialect(dialect).applyCodeStyle(project).withCasing(provider);
    }

    public static DdlBuilder createDdlBuilder(@NotNull DbElement source, boolean forCreate) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/view/DatabaseDialogsHelper", "createDdlBuilder"));
        }
        return DatabaseDialogsHelper.createDdlBuilder(forCreate).configureFor(source).pushDefaultSchema(DbImplUtil.getSearchPathObject(source));
    }

    public static DdlBuilder createDdlBuilder(final boolean forCreate) {
        return new DdlBuilder(){

            @Override
            @NotNull
            public DdlBuilder newName(@NotNull String newName) {
                if (newName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/view/DatabaseDialogsHelper$1", "newName"));
                }
                if (!forCreate) {
                    this.suppressQuoteIdentifiers(true);
                }
                super.newName(newName);
                if (!forCreate) {
                    this.suppressQuoteIdentifiers(false);
                }
                1 v0 = this;
                if (v0 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseDialogsHelper$1", "newName"));
                }
                return v0;
            }

            @Override
            @NotNull
            public DdlBuilder identifier(@Nullable DasObject object, @NotNull String name) {
                boolean suppress;
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/DatabaseDialogsHelper$1", "identifier"));
                }
                boolean bl = suppress = object != null && this.isNameModifiedOrNew(object, name);
                if (suppress) {
                    this.suppressQuoteIdentifiers(true);
                }
                super.identifier(object, name);
                if (suppress) {
                    this.suppressQuoteIdentifiers(false);
                }
                1 v1 = this;
                if (v1 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseDialogsHelper$1", "identifier"));
                }
                return v1;
            }

            @Override
            @NotNull
            public DdlBuilder constraintRef(@NotNull DasObject object) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/DatabaseDialogsHelper$1", "constraintRef"));
                }
                boolean suppress = this.isNameModifiedOrNew(object, object.getName());
                if (suppress) {
                    this.suppressQuoteIdentifiers(true);
                }
                super.constraintRef(object);
                if (suppress) {
                    this.suppressQuoteIdentifiers(false);
                }
                1 v0 = this;
                if (v0 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseDialogsHelper$1", "constraintRef"));
                }
                return v0;
            }

            private boolean isNameModifiedOrNew(@Nullable DasObject obj, @NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/DatabaseDialogsHelper$1", "isNameModifiedOrNew"));
                }
                if (obj != null && !name.equals(obj.getName())) {
                    return true;
                }
                DeObject object = (DeObject)ObjectUtils.tryCast((Object)obj, DeObject.class);
                if (object == null) {
                    return false;
                }
                return object.editedObject == null || !object.name.equals(object.editedObject.getName());
            }
        }.qualifyReferences(true).splitStatements(true).suppressQuoteIdentifiers(forCreate);
    }

    @NotNull
    public static Function<Runnable, ActionCallback> createAsyncProcessor(@NotNull Project project, @NotNull String text, @NotNull Runnable onOk) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseDialogsHelper", "createAsyncProcessor"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/view/DatabaseDialogsHelper", "createAsyncProcessor"));
        }
        if (onOk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onOk", "com/intellij/database/view/DatabaseDialogsHelper", "createAsyncProcessor"));
        }
        Function function = runnable -> {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/view/DatabaseDialogsHelper", "lambda$createAsyncProcessor$2"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseDialogsHelper", "lambda$createAsyncProcessor$2"));
            }
            if (onOk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onOk", "com/intellij/database/view/DatabaseDialogsHelper", "lambda$createAsyncProcessor$2"));
            }
            ActionCallback res = new ActionCallback(text);
            DataSourceUiUtil.runAsyncWithCorrectModality(new Task.Backgroundable(project, text, true, (Runnable)runnable, res, onOk){
                final /* synthetic */ Runnable val$runnable;
                final /* synthetic */ ActionCallback val$res;
                final /* synthetic */ Runnable val$onOk;
                {
                    this.val$runnable = runnable;
                    this.val$res = actionCallback;
                    this.val$onOk = runnable2;
                    super(arg0, arg1, arg2);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/DatabaseDialogsHelper$2", "run"));
                    }
                    this.val$runnable.run();
                }

                public void onCancel() {
                    this.val$res.setRejected();
                }

                public void onSuccess() {
                    this.val$res.setDone();
                    DbUIUtil.invokeLaterIfNeeded(this.val$onOk);
                }
            });
            return res;
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseDialogsHelper", "createAsyncProcessor"));
        }
        return function;
    }

    public static abstract class DocAdapter
    implements javax.swing.event.DocumentListener,
    ItemListener,
    DocumentListener {
        public abstract void processChangeImpl();

        private void processChange() {
            ApplicationManager.getApplication().invokeLater(() -> this.processChangeImpl());
        }

        public void documentChanged(DocumentEvent event) {
            this.processChange();
        }

        @Override
        public void insertUpdate(@NotNull javax.swing.event.DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/DatabaseDialogsHelper$DocAdapter", "insertUpdate"));
            }
            this.processChange();
        }

        @Override
        public void removeUpdate(@NotNull javax.swing.event.DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/DatabaseDialogsHelper$DocAdapter", "removeUpdate"));
            }
            this.processChange();
        }

        @Override
        public void changedUpdate(@NotNull javax.swing.event.DocumentEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/DatabaseDialogsHelper$DocAdapter", "changedUpdate"));
            }
            this.processChange();
        }

        @Override
        public void itemStateChanged(@NotNull ItemEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/DatabaseDialogsHelper$DocAdapter", "itemStateChanged"));
            }
            this.processChange();
        }
    }
}

