/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseToolWindowFactory;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.SelectInDatabaseView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.FileEditorSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.TextCopyProvider;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializer;
import icons.DatabaseIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@State(name="DatabaseView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DatabaseView
extends SimpleToolWindowPanel
implements PersistentStateComponent<Element>,
Disposable {
    public static final DataKey<DatabaseView> DATABASE_VIEW_KEY = DataKey.create((String)"DATABASE_VIEW_KEY");
    private final Project myProject;
    private final DbPsiFacade myDbFacade;
    private final Tree myTree;
    private final AbstractTreeBuilder myBuilder;
    private final CopyProvider myCopyProvider;
    private final DatabaseViewOptions myViewOptions = new DatabaseViewOptions();
    private final MyAutoScrollFromSourceHandler myAutoScrollHandler;

    public static DatabaseView getDatabaseView(Project project) {
        return (DatabaseView)((Object)ServiceManager.getService((Project)project, DatabaseView.class));
    }

    public DatabaseView(DbPsiFacade dbFacade, JdbcDriverManager jdbcManager) {
        super(true, true);
        this.myProject = dbFacade.getProject();
        this.myDbFacade = dbFacade;
        this.myAutoScrollHandler = new MyAutoScrollFromSourceHandler(this.myProject, this);
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new ProjectViewTree(this.myProject, model){

            @Nullable
            public Color getFileColorFor(Object object) {
                DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(this.getProject()).getState();
                if (!state.useColors || !state.inDatabaseView) {
                    return null;
                }
                Object o = object instanceof NodeDescriptor ? ((NodeDescriptor)object).getElement() : object;
                DbElement e = o instanceof PsiElement ? (DbElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), DbElement.class, (boolean)false) : null;
                return DatabaseColorManager.getColor(e);
            }

            public DefaultMutableTreeNode getSelectedNode() {
                TreePath path = this.getSelectionPath();
                return path == null ? null : (DefaultMutableTreeNode)path.getLastPathComponent();
            }

            public boolean isFileColorsEnabled() {
                return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
            }
        };
        this.myBuilder = new AbstractTreeBuilder((JTree)this.myTree, model, (AbstractTreeStructure)new DatabaseStructure(this.myDbFacade, this.myViewOptions), (Comparator)new WeightBasedComparator(true){

            protected int getWeight(NodeDescriptor node) {
                Object element = node.getElement();
                Object delegate = element instanceof DbElement ? ((DbElement)element).getDelegate() : null;
                Object o = ObjectUtils.chooseNotNull((Object)delegate, (Object)element);
                return o == null ? super.getWeight(node) : DbPresentation.getWeight(o, ((DatabaseView)DatabaseView.this).myViewOptions.SORT_POSITIONED);
            }

            protected int compareWeights(int w1, int w2) {
                return w1 - w2;
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myBuilder.setCanYieldUpdate(true);
        this.initComponents();
        TreeUtil.collapseAll((JTree)this.myTree, (int)1);
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myDbFacade.addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

            public void modificationCountChanged(DbPsiFacade modificationTracker) {
                DatabaseView.this.refreshView();
            }
        }, (Disposable)this);
        jdbcManager.addModificationTrackerListener(new ModificationTrackerListener<JdbcDriverManager>(){

            public void modificationCountChanged(JdbcDriverManager source) {
                DatabaseView.this.getTreeBuilder().queueUpdate(false);
            }
        }, this);
        this.enableDnD();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DatabaseSettings.TOPIC, (Object)new DatabaseSettings.Listener(){

            @Override
            public void settingsChanged() {
                DatabaseView.this.refreshView();
            }
        });
        this.myCopyProvider = new TextCopyProvider(){

            @Nullable
            public Collection<String> getTextLinesToCopy() {
                Set selectedElements = DatabaseView.this.getTreeBuilder().getSelectedElements(DbElement.class);
                if (selectedElements.isEmpty()) {
                    return null;
                }
                ArrayList lines = ContainerUtil.newArrayList();
                for (DbElement selectedElement : selectedElements) {
                    String name = selectedElement.getName();
                    if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                    lines.add(name);
                }
                return lines;
            }
        };
    }

    @NotNull
    public DatabaseViewOptions getViewOptions() {
        DatabaseViewOptions databaseViewOptions = this.myViewOptions;
        if (databaseViewOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getViewOptions"));
        }
        return databaseViewOptions;
    }

    @NotNull
    public static <T extends DbElement> Set<T> getSelectedElements(@NotNull DataContext dataContext, Class<T> aClass) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/view/DatabaseView", "getSelectedElements"));
        }
        Set set = (Set)JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext))).filter(aClass).addAllTo((Collection)ContainerUtil.newLinkedHashSet());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getSelectedElements"));
        }
        return set;
    }

    @NotNull
    public static Set<DbElement> getSelectedElements(@NotNull DataContext dataContext, @NotNull Condition<DbElement> condition) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/view/DatabaseView", "getSelectedElements"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/view/DatabaseView", "getSelectedElements"));
        }
        Set set = (Set)JBIterable.of((Object[])((Object[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext))).filter(DbElement.class).filter(condition).addAllTo((Collection)ContainerUtil.newLinkedHashSet());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getSelectedElements"));
        }
        return set;
    }

    @Nullable
    public static DbNamespaceImpl getLowestSchema(@Nullable DbElement element) {
        if (element instanceof DbDataSource && (element = DatabaseView.getOneSchemaChild(element)) == null) {
            return null;
        }
        if (element instanceof DbNamespaceImpl) {
            while (true) {
                DbNamespaceImpl child;
                if ((child = DatabaseView.getOneSchemaChild(element)) == null) {
                    return (DbNamespaceImpl)element;
                }
                element = child;
            }
        }
        while (element != null && !(element instanceof DbNamespaceImpl)) {
            element = element.getDbParent();
        }
        return (DbNamespaceImpl)((Object)ObjectUtils.tryCast((Object)element, DbNamespaceImpl.class));
    }

    @Nullable
    private static DbNamespaceImpl getOneSchemaChild(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DatabaseView", "getOneSchemaChild"));
        }
        JBIterable children = element.getDbChildren(DbNamespaceImpl.class, ObjectKind.NONE);
        return children.skip(1).isEmpty() ? (DbNamespaceImpl)((Object)children.first()) : null;
    }

    private void initComponents() {
        this.myBuilder.initRootNode();
        this.myTree.setDragEnabled(false);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.updateEmptyText();
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch(this.myTree, o -> {
            DatabaseDriver driver;
            Object delegate;
            DbElement element;
            Object node = o.getLastPathComponent();
            Object object = TreeUtil.getUserObject((Object)node);
            if (object instanceof DbNodeDescriptor && (element = ((DbNodeDescriptor)((Object)((Object)object))).getElement()) instanceof DbDataSource && (delegate = element.getDelegate()) instanceof LocalDataSource && (driver = ((LocalDataSource)delegate).getDatabaseDriver()) != null && driver.isPredefined()) {
                return driver.getName() + " " + node;
            }
            return String.valueOf(node);
        });
        this.myTree.setRootVisible(false);
        PopupHandler.installPopupHandler((JComponent)this.myTree, (String)"DatabaseViewPopupMenu", (String)"J2EEAttributesViewPopup");
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        this.setToolbar(this.createToolbar().getComponent());
        this.myAutoScrollHandler.install();
        this.installMoreNodeListeners();
    }

    private void installMoreNodeListeners() {
        final Processor manageSchemas = node -> {
            Object o = TreeUtil.getUserObject((Object)node);
            if (o instanceof DatabaseStructure.MoreObjectNode) {
                ((DatabaseStructure.MoreObjectNode)((Object)((Object)o))).getNavigatable().navigate(false);
                return true;
            }
            return false;
        };
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                TreePath location = DatabaseView.this.myTree.getClosestPathForLocation(e.getX(), e.getY());
                Rectangle bounds = DatabaseView.this.myTree.getPathBounds(location);
                if (bounds != null && bounds.y + bounds.height < e.getY()) {
                    return false;
                }
                return manageSchemas.process(location == null ? null : location.getLastPathComponent());
            }
        }.installOn((Component)this.myTree);
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Component c = e.getComponent();
                if (e.getKeyCode() == 10 && c instanceof JTree && manageSchemas.process(((JTree)c).getLastSelectedPathComponent())) {
                    e.consume();
                }
            }
        });
    }

    private void updateEmptyText() {
        String shortcut;
        String emptyText = this.myDbFacade.getDataSources().isEmpty() ? (StringUtil.isNotEmpty((String)(shortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("NewElement")))) ? "Create a data source with " + shortcut : "Create a data source with context menu") : "Loading...";
        this.myTree.getEmptyText().setText(emptyText);
    }

    @NotNull
    public AbstractTreeBuilder getTreeBuilder() {
        AbstractTreeBuilder abstractTreeBuilder = this.myBuilder;
        if (abstractTreeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getTreeBuilder"));
        }
        return abstractTreeBuilder;
    }

    public Project getProject() {
        return this.myProject;
    }

    private ActionCallback refreshView() {
        this.updateEmptyText();
        return this.myBuilder.queueUpdate();
    }

    @NotNull
    public JBIterable<Object> getSelectedElements() {
        JBIterable jBIterable = JBIterable.of((Object[])this.myTree.getSelectionPaths()).map(p -> {
            Object o = TreeUtil.getUserObject((Object)p.getLastPathComponent());
            return o instanceof NodeDescriptor ? ((NodeDescriptor)o).getElement() : o;
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getSelectedElements"));
        }
        return jBIterable;
    }

    @NotNull
    public final Promise<Void> selectElements(DbElement ... elements) {
        if (this.myBuilder.isDisposed()) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "selectElements"));
            }
            return promise;
        }
        AsyncPromise callback = new AsyncPromise();
        this.getTreeBuilder().select((Object[])elements, () -> callback.setResult(null));
        AsyncPromise asyncPromise = callback;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "selectElements"));
        }
        return asyncPromise;
    }

    @Nullable
    private static <T> T getSelectedElementOfType(@NotNull Class<T> elementClass, boolean strict, @NotNull JTree tree) {
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/database/view/DatabaseView", "getSelectedElementOfType"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/database/view/DatabaseView", "getSelectedElementOfType"));
        }
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        if (strict && paths.length != 1) {
            return null;
        }
        T result2 = null;
        block0: for (TreePath path : paths) {
            for (int i2 = path.getPathCount() - 1; i2 >= 0; --i2) {
                Object cur;
                Object userObject = TreeUtil.getUserObject((Object)path.getPathComponent(i2));
                Object object = cur = userObject instanceof NodeDescriptor ? ((NodeDescriptor)userObject).getElement() : userObject;
                if (elementClass.isInstance(cur)) {
                    if (result2 == null) {
                        result2 = elementClass.cast(cur);
                    } else if (result2 != cur) {
                        return null;
                    }
                }
                if (strict) continue block0;
            }
        }
        return result2;
    }

    protected void enableDnD() {
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            DnDManager.getInstance().registerTarget((DnDTarget)new MyDnDTarget(), (JComponent)this.myTree);
            DnDManager.getInstance().registerSource((DnDSource)new MyDnDSource(), (JComponent)this.myTree);
        }
    }

    @NotNull
    private ActionToolbar createToolbar() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        AnAction group2 = ActionManager.getInstance().getAction("DatabaseViewToolbar");
        actionGroup.addAll(((DefaultActionGroup)group2).getChildActionsOrStubs());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", (ActionGroup)actionGroup, true);
        toolbar.setTargetComponent((JComponent)this.myTree);
        ActionToolbar actionToolbar = toolbar;
        if (actionToolbar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "createToolbar"));
        }
        return actionToolbar;
    }

    public void dispose() {
    }

    public void setupToolWindow(ToolWindowEx toolWindow) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        DatabaseViewOptions opts = this.myViewOptions;
        group2.addAction((AnAction)DatabaseViewActions.toggle("Group Schema", (Getter<Boolean>)((Getter)() -> opts.GROUP_SCHEMA), (Setter<Boolean>)((Setter)b -> {
            opts.GROUP_SCHEMA = b;
        }), this::refreshView));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Group Contents", (Getter<Boolean>)((Getter)() -> opts.GROUP_CONTENTS), (Setter<Boolean>)((Setter)b -> {
            opts.GROUP_CONTENTS = b;
        }), this::refreshView));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Show Keys && etc.", (Getter<Boolean>)((Getter)() -> opts.SHOW_TABLE_DETAILS), (Setter<Boolean>)((Setter)b -> {
            opts.SHOW_TABLE_DETAILS = b;
        }), this::refreshView, (Consumer<Presentation>)((Consumer)p -> p.setVisible(!opts.GROUP_CONTENTS))));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Show Empty Groups", (Getter<Boolean>)((Getter)() -> opts.SHOW_EMPTY_GROUPS), (Setter<Boolean>)((Setter)b -> {
            opts.SHOW_EMPTY_GROUPS = b;
        }), this::refreshView, (Consumer<Presentation>)((Consumer)p -> p.setVisible(opts.GROUP_CONTENTS || opts.GROUP_SCHEMA))));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Show Intermediate Nodes", (Getter<Boolean>)((Getter)() -> opts.SHOW_INTERMEDIATE), (Setter<Boolean>)((Setter)b -> {
            opts.SHOW_INTERMEDIATE = b;
        }), this::refreshView));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Sort Alphabetically", (Getter<Boolean>)((Getter)() -> opts.SORT_POSITIONED), (Setter<Boolean>)((Setter)b -> {
            opts.SORT_POSITIONED = b;
        }), this::refreshView));
        group2.addAction((AnAction)DatabaseViewActions.toggle("Autoscroll from Editor", (Getter<Boolean>)((Getter)this.myAutoScrollHandler::isAutoScrollEnabled), (Setter<Boolean>)((Setter)this.myAutoScrollHandler::setAutoScrollEnabled)));
        group2.addAction((AnAction)JdbcConsole.createToggleConsoleToolbarAction(this.myProject)).setAsSecondary(true);
        toolWindow.setAdditionalGearActions((ActionGroup)group2);
        DumbAwareAction consoleTitleAction = new DumbAwareAction(){

            public void update(AnActionEvent e) {
                e.getPresentation().setVisible(!DatabaseView.this.isToolbarVisible());
            }

            public void actionPerformed(AnActionEvent e) {
                DbDataSource dataSource = (DbDataSource)DatabaseView.getSelectedElementOfType(DbDataSource.class, false, (JTree)DatabaseView.this.myTree);
                DatabaseEditorHelper.openConsoleFile((DbElement)dataSource);
            }
        };
        consoleTitleAction.copyFrom(ActionManager.getInstance().getAction("Jdbc.OpenConsole"));
        consoleTitleAction.getTemplatePresentation().setIcon(DatabaseIcons.ConsoleRun);
        consoleTitleAction.getTemplatePresentation().setHoveredIcon(DatabaseIcons.ConsoleRunHover);
        DumbAwareAction refreshTitleAction = new DumbAwareAction(){
            final AnAction baseAction = ActionManager.getInstance().getAction("DatabaseView.SynchronizeAction");
            {
                this.copyFrom(this.baseAction);
                this.getTemplatePresentation().setIcon(DatabaseIcons.SchemaRefresh);
                this.getTemplatePresentation().setHoveredIcon(DatabaseIcons.SchemaRefreshHover);
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(!DatabaseView.this.isToolbarVisible());
            }

            public void actionPerformed(AnActionEvent e) {
                this.baseAction.actionPerformed(new AnActionEvent(e.getInputEvent(), SimpleDataContext.getSimpleContext((String)DATABASE_VIEW_KEY.getName(), (Object)((Object)DatabaseView.this), (DataContext)e.getDataContext()), e.getPlace(), e.getPresentation(), e.getActionManager(), e.getModifiers()));
            }
        };
        DumbAwareAction scrollFromEditorAction = new DumbAwareAction("Scroll from Editor", "Select database element open in the active editor", AllIcons.General.Locate){

            public void actionPerformed(AnActionEvent e) {
                FileEditor fileEditor;
                EditorWindow window = FileEditorManagerEx.getInstanceEx((Project)DatabaseView.this.myProject).getCurrentWindow();
                EditorWithProviderComposite editorComposite = window == null ? null : window.getSelectedEditor();
                FileEditor fileEditor2 = fileEditor = editorComposite == null ? null : (FileEditor)editorComposite.getSelectedEditorWithProvider().first;
                if (fileEditor == null) {
                    return;
                }
                DatabaseView.this.myAutoScrollHandler.selectElementFromEditorInner(fileEditor, true);
            }
        };
        scrollFromEditorAction.getTemplatePresentation().setHoveredIcon(AllIcons.General.LocateHover);
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        toolWindow.setTitleActions(new AnAction[]{refreshTitleAction, consoleTitleAction, scrollFromEditorAction, actionsManager.createCollapseAllHeaderAction((JTree)this.myTree)});
    }

    public Object getData(String dataId) {
        Object data = super.getData(dataId);
        if (data != null) {
            return data;
        }
        AbstractTreeBuilder builder = this.getTreeBuilder();
        if (builder.isDisposed()) {
            return null;
        }
        if (DATABASE_VIEW_KEY.is(dataId)) {
            return this;
        }
        if (DatabaseDataKeys.DB_PSI_FACADE.is(dataId)) {
            return this.myDbFacade;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.tools.datasource";
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            Collection c = DatabaseView.getDataFromSelectedPaths(CommonDataKeys.PSI_ELEMENT, (JTree)this.myTree);
            if (c.isEmpty()) {
                return null;
            }
            if (JBIterable.from(c).filter(DbDataSource.class).size() == c.size()) {
                return new DdlActions.DeleteProvider1();
            }
            return new DdlActions.DeleteProvider2();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyProvider;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            Collection<PsiElement> c = DatabaseView.getDataFromSelectedPaths(CommonDataKeys.PSI_ELEMENT, (JTree)this.myTree);
            return c.isEmpty() ? null : c.toArray(new PsiElement[c.size()]);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            Collection<Navigatable> c = DatabaseView.getDataFromSelectedPaths(CommonDataKeys.NAVIGATABLE, (JTree)this.myTree);
            return c.isEmpty() ? null : c.toArray(new Navigatable[c.size()]);
        }
        return DatabaseView.getDataFromPath(dataId, this.myTree.getSelectionPath());
    }

    @NotNull
    private static <T> Collection<T> getDataFromSelectedPaths(@NotNull DataKey<T> key, @Nullable JTree tree) {
        TreePath[] paths;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/view/DatabaseView", "getDataFromSelectedPaths"));
        }
        TreePath[] treePathArray = paths = tree == null ? null : tree.getSelectionPaths();
        if (paths == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getDataFromSelectedPaths"));
            }
            return list;
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (TreePath path : paths) {
            ContainerUtil.addIfNotNull((Collection)result2, DatabaseView.getDataFromPath(key.getName(), path));
        }
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getDataFromSelectedPaths"));
        }
        return linkedHashSet;
    }

    @Nullable
    private static <T> T getDataFromPath(@NotNull String dataId, @Nullable TreePath path) {
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/database/view/DatabaseView", "getDataFromPath"));
        }
        Object lastNode = path == null ? null : path.getLastPathComponent();
        Object userObject = TreeUtil.getUserObject((Object)lastNode);
        return (T)(userObject instanceof DataProvider ? ((DataProvider)userObject).getData(dataId) : null);
    }

    @Nullable
    private DnDTarget findDndTargetAt(@NotNull Point point, boolean strict) {
        Object element;
        DnDTarget target;
        Object userObject;
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/database/view/DatabaseView", "findDndTargetAt"));
        }
        TreePath path = strict ? this.myTree.getPathForLocation(point.x, point.y) : this.myTree.getClosestPathForLocation(point.x, point.y);
        Object object = userObject = path == null ? null : TreeUtil.getUserObject((Object)path.getLastPathComponent());
        if (userObject instanceof NodeDescriptor && (target = DatabaseView.getDnDTarget(element = ((NodeDescriptor)userObject).getElement())) != null) {
            return target;
        }
        return null;
    }

    @Nullable
    private static DnDTarget getDnDTarget(Object element) {
        return element instanceof UserDataHolder ? (DnDTarget)((UserDataHolder)element).getUserData(DatabaseDataKeys.DND_TARGET_KEY) : null;
    }

    public static void select(@NotNull DbElement element, boolean requestFocus) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DatabaseView", "select"));
        }
        DatabaseView.select(element.getProject(), requestFocus, element);
    }

    public static void select(@NotNull Project project, boolean requestFocus, DbElement ... elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseView", "select"));
        }
        ToolWindow window = DatabaseView.getDatabaseToolWindow(project);
        DatabaseView databaseView = DatabaseView.getDatabaseView(project);
        Runnable runnable = () -> databaseView.selectElements(elements);
        if (requestFocus) {
            window.activate(runnable);
        } else {
            runnable.run();
        }
    }

    @NotNull
    public static ToolWindow getDatabaseToolWindow(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/DatabaseView", "getDatabaseToolWindow"));
        }
        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.DATABASE_VIEW);
        if (window == null) {
            DatabaseToolWindowFactory factory = new DatabaseToolWindowFactory();
            window = ToolWindowManager.getInstance((Project)project).registerToolWindow(ToolWindowId.DATABASE_VIEW, true, ToolWindowAnchor.RIGHT, (Disposable)project, true);
            factory.createToolWindowContent(project, window);
        }
        ToolWindow toolWindow = window;
        if (toolWindow == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseView", "getDatabaseToolWindow"));
        }
        return toolWindow;
    }

    @Nullable
    public Element getState() {
        Element element = XmlSerializer.serialize((Object)this.myViewOptions, null);
        try {
            TreeState.createOn((JTree)this.myTree).writeExternal(element);
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        return element;
    }

    public void loadState(Element state) {
        XmlSerializer.deserializeInto((Object)this.myViewOptions, (Element)state);
        TreeState.createFrom((Element)state).applyTo((JTree)this.myTree);
    }

    private static class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        final DatabaseView myView;

        MyAutoScrollFromSourceHandler(Project project, DatabaseView view2) {
            super(project, (JComponent)((Object)view2), (Disposable)view2);
            this.myView = view2;
        }

        protected boolean isAutoScrollEnabled() {
            return ((DatabaseView)this.myView).myViewOptions.AUTO_SCROLL_FROM_SOURCE;
        }

        protected void setAutoScrollEnabled(boolean enabled) {
            FileEditorManager fileEditorManager;
            FileEditor[] editors;
            ((DatabaseView)this.myView).myViewOptions.AUTO_SCROLL_FROM_SOURCE = enabled;
            if (enabled && (editors = (fileEditorManager = FileEditorManager.getInstance((Project)this.myProject)).getSelectedEditors()).length != 0) {
                this.selectElementFromEditor(editors[0]);
            }
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/DatabaseView$MyAutoScrollFromSourceHandler", "selectElementFromEditor"));
            }
            this.selectElementFromEditorInner(editor, false);
        }

        void selectElementFromEditorInner(@NotNull FileEditor editor, boolean force) {
            PsiFile psiFile;
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/DatabaseView$MyAutoScrollFromSourceHandler", "selectElementFromEditorInner"));
            }
            VirtualFile file = FileEditorManagerEx.getInstanceEx((Project)this.myProject).getFile(editor);
            PsiFile psiFile2 = psiFile = file == null ? null : PsiManager.getInstance((Project)this.myProject).findFile(file);
            if (psiFile == null) {
                return;
            }
            DbElement element = SelectInDatabaseView.askProviders((SelectInContext)new FileEditorSelectInContext(editor, psiFile));
            DbElement selection = (DbElement)DatabaseView.getSelectedElementOfType(DbElement.class, true, (JTree)this.myView.myTree);
            if (element != null && (force || selection == null || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)selection, (boolean)false))) {
                DatabaseView.select(this.myProject, false, element);
            }
        }
    }

    private static class MyTransferable
    implements Transferable {
        private final Object[] myObjects;

        public MyTransferable(Object[] objects) {
            this.myObjects = objects;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.stringFlavor, DnDEventImpl.ourDataFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return true;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (DataFlavor.stringFlavor.equals(flavor)) {
                StringBuilder sb = new StringBuilder();
                for (Object object : this.myObjects) {
                    if (!(object instanceof PsiNamedElement)) continue;
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(((PsiNamedElement)object).getName());
                }
                return sb.toString();
            }
            if (DnDEventImpl.ourDataFlavor.equals(flavor)) {
                return this.myObjects;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private class MyDnDSource
    implements DnDSource {
        private MyDnDSource() {
        }

        public boolean canStartDragging(DnDAction action, Point dragOrigin) {
            AbstractTreeBuilder builder = DatabaseView.this.getTreeBuilder();
            return builder.getReady((Object)DatabaseView.this).isDone() && !JBIterable.of((Object[])DatabaseView.this.myTree.getSelectionPaths()).isEmpty();
        }

        public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
            return new DnDDragStartBean((Object)new MyTransferable(DatabaseView.this.getTreeBuilder().getSelectedElements().toArray()), dragOrigin);
        }

        public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
            TreePath[] paths = (TreePath[])ObjectUtils.notNull((Object)DatabaseView.this.myTree.getSelectionPaths());
            Object userObject = ObjectUtils.notNull((Object)TreeUtil.getUserObject((Object)paths[0].getLastPathComponent()));
            PresentableNodeDescriptor nodeDescriptor = (PresentableNodeDescriptor)userObject;
            SimpleColoredComponent c = new SimpleColoredComponent();
            c.setForeground(DatabaseView.this.myTree.getForeground());
            c.setBackground(DatabaseView.this.myTree.getBackground());
            c.setIcon(nodeDescriptor.getPresentation().getIcon(false));
            for (PresentableNodeDescriptor.ColoredFragment fragment : nodeDescriptor.getPresentation().getColoredText()) {
                c.append(fragment.getText(), fragment.getAttributes());
            }
            if (paths.length > 1) {
                c.append(" +" + (paths.length - 1), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
            Dimension size = c.getPreferredSize();
            c.setSize(size);
            BufferedImage image = UIUtil.createImage((Component)c, (int)size.width, (int)size.height, (int)2);
            c.setOpaque(false);
            Graphics2D g = image.createGraphics();
            c.paint((Graphics)g);
            g.dispose();
            return Pair.create((Object)image, (Object)new Point(0, 0));
        }

        public void dragDropEnd() {
        }

        public void dropActionChanged(int gestureModifiers) {
        }
    }

    private class MyDnDTarget
    implements DnDNativeTarget {
        private MyDnDTarget() {
        }

        public boolean update(DnDEvent aEvent) {
            boolean canCreateDataSource;
            Point point = aEvent.getPointOn((Component)DatabaseView.this.myTree);
            DnDTarget target = DatabaseView.this.findDndTargetAt(point, canCreateDataSource = this.hasDdlDataSourceFiles(aEvent));
            boolean targetOk = target != null && aEvent.delegateUpdateTo(target);
            boolean ok = targetOk || canCreateDataSource;
            aEvent.setDropPossible(ok);
            if (ok) {
                RelativeRectangle rectangle;
                if (targetOk) {
                    Rectangle bounds = (Rectangle)ObjectUtils.assertNotNull((Object)DatabaseView.this.myTree.getPathBounds(DatabaseView.this.myTree.getClosestPathForLocation(point.x, point.y)));
                    rectangle = new RelativeRectangle((Component)DatabaseView.this.myTree, bounds);
                } else {
                    Rectangle bounds = DatabaseView.this.getBounds();
                    rectangle = new RelativeRectangle((Component)((Object)DatabaseView.this), bounds);
                }
                aEvent.setHighlighting(rectangle, 1);
            }
            return ok;
        }

        public void drop(DnDEvent aEvent) {
            boolean canCreateDataSource = this.hasDdlDataSourceFiles(aEvent);
            DnDTarget target = DatabaseView.this.findDndTargetAt(aEvent.getPointOn((Component)DatabaseView.this.myTree), canCreateDataSource);
            if (target != null && aEvent.delegateUpdateTo(target)) {
                aEvent.delegateDropTo(target);
            } else {
                ArrayList newElements = new ArrayList();
                List files = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)aEvent.getAttachedObject());
                for (DbPsiManager manager : DatabaseView.this.myDbFacade.getDbManagers()) {
                    newElements.addAll(manager.createDataSourceByFiles((Collection)files));
                }
                DatabaseView.select(DatabaseView.this.myProject, true, newElements.toArray(new DbElement[newElements.size()]));
            }
        }

        private boolean hasDdlDataSourceFiles(DnDEvent aEvent) {
            List files = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)aEvent.getAttachedObject());
            for (DbPsiManager manager : DatabaseView.this.myDbFacade.getDbManagers()) {
                if (!manager.canCreateDataSourceByFiles((Collection)files)) continue;
                return true;
            }
            return SystemInfo.isMac && files.isEmpty();
        }

        public void cleanUpOnLeave() {
        }

        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
        }
    }
}

