/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseObjectEditor
extends DatabaseEditorBaseEx {
    private JTextField myNameField;
    private JPanel myPanel;
    private final ObjectEditorModel<?> myObjectModel;
    private final DatabaseEditorCapabilities.ObjectEditorCaps myCaps;
    private final EditorModelBase.Listener myChangeListener;

    public DatabaseObjectEditor(@NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.ObjectEditorCaps caps, @NotNull ObjectEditorModel<?> model) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/editors/DatabaseObjectEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseObjectEditor", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseObjectEditor", "<init>"));
        }
        super(state);
        this.myChangeListener = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseObjectEditor.this.fromModelToUi();
            }
        };
        this.myObjectModel = model;
        this.myCaps = caps;
        this.$$$setupUI$$$();
        this.applyCaps();
        this.setupControls();
    }

    private void applyCaps() {
        this.myNameField.setEnabled(this.myCaps.getRename().isAvailable());
    }

    private void setupControls() {
        this.initSubscriptions();
        this.updateFromModel();
    }

    @Override
    @NotNull
    public ObjectEditorModel<?> getModel() {
        ObjectEditorModel<?> objectEditorModel = this.myObjectModel;
        if (objectEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseObjectEditor", "getModel"));
        }
        return objectEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        DatabaseObjectEditor.setValue(this.myNameField, this.myObjectModel.getName());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseObjectEditor", "getComponent"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JTextField jTextField = this.myNameField;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseObjectEditor", "getPreferredFocusedComponent"));
        }
        return jTextField;
    }

    private void initSubscriptions() {
        this.myObjectModel.addListener(this.myChangeListener, this);
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!DatabaseObjectEditor.this.myUpdating) {
                    DatabaseObjectEditor.this.myObjectModel.setName(DatabaseObjectEditor.this.myNameField.getText());
                    DatabaseObjectEditor.this.myObjectModel.commit();
                }
            }
        });
    }

    @Nullable
    public ValidationInfo validate() {
        if (StringUtil.isEmpty((String)this.myObjectModel.getName())) {
            return new ValidationInfo("'" + this.myObjectModel.getName() + "' is not a valid " + this.myObjectModel.getObject().getKind().code() + " name", (JComponent)this.myNameField);
        }
        return null;
    }

    @NotNull
    public JTextField getNameEditor() {
        JTextField jTextField = this.myNameField;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseObjectEditor", "getNameEditor"));
        }
        return jTextField;
    }

    @NotNull
    public DatabaseEditorCapabilities.ObjectEditorCaps getCaps() {
        DatabaseEditorCapabilities.ObjectEditorCaps objectEditorCaps = this.myCaps;
        if (objectEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseObjectEditor", "getCaps"));
        }
        return objectEditorCaps;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jBLabel.setDisplayedMnemonic('N');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBTextField jBTextField = new JBTextField();
        this.myNameField = jBTextField;
        jPanel.add((Component)jBTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

