/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseObjectCommentEditor;
import com.intellij.database.view.editors.DatabaseTableColumnsEditor;
import com.intellij.database.view.editors.DatabaseTableForeignKeysEditor;
import com.intellij.database.view.editors.DatabaseTableIndicesEditor;
import com.intellij.database.view.editors.DatabaseTableKeysEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.TableEditorToolbarsDecorator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableEditor
extends DatabaseEditorBaseEx {
    private static final Border BORDER = IdeBorderFactory.createBorder((int)13);
    private JTextField myTableNameField;
    private JLabel myTableNameLabel;
    private JPanel myMainPanel;
    private JComponent myTabsPanel;
    private JPanel myCommentHolder;
    private JPanel myCommentPanel;
    private JLabel myCommentLabel;
    private JBTextField myCommentField;
    private TabbedPaneWrapper myTabs;
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;
    private final TableEditorModel myTableModel;
    private final List<TabProvider> myTabProviders;

    private boolean setSelectedTabSafe(@NotNull JComponent comp) {
        if (comp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/database/view/editors/DatabaseTableEditor", "setSelectedTabSafe"));
        }
        int idx = this.myTabs.indexOfComponent(comp);
        if (idx != -1) {
            this.myTabs.setSelectedIndex(idx);
        }
        return idx != -1;
    }

    @Nullable
    public DatabaseEditorBaseEx startItemEditing(@NotNull DeObject exported) {
        if (exported == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exported", "com/intellij/database/view/editors/DatabaseTableEditor", "startItemEditing"));
        }
        for (TabProvider provider : this.myTabProviders) {
            if (!provider.isMyObject(exported)) continue;
            return this.setSelectedTabSafe(provider.getComponent()) ? provider.startItemEditing(exported) : null;
        }
        return null;
    }

    @NotNull
    public DatabaseEditorBaseEx getActiveEditor() {
        JComponent tab = this.myTabs.getSelectedComponent();
        DatabaseEditorBaseEx res = null;
        for (TabProvider provider : this.myTabProviders) {
            if (tab != provider.getComponent()) continue;
            res = provider.getActiveEditor();
        }
        DatabaseEditorBaseEx databaseEditorBaseEx = (DatabaseEditorBaseEx)ObjectUtils.chooseNotNull(res, (Object)this);
        if (databaseEditorBaseEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getActiveEditor"));
        }
        return databaseEditorBaseEx;
    }

    @NotNull
    public DatabaseEditorCapabilities.TableEditorCaps getCaps() {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = this.myCaps;
        if (tableEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getCaps"));
        }
        return tableEditorCaps;
    }

    public DatabaseTableEditor(@NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorModel tableModel) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/editors/DatabaseTableEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseTableEditor", "<init>"));
        }
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/database/view/editors/DatabaseTableEditor", "<init>"));
        }
        this(state, caps, tableModel, new TableEditorToolbarsDecorator.DefaultToolbarsDecorator());
    }

    public DatabaseTableEditor(@NotNull DatabaseEditorState state, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorModel tableModel, @NotNull TableEditorToolbarsDecorator decorator) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/editors/DatabaseTableEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseTableEditor", "<init>"));
        }
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/database/view/editors/DatabaseTableEditor", "<init>"));
        }
        if (decorator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorator", "com/intellij/database/view/editors/DatabaseTableEditor", "<init>"));
        }
        super(state);
        this.myCaps = caps;
        this.myTableModel = tableModel;
        this.myTabProviders = this.getTabProviders(decorator, caps);
        this.$$$setupUI$$$();
        JButton commentBtn = DatabaseObjectCommentEditor.createButton(this.getContext(), this.myTableModel, this.myTableNameField);
        this.myCommentHolder.add((Component)commentBtn, "Center");
        this.myTableNameLabel.setLabelFor(this.myTableNameField);
        this.applyCaps();
        for (JComponent c : ((JBTreeTraverser)UIUtil.uiTraverser((Component)this.myTabs.getComponent()).expandAndFilter(Conditions.not((Condition)Conditions.instanceOf(JTable.class)))).filter(JComponent.class)) {
            c.setFocusCycleRoot(false);
            c.setFocusTraversalPolicy(null);
        }
        this.initSubscriptions();
        this.updateFromModel();
    }

    @NotNull
    protected Border getTabComponentBorder() {
        Border border = BORDER;
        if (border == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getTabComponentBorder"));
        }
        return border;
    }

    protected void applyCaps() {
        this.myCommentHolder.setVisible(this.myCaps.getComment().isSupported());
        this.myCommentHolder.getComponent(0).setEnabled(this.myCaps.getComment().isAvailable());
        this.myCommentPanel.setVisible(this.myCaps.getComment().isSupported());
        this.myCommentLabel.setVisible(this.myCaps.getComment().isSupported());
        this.myTableNameField.setEnabled(this.myCaps.getRename().isAvailable());
        for (TabProvider provider : this.myTabProviders) {
            provider.configure(this.myCaps);
        }
        this.refillTabs();
    }

    @NotNull
    protected List<TabProvider> getTabProviders(@NotNull TableEditorToolbarsDecorator decorator, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (decorator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorator", "com/intellij/database/view/editors/DatabaseTableEditor", "getTabProviders"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseTableEditor", "getTabProviders"));
        }
        List list = ContainerUtil.list((Object[])new TabProvider[]{new DatabaseTableColumnsEditor(this, caps, decorator), new DatabaseTableKeysEditor(this, caps, decorator), new DatabaseTableIndicesEditor(this, caps, decorator), new DatabaseTableForeignKeysEditor(this, caps, decorator)});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getTabProviders"));
        }
        return list;
    }

    public void initSubscriptions() {
        this.myTableNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (DatabaseTableEditor.this.myUpdating) {
                    return;
                }
                DatabaseTableEditor.this.myTableModel.setName(DatabaseTableEditor.this.myTableNameField.getText());
                DatabaseTableEditor.this.myTableModel.commit();
            }
        });
        this.myCommentField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (DatabaseTableEditor.this.myUpdating) {
                    return;
                }
                String newVal = StringUtil.nullize((String)DatabaseTableEditor.this.myCommentField.getText());
                String oldVal = StringUtil.nullize((String)DatabaseTableEditor.this.myTableModel.getComment());
                if (Comparing.equal((String)oldVal, (String)newVal)) {
                    return;
                }
                DatabaseTableEditor.this.myTableModel.setComment(newVal);
                DatabaseTableEditor.this.myTableModel.commit();
            }
        });
        this.myTableModel.addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableEditor.this.fromModelToUi();
            }
        }, this);
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeTable> getModel() {
        TableEditorModel tableEditorModel = this.getTableModel();
        if (tableEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getModel"));
        }
        return tableEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        DatabaseTableEditor.setValue(this.myTableNameField, this.getTableModel().getName());
        DatabaseTableEditor.setValue((JTextField)this.myCommentField, StringUtil.notNullize((String)this.getTableModel().getComment()));
        this.myTabProviders.forEach(TabProvider::updateFromModel);
        this.updateTabTitles();
    }

    protected void updateTabTitles() {
        for (TabProvider provider : this.myTabProviders) {
            if (!provider.isTabEnabled()) continue;
            this.myTabs.setTitleAt(this.myTabs.indexOfComponent(provider.getComponent()), provider.getTabTitle());
        }
    }

    private void refillTabs() {
        JComponent prevComp = this.myTabs.getSelectedComponent();
        this.myTabs.removeAll();
        for (TabProvider provider : this.myTabProviders) {
            if (!provider.isTabEnabled()) continue;
            JComponent comp = provider.getComponent();
            this.myTabs.addTab(provider.getTabTitle(), comp);
        }
        int index = this.myTabs.indexOfComponent(prevComp);
        if (index != -1) {
            this.myTabs.setSelectedIndex(index);
        }
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableModel;
        if (tableEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getTableModel"));
        }
        return tableEditorModel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JTextField jTextField = this.myTableNameField;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getPreferredFocusedComponent"));
        }
        return jTextField;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public ValidationInfo validate() {
        if (StringUtil.isEmpty((String)this.getTableModel().getName())) {
            return new ValidationInfo("'" + this.getTableModel().getName() + "' is not a valid table name", (JComponent)this.myTableNameField);
        }
        for (TabProvider provider : this.myTabProviders) {
            ValidationInfo info = provider.validate();
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private void createUIComponents() {
        this.myTabs = new TabbedPaneWrapper((Disposable)this);
        this.myTabsPanel = this.myTabs.getComponent();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getTable"));
        }
        return deTable;
    }

    @NotNull
    public JTextField getNameEditor() {
        JTextField jTextField = this.myTableNameField;
        if (jTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getNameEditor"));
        }
        return jTextField;
    }

    @NotNull
    public JTextField getCommentEditor() {
        JBTextField jBTextField = this.myCommentField;
        if (jBTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getCommentEditor"));
        }
        return jBTextField;
    }

    @NotNull
    public DatabaseTableColumnsEditor getColumnsEditor() {
        DatabaseTableColumnsEditor databaseTableColumnsEditor = this.get(DatabaseTableColumnsEditor.class);
        if (databaseTableColumnsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getColumnsEditor"));
        }
        return databaseTableColumnsEditor;
    }

    @NotNull
    public DatabaseTableIndicesEditor getIndicesEditor() {
        DatabaseTableIndicesEditor databaseTableIndicesEditor = this.get(DatabaseTableIndicesEditor.class);
        if (databaseTableIndicesEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getIndicesEditor"));
        }
        return databaseTableIndicesEditor;
    }

    @NotNull
    public DatabaseTableKeysEditor getKeysEditor() {
        DatabaseTableKeysEditor databaseTableKeysEditor = this.get(DatabaseTableKeysEditor.class);
        if (databaseTableKeysEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getKeysEditor"));
        }
        return databaseTableKeysEditor;
    }

    @NotNull
    public DatabaseTableForeignKeysEditor getForeignKeysEditor() {
        DatabaseTableForeignKeysEditor databaseTableForeignKeysEditor = this.get(DatabaseTableForeignKeysEditor.class);
        if (databaseTableForeignKeysEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "getForeignKeysEditor"));
        }
        return databaseTableForeignKeysEditor;
    }

    @NotNull
    private <T extends TabProvider> T get(@NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/view/editors/DatabaseTableEditor", "get"));
        }
        TabProvider tabProvider = (TabProvider)ObjectUtils.assertNotNull((Object)JBIterable.from(this.myTabProviders).filter(clazz).first());
        if (tabProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableEditor", "get"));
        }
        return (T)tabProvider;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JBTextField jBTextField;
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JComponent jComponent = this.myTabsPanel;
        jPanel3.add((Component)jComponent, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTableNameLabel = jLabel2 = new JLabel();
        jLabel2.setText("Table:");
        jLabel2.setDisplayedMnemonic('B');
        jLabel2.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCommentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 0, null, null, null));
        this.myCommentHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "East");
        this.myCommentField = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, "Center");
        this.myCommentLabel = jLabel = new JLabel();
        jLabel.setText("Comment:");
        jLabel.setDisplayedMnemonic('C');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTableNameField = jTextField = new JTextField();
        jTextField.setText("");
        jTextField.setColumns(0);
        jPanel3.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    public static abstract class TabProvider {
        private boolean myTabEnabled = true;

        @NotNull
        public abstract JComponent getComponent();

        @Nullable
        public abstract DatabaseEditorBaseEx startItemEditing(@NotNull DeObject var1);

        @Nullable
        public abstract DatabaseEditorBaseEx getActiveEditor();

        @NotNull
        public abstract String getTabTitle();

        public abstract boolean isMyObject(@NotNull DeObject var1);

        public abstract void updateFromModel();

        public abstract void configure(@NotNull DatabaseEditorCapabilities.TableEditorCaps var1);

        @Nullable
        public ValidationInfo validate() {
            return null;
        }

        void setTabEnabled(boolean enabled) {
            this.myTabEnabled = enabled;
        }

        boolean isTabEnabled() {
            return this.myTabEnabled;
        }
    }
}

