/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.openapi.ui.ValidationInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbTableDialog
extends AbstractDbRefactoringDialog<DatabaseTableEditor> {
    protected TableEditorModel myTableModel;

    public DbTableDialog(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbTableDialog", "<init>"));
        }
        super(context);
    }

    @Override
    @NotNull
    protected String getTitle(boolean modify) {
        String string = modify ? "Modify Table" : DatabaseMessages.message((String)"action.add.new.table.title", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbTableDialog", "getTitle"));
        }
        return string;
    }

    @NotNull
    protected DatabaseEditorCapabilities.TableEditorCaps getTableEditorCaps(boolean existing) {
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = this.getContext().getDialect().getSchemaEditor().getDbEditorCaps().getTableEditorCaps(existing);
        if (tableEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbTableDialog", "getTableEditorCaps"));
        }
        return tableEditorCaps;
    }

    public void setObject(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DbTableDialog", "setObject"));
        }
        if (object.model != this.myModel) {
            throw new AssertionError((Object)"Invalid object");
        }
        DeTable table = null;
        if (object instanceof DeTable) {
            table = (DeTable)object;
        }
        if (object instanceof DeTableChild) {
            table = ((DeTableChild)object).table;
        }
        if (table == null) {
            throw new AssertionError((Object)"Invalid object");
        }
        this.setTable(table, allowEverything);
    }

    public void setTable(@NotNull DeTable table, boolean allowEverything) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/ui/DbTableDialog", "setTable"));
        }
        if (table.model != this.myModel) {
            throw new AssertionError((Object)"Invalid table");
        }
        this.myTableModel = this.myEditorModelsCache.get(table, TableEditorModel.class);
        this.setEditor(new DatabaseTableEditor(this.myState, this.getTableEditorCaps(!allowEverything && table.editedObject != null), this.myTableModel));
    }

    @Override
    protected boolean isRefactoringValid() {
        boolean supportsEmptyTables = this.getContext().getDialect().supportsEmptyTables();
        boolean notEmpty = !this.myTableModel.getColumns().isEmpty();
        return (supportsEmptyTables || notEmpty) && super.isRefactoringValid();
    }

    @Override
    protected ValidationInfo doValidate() {
        ValidationInfo info = ((DatabaseTableEditor)this.myEditor).validate();
        return info == null ? super.doValidate() : info;
    }

    @NotNull
    public DeTable createTable(@Nullable DasNamespace schema, @NotNull String defaultName, @NotNull Collection<String> columnNames) {
        if (defaultName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultName", "com/intellij/database/view/ui/DbTableDialog", "createTable"));
        }
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/database/view/ui/DbTableDialog", "createTable"));
        }
        this.checkObjectInContext((DasObject)schema);
        DeNamespace deSchema = null;
        if (schema != null) {
            deSchema = (DeNamespace)this.export((DasObject)schema, false);
        }
        DeTable table = new DeTable(defaultName, deSchema, this.myModel);
        for (String name : columnNames) {
            table.columns.add(new DeColumn(name, table, this.myModel));
        }
        if (deSchema != null) {
            deSchema.addLightChild(table);
        } else {
            this.myModel.addRoot(table);
        }
        DeTable deTable = table;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbTableDialog", "createTable"));
        }
        return deTable;
    }

    @NotNull
    public DeTable createTable(@Nullable DasNamespace schema, @NotNull DeTable template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/database/view/ui/DbTableDialog", "createTable"));
        }
        this.checkObjectInContext((DasObject)schema);
        DeNamespace deSchema = null;
        if (schema != null) {
            deSchema = (DeNamespace)this.export((DasObject)schema, false);
        }
        DeTable table = this.copyExport(template, true);
        table.parent = deSchema;
        if (deSchema != null) {
            deSchema.addLightChild(table);
        } else {
            this.myModel.addRoot(table);
        }
        DeTable deTable = table;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbTableDialog", "createTable"));
        }
        return deTable;
    }

    @NotNull
    public DeObject createEmptyTemplate(@Nullable DasObject parent) {
        this.checkObjectInContext(parent);
        DeTable table = new DeTable("new_table", (DeObject)this.exportOp(parent, false), this.myModel);
        if (table.parent != null) {
            table.parent.addLightChild(table);
        } else {
            this.myModel.addRoot(table);
        }
        DeTable deTable = table;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbTableDialog", "createEmptyTemplate"));
        }
        return deTable;
    }

    public void configureForModification(@NotNull DasObject object, boolean allowEverything) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DbTableDialog", "configureForModification"));
        }
        this.checkObjectInContext(object);
        if (object instanceof DasTableChild) {
            this.export((DasObject)((DasTableChild)object).getTable(), true);
        }
        this.configureForModification((DeObject)this.export(object, true), allowEverything);
    }

    public void configureForModification(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DbTableDialog", "configureForModification"));
        }
        if (object.model != this.myModel) {
            throw new AssertionError((Object)"Invalid object");
        }
        this.setObject(object, allowEverything);
        this.setRefactoring(true);
    }

    public void configureForCreation(@NotNull DeObject object, boolean allowEverything) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DbTableDialog", "configureForCreation"));
        }
        this.setObject(object, allowEverything);
    }

    @Nullable
    public DatabaseEditorBaseEx startItemEditing(@NotNull DeObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DbTableDialog", "startItemEditing"));
        }
        return ((DatabaseTableEditor)this.myEditor).startItemEditing(object);
    }

    @Override
    @NotNull
    public DatabaseEditorBaseEx getActiveEditor() {
        DatabaseEditorBaseEx databaseEditorBaseEx = ((DatabaseTableEditor)this.myEditor).getActiveEditor();
        if (databaseEditorBaseEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbTableDialog", "getActiveEditor"));
        }
        return databaseEditorBaseEx;
    }

    @Nullable
    protected String getHelpId() {
        return "reference.tools.datasource.table.modify";
    }
}

