/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlValuesParameterInfoHandler;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlInlayValuesParameterHintsHandler
implements InlayParameterHintsProvider {
    private static final Option COLUMN_NAMES_IN_INSERT_VALUES = new Option("sql.show.column.names.in.insert.values", "Show column names in insert values", false);

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getParameterHints"));
        }
        if (!COLUMN_NAMES_IN_INSERT_VALUES.get()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getParameterHints"));
            }
            return list;
        }
        SqlFunctionsUtil.ExpressionList list = SqlInlayValuesParameterHintsHandler.getExpressionList(element);
        if (list == null || !list.isValid()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getParameterHints"));
            }
            return list2;
        }
        ArrayList objects = ContainerUtil.newArrayList();
        list.processArgumentTypes((e, name, type) -> objects.add(new InlayInfo(StringUtil.notNullize((String)name), e.getTextRange().getStartOffset())));
        ArrayList arrayList = objects;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getParameterHints"));
        }
        return arrayList;
    }

    @Nullable
    private static SqlFunctionsUtil.ExpressionList getExpressionList(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getExpressionList"));
        }
        if (!(element instanceof SqlParenthesizedExpression)) {
            return null;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, SqlValuesExpression.class) == null) {
            return null;
        }
        Object[] lists = SqlValuesParameterInfoHandler.getLists((SqlExpressionList)((SqlParenthesizedExpression)element));
        return (SqlFunctionsUtil.ExpressionList)JBIterable.of((Object[])lists).filter(SqlFunctionsUtil.ExpressionList::isMatched).first();
    }

    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getHintInfo"));
        }
        SqlFunctionsUtil.ExpressionList list = SqlInlayValuesParameterHintsHandler.getExpressionList(element);
        return list != null ? new HintInfo.OptionInfo(COLUMN_NAMES_IN_INSERT_VALUES) : null;
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getDefaultBlackList"));
        }
        return set;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        List list = ContainerUtil.newSmartList((Object)COLUMN_NAMES_IN_INSERT_VALUES);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlInlayValuesParameterHintsHandler", "getSupportedOptions"));
        }
        return list;
    }

    public boolean isBlackListSupported() {
        return false;
    }
}

