/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import icons.DatabaseIcons;
import org.jetbrains.annotations.NotNull;

public class SqlResolveTree
extends DbCheckBoxTree<MyNode> {
    public SqlResolveTree(@NotNull CheckedTreeNode root2) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/sql/dialects/SqlResolveTree", "<init>"));
        }
        super(root2, new MyTreeCellRenderer());
    }

    static CheckedTreeNode createNode(MyNode node) {
        return new CheckedTreeNode(node){

            public boolean isChecked() {
                return ((MyNode)this.getUserObject()).isChecked();
            }

            public void setChecked(boolean checked) {
                ((MyNode)this.getUserObject()).setChecked(checked);
            }
        };
    }

    public static class MyNode
    extends DbCheckBoxTree.MyNode<MyNode> {
        public MyNode(String name, ObjectKind kind, Object object) {
            super(name, kind, object);
        }

        @Override
        @NotNull
        protected MyNode createAll() {
            MyNode myNode = new MyNode("All", this.getChildKind(), "*");
            if (myNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlResolveTree$MyNode", "createAll"));
            }
            return myNode;
        }
    }

    private static class MyTreeCellRenderer
    extends DbCheckBoxTree.CellWithUnderlinedAllRenderer<MyNode> {
        private MyTreeCellRenderer() {
        }

        @Override
        protected void customizeCheckboxRenderer(MyNode node) {
            if (node.getParent() == null) {
                return;
            }
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            if (node.getKind() == SqlImportUtil.DATA_SOURCE) {
                if (node.getObject() instanceof LocalDataSource) {
                    renderer.setIcon(((LocalDataSource)node.getObject()).getBaseIcon());
                } else if (node.getObject() instanceof SqlDataSource) {
                    renderer.setIcon(DatabaseIcons.DdlDbms);
                }
            }
            this.renderText(node, (ColoredTextContainer)renderer);
        }

        @Override
        protected void renderText(MyNode node, ColoredTextContainer renderer) {
            String name = node.getName();
            if (node.getObject() instanceof DasObject || node.getObject() instanceof DatabaseSystem) {
                if (StringUtil.isEmpty((String)name)) {
                    renderer.append("<Unnamed>", SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else {
                    renderer.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            } else if (node.getObject() == "*") {
                String pluralized = StringUtil.toLowerCase((String)StringUtil.pluralize((String)node.getKind().name()));
                renderer.append("All " + StringUtil.capitalizeWords((String)pluralized, (boolean)true), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                renderer.append(StringUtil.isEmpty((String)name) ? "<Unnamed>" : name, SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
            }
        }
    }
}

