/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.postgres.PostgresDialect;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlAsExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PgTypedAliasDefinitionImpl
extends SqlAsExpressionImpl {
    private SqlIdentifier myIdentifier;

    public PgTypedAliasDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/postgres/psi/PgTypedAliasDefinitionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public SqlIdentifier getNameElement() {
        if (this.myIdentifier != null) {
            SqlIdentifier sqlIdentifier = this.myIdentifier;
            if (sqlIdentifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgTypedAliasDefinitionImpl", "getNameElement"));
            }
            return sqlIdentifier;
        }
        this.myIdentifier = (SqlIdentifier)this.findChildByClass(SqlIdentifier.class);
        if (this.myIdentifier != null) {
            SqlIdentifier sqlIdentifier = this.myIdentifier;
            if (sqlIdentifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgTypedAliasDefinitionImpl", "getNameElement"));
            }
            return sqlIdentifier;
        }
        SqlExpression expression = this.getExpression();
        if (expression instanceof SqlFunctionCallExpression) {
            SqlReferenceExpression callable = ((SqlFunctionCallExpression)expression).getNameElement();
            this.myIdentifier = callable == null ? null : callable.getIdentifier();
        } else if (expression instanceof SqlDefinition) {
            this.myIdentifier = (SqlIdentifier)ObjectUtils.tryCast((Object)((SqlDefinition)expression).getNameElement(), SqlIdentifier.class);
        }
        if (this.myIdentifier != null) {
            SqlIdentifier sqlIdentifier = this.myIdentifier;
            if (sqlIdentifier == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgTypedAliasDefinitionImpl", "getNameElement"));
            }
            return sqlIdentifier;
        }
        SqlReferenceExpression refByText = (SqlReferenceExpression)ObjectUtils.assertNotNull((Object)SqlPsiElementFactory.createReferenceFromText("\"\"", PostgresDialect.INSTANCE, SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE, (PsiElement)this));
        SqlIdentifier sqlIdentifier = this.myIdentifier = (SqlIdentifier)ObjectUtils.assertNotNull((Object)refByText.getIdentifier());
        if (sqlIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgTypedAliasDefinitionImpl", "getNameElement"));
        }
        return sqlIdentifier;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myIdentifier = null;
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        List<SqlColumnAliasDefinition> aliases = this.getColumnAliasList();
        if (aliases.isEmpty() || PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)aliases.get(0)), SqlTypeElement.class) == null) {
            SqlType sqlType = super.getSqlType();
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgTypedAliasDefinitionImpl", "getSqlType"));
            }
            return sqlType;
        }
        String name = this.getName();
        ArrayList columns2 = ContainerUtil.newArrayListWithCapacity((int)aliases.size());
        for (SqlColumnAliasDefinition a : aliases) {
            SqlTypeElement type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)a, SqlTypeElement.class);
            columns2.add(new SqlImplUtil.Column(a.getName(), (SqlType)(type == null ? SqlType.UNKNOWN : type.findSqlType()), (PsiElement)a, null));
        }
        SqlTableType sqlTableType = SqlImplUtil.createType(name, columns2, (PsiElement)this);
        if (sqlTableType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgTypedAliasDefinitionImpl", "getSqlType"));
        }
        return sqlTableType;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiElement type = this.getDefinitionScope();
        Object object = type == null ? super.getUseScope() : new LocalSearchScope(type);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/psi/PgTypedAliasDefinitionImpl", "getUseScope"));
        }
        return object;
    }
}

