/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.redshift;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.PostgresReservedKeywords;
import com.intellij.sql.dialects.postgres.PostgresTokens;
import com.intellij.sql.dialects.postgres.psi.PgCreatePreparedStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedshiftDialect
extends SqlLanguageDialectEx {
    public static final RedshiftDialect INSTANCE = new RedshiftDialect();

    public RedshiftDialect() {
        super("Redshift");
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.RedshiftDialect redshiftDialect = com.intellij.database.dialects.RedshiftDialect.INSTANCE;
        if (redshiftDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/redshift/RedshiftDialect", "getDatabaseDialect"));
        }
        return redshiftDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map = LazyData.ourFunctionMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/redshift/RedshiftDialect", "getSupportedFunctions"));
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition.Type> getBuiltInTypes() {
        Map<String, SqlFunctionDefinition.Type> map = Types.types;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/redshift/RedshiftDialect", "getBuiltInTypes"));
        }
        return map;
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(PostgresTokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/redshift/RedshiftDialect", "getKeywords"));
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/redshift/RedshiftDialect", "getSystemVariables"));
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        PgCreatePreparedStatement preparedStatement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/redshift/RedshiftDialect", "processReservedEntitiesWithType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/redshift/RedshiftDialect", "processReservedEntitiesWithType"));
        }
        if (resolve && name != null && Types.ARG_PATTERN.matcher(name).matches() && (preparedStatement = (PgCreatePreparedStatement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{PgCreatePreparedStatement.class})) != null && !processor.executeTarget(preparedStatement.getArgument(name), element, (SqlType)SqlType.UNKNOWN, null, ResolveState.initial())) {
            return false;
        }
        if (processor.getExpectedTypes().contains(ObjectKind.COLUMN)) {
            for (DasObject entity : LazyData.RESERVED_INTEGER_ENTITIES.values()) {
                if (RedshiftDialect.processReservedEntitiesWithTypeSimple(entity, (SqlType)SqlType.INTEGER, name, element, resolve, processor, true, false)) continue;
                return false;
            }
        }
        if (element instanceof SqlReferenceExpression && resolve && ((SqlReferenceExpression)element).getQualifierExpression() == null) {
            for (ReservedEntity object : LazyData.ourObjects) {
                if (processor.executeTarget((DasObject)object, element, null, false, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource) {
        RawConnectionConfig config = SqlImportUtil.getConnectionConfig(dataSource);
        ObjectName dbname = ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName(config), (Object)SqlDialectImplUtil.getUserName(config))));
        DasNamespace namespace = RedshiftDialect.getDefaultNamespace(dataSource, dbname);
        if (namespace != null) {
            return SqlDialectImplUtil.createObjectPattern(dataSource, (DasObject)namespace, namespace.getKind() == SqlDbElementType.SCHEMA ? null : SqlImportUtil.createNode(ObjectName.quoted((String)"public"), SqlDbElementType.SCHEMA, new TreePatternNode.Group[0]));
        }
        return new TreePattern(SqlImportUtil.createDataSources(dataSource, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbname, SqlImportUtil.createNode(ObjectName.quoted((String)"public"), SqlDbElementType.SCHEMA, new TreePatternNode.Group[0])))));
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable DbDataSource dataSource, @NotNull TreePattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/redshift/RedshiftDialect", "applyImplicitImports"));
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dataSource, Collections.singletonList(ObjectName.quoted((String)"pg_catalog")), true, SqlImportUtil.DATA_SOURCE, SqlDbElementType.DATABASE, SqlDbElementType.SCHEMA);
        if (treePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/redshift/RedshiftDialect", "applyImplicitImports"));
        }
        return treePattern;
    }

    public boolean isResolveTargetAccepted(@NotNull PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/redshift/RedshiftDialect", "isResolveTargetAccepted"));
        }
        if (expectedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedTypes", "com/intellij/sql/dialects/redshift/RedshiftDialect", "isResolveTargetAccepted"));
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            PsiElement parent = element.getParent();
            return parent instanceof SqlFromClause || parent instanceof SqlJoinExpression;
        }
        if (type == SqlDbElementType.USER && expectedTypes.contains(SqlDbElementType.ROLE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element, type, expectedTypes);
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/dialects/redshift/RedshiftDialect", "shouldQuotedTypeReferenceBeChecked"));
        }
        return true;
    }

    @Override
    public boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/redshift/RedshiftDialect", "isMajorChild"));
        }
        return kind == SqlDbElementType.KEY || kind == SqlDbElementType.INDEX;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final List<ReservedEntity> ourObjects = SqlDialectImplUtil.loadObjects(INSTANCE, "fallback.txt");
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(PostgresReservedKeywords.class);
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlTokens.SQL_QUESTION_MARK, SqlTokens.PG_OP_ABS, SqlTokens.SQL_OP_NOT2, SqlTokens.PG_OP_BITWISE_XOR, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_LOGICAL_AND, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_OP_NULLSAFE_EQ, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.PG_OP_PRIME, SqlTokens.PG_OP_CUSTOM, SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_PLUS_EQ, SqlTokens.SQL_OP_MINUS_EQ, SqlTokens.SQL_OP_MUL_EQ, SqlTokens.SQL_OP_DIV_EQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQEQ, SqlTokens.SQL_OP_NEQ3, SqlTokens.SQL_OP_MODULO_EQ, SqlTokens.SQL_OP_BITWISE_AND_EQ, SqlTokens.SQL_OP_BITWISE_OR_EQ, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_BITWISE_XOR, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_NEQ2, SqlTokens.ORA_OP_JOIN});
        static final Map<String, DasObject> RESERVED_INTEGER_ENTITIES = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "OID", "TABLEOID", "XMIN", "CMIN", "XMAX", "CMAX", "CTID");

        private LazyData() {
        }
    }

    public static class Types {
        public static final Map<String, SqlFunctionDefinition.Type> types = ContainerUtil.newMapFromValues(Arrays.asList(new SqlFunctionDefinition.Type("dpn", "double precision or numeric", (SqlType)SqlType.REAL), new SqlFunctionDefinition.Type("bigint", "bigint", (SqlType)SqlType.REAL), new SqlFunctionDefinition.Type("numeric", "numeric", (SqlType)SqlType.REAL), new SqlFunctionDefinition.Type("dp", "double precision", (SqlType)SqlType.REAL), new SqlFunctionDefinition.Type("bytea", "bytea", (SqlType)SqlType.BYTES), new SqlFunctionDefinition.Type("name", "name", (SqlType)SqlType.STRING), new SqlFunctionDefinition.Type("str[]", "str[]", (SqlType)SqlType.ARRAY), new SqlFunctionDefinition.Type("oid", "oid", null), new SqlFunctionDefinition.Type("gobject", "geometric object", null), new SqlFunctionDefinition.Type("circle", "circle", null), new SqlFunctionDefinition.Type("path", "path", null), new SqlFunctionDefinition.Type("box", "box", null), new SqlFunctionDefinition.Type("polygon", "polygon", null), new SqlFunctionDefinition.Type("lseg", "lseg", null), new SqlFunctionDefinition.Type("point", "point", null), new SqlFunctionDefinition.Type("line", "line", null), new SqlFunctionDefinition.Type("cidr", "cidr", null), new SqlFunctionDefinition.Type("inet", "inet", null), new SqlFunctionDefinition.Type("macaddr", "macaddr", null), new SqlFunctionDefinition.Type("tsvector", "tsvector", null), new SqlFunctionDefinition.Type("tsquery", "tsquery", null), new SqlFunctionDefinition.Type("trigger", "trigger", null), new SqlFunctionDefinition.Type("range", "range", null), new SqlFunctionDefinition.Type("txid_snapshot", "txid_snapshot", null), new SqlFunctionDefinition.Type("void", "void", null), new SqlFunctionDefinition.Type("record", "record", null), new SqlFunctionDefinition.Type("enum", "enum", null), new SqlFunctionDefinition.Type("xml", "xml", null), new SqlFunctionDefinition.Type("float4", "float4", null), new SqlFunctionDefinition.Type("int2vector", "int2vector", null), new SqlFunctionDefinition.Type("json", "json", null), new SqlFunctionDefinition.Type("jsonb", "jsonb", null)).iterator(), o -> o.getName());
        public static final Pattern ARG_PATTERN = Pattern.compile("\\$\\d+");
    }
}

