/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlTokenType;
import org.jetbrains.annotations.NotNull;

public class SqlUnaryExpressionImpl
extends SqlExpressionImpl
implements SqlUnaryExpression {
    public SqlUnaryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlUnaryExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlUnaryExpression((SqlUnaryExpression)this);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlPrimitiveType type;
        IElementType sign = this.getOpSign();
        SqlExpression operand = this.getOperand();
        Object object = type = operand != null ? operand.getSqlType() : SqlType.UNKNOWN;
        if (sign == SqlTokens.SQL_NOT || sign == SqlTokens.SQL_EXISTS || sign == SqlTokens.SQL_UNIQUE || sign == SqlTokens.SQL_IS || sign == SqlTokens.SQL_OP_NOT2) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.BOOLEAN;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlUnaryExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        if (sign == SqlTokens.SQL_OP_PLUS || sign == SqlTokens.SQL_OP_MINUS) {
            SqlPrimitiveType sqlPrimitiveType = type == SqlType.REAL ? type : SqlType.INTEGER;
            if (sqlPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlUnaryExpressionImpl", "getSqlType"));
            }
            return sqlPrimitiveType;
        }
        SqlType sqlType = super.getSqlType();
        if (sqlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlUnaryExpressionImpl", "getSqlType"));
        }
        return sqlType;
    }

    @NotNull
    public IElementType getOpSign() {
        ASTNode astNode = this.getOpSignElement().getNode();
        assert (astNode != null);
        IElementType iElementType = astNode.getElementType();
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlUnaryExpressionImpl", "getOpSign"));
        }
        return iElementType;
    }

    @NotNull
    public PsiElement getOpSignElement() {
        for (ASTNode node : this.getNode().getChildren(null)) {
            PsiElement element;
            IElementType type = node.getElementType();
            if (type == TokenType.WHITE_SPACE || SqlTokens.COMMENT_TOKENS.contains(type)) continue;
            if (type == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE) {
                PsiElement psiElement = node.getPsi();
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlUnaryExpressionImpl", "getOpSignElement"));
                }
                return psiElement;
            }
            if (type == SqlCompositeElementTypes.SQL_COLLATE_CLAUSE) {
                PsiElement psiElement = node.getPsi();
                if (psiElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlUnaryExpressionImpl", "getOpSignElement"));
                }
                return psiElement;
            }
            if (!(type instanceof SqlTokenType) || (element = node.getPsi()) instanceof SqlExpression) continue;
            PsiElement psiElement = element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlUnaryExpressionImpl", "getOpSignElement"));
            }
            return psiElement;
        }
        throw new AssertionError((Object)"no opsign found");
    }

    public SqlExpression getOperand() {
        return (SqlExpression)this.findChildByClass(SqlExpression.class);
    }
}

