/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.stubs.SqlStubbedTypedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTypedDefinitionStub;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlVariableDefinitionImpl
extends SqlStubbedTypedDefinitionImpl<SqlTypedDefinitionStub<? extends SqlVariableDefinition>>
implements SqlVariableDefinition,
SqlLocalDefinition {
    public SqlVariableDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlVariableDefinitionImpl", "<init>"));
        }
        super(node);
    }

    public SqlVariableDefinitionImpl(@NotNull SqlTypedDefinitionStub<SqlVariableDefinition> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/impl/SqlVariableDefinitionImpl", "<init>"));
        }
        super(stub, stub.getStubType());
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlVariableDefinition((SqlVariableDefinition)this);
    }

    @Override
    public SqlNameElement getNameElement() {
        SqlTypedDefinitionStub stub = (SqlTypedDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getNameReference(SqlCompositeElementTypes.SQL_REFERENCE);
        }
        return (SqlNameElement)this.findChildByClass(SqlNameElement.class);
    }

    @Override
    @Nullable
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return null;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = SqlDbElementType.VARIABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlVariableDefinitionImpl", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public PsiElement getDefinitionScope() {
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getContextOfType((PsiElement)this, SqlStatement.class, (boolean)true);
        return statement == null ? null : PsiTreeUtil.getContextOfType((PsiElement)statement, (Class[])new Class[]{SqlBatchBlock.class, SqlStatement.class});
    }

    @NotNull
    public SearchScope getUseScope() {
        PsiElement scope = this.getDefinitionScope();
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)(scope == null ? this.getContainingFile() : scope));
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlVariableDefinitionImpl", "getUseScope"));
        }
        return localSearchScope;
    }

    @Override
    @Nullable
    public SqlTypeElement getTypeElement() {
        SqlTypeElement element = super.getTypeElement();
        if (element == null && this.getStub() == null && this.getParent() instanceof SqlDeclareStatement) {
            return (SqlTypeElement)PsiTreeUtil.findChildOfType((PsiElement)this.getParent(), SqlTypeElement.class);
        }
        return element;
    }

    @Nullable
    public SqlExpression getInitializer() {
        SqlNameElement name = this.getNameElement();
        return (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)(name == null ? this.getFirstChild() : name), SqlExpression.class);
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Variable;
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlType type = super.getSqlType();
        if (type != SqlType.UNKNOWN) {
            SqlType sqlType = type;
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlVariableDefinitionImpl", "getSqlType"));
            }
            return sqlType;
        }
        SqlExpression initializer = this.getInitializer();
        SqlType sqlType = initializer != null ? initializer.getSqlType() : type;
        if (sqlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlVariableDefinitionImpl", "getSqlType"));
        }
        return sqlType;
    }

    @Override
    @NotNull
    public DataType getDataType() {
        SqlTypeElement te = this.getTypeElement();
        DataType dataType = te == null ? DataType.UNKNOWN : te.getDataType();
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlVariableDefinitionImpl", "getDataType"));
        }
        return dataType;
    }

    @Override
    @Nullable
    public String getDefault() {
        SqlExpression initializer = this.getInitializer();
        return initializer == null ? null : initializer.getText();
    }
}

