/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.stubs.SqlAllNameIndex;
import com.intellij.sql.psi.stubs.SqlStubElementType;
import com.intellij.sql.psi.stubs.SqlSynonymStub;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SqlSynonymDefinitionElementType<T extends SqlSynonymDefinition>
extends SqlStubElementType<SqlSynonymStub<T>, T> {
    public static final NotNullFunction<String, SqlSynonymDefinitionElementType> FACTORY = name -> new SqlSynonymDefinitionElementType((String)name);

    public static <T extends SqlSynonymDefinition> SqlSynonymDefinitionElementType<T> create(String debugName) {
        return new SqlSynonymDefinitionElementType<T>(debugName);
    }

    protected SqlSynonymDefinitionElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/sql/psi/stubs/SqlSynonymDefinitionElementType", "<init>"));
        }
        super(debugName);
    }

    @NotNull
    public SqlSynonymStub<T> createStub(@NotNull T psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/sql/psi/stubs/SqlSynonymDefinitionElementType", "createStub"));
        }
        SqlNameElement nameElement = psi.getNameElement();
        SqlReferenceExpression targetReference = psi.getTargetReference();
        if (targetReference != null && targetReference.getParent() != psi) {
            targetReference = null;
        }
        SqlSynonymStub sqlSynonymStub = new SqlSynonymStub(parentStub, this, SqlSynonymDefinitionElementType.asStringRef((PsiElement)nameElement), SqlSynonymDefinitionElementType.asStringRef((PsiElement)targetReference));
        if (sqlSynonymStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlSynonymDefinitionElementType", "createStub"));
        }
        return sqlSynonymStub;
    }

    @Override
    public void indexStub(@NotNull SqlSynonymStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlSynonymDefinitionElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/sql/psi/stubs/SqlSynonymDefinitionElementType", "indexStub"));
        }
        SqlSynonymDefinitionElementType.indexNamedStub(stub, SqlAllNameIndex.KEY, sink);
    }

    public void serialize(@NotNull SqlSynonymStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/sql/psi/stubs/SqlSynonymDefinitionElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlSynonymDefinitionElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getTargetName());
    }

    @NotNull
    public SqlSynonymStub<T> deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/sql/psi/stubs/SqlSynonymDefinitionElementType", "deserialize"));
        }
        SqlSynonymStub sqlSynonymStub = new SqlSynonymStub(parentStub, this, dataStream.readName(), dataStream.readName());
        if (sqlSynonymStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/stubs/SqlSynonymDefinitionElementType", "deserialize"));
        }
        return sqlSynonymStub;
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        SqlReferenceExpression targetRef;
        SqlSynonymDefinition definition = (SqlSynonymDefinition)ObjectUtils.tryCast((Object)node.getPsi(), SqlSynonymDefinition.class);
        SqlReferenceExpression sqlReferenceExpression = targetRef = definition == null ? null : definition.getTargetReference();
        if (targetRef != null && PsiTreeUtil.isContextAncestor((PsiElement)definition, (PsiElement)targetRef, (boolean)true)) {
            return true;
        }
        return node.getTreeParent().getElementType() instanceof IStubElementType;
    }
}

