/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import com.intellij.lang.aspectj.build.config.AjPathEntries;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaLibraryType;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public abstract class AjBuilderBase
extends ModuleLevelBuilder {
    public static final String ID = "ajc";
    public static final Logger LOG = Logger.getInstance(AjBuilderBase.class);
    private final String myClassToCheck;

    public AjBuilderBase(@NotNull BuilderCategory category, @NotNull String classToCheck) {
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/lang/aspectj/build/AjBuilderBase", "<init>"));
        }
        if (classToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToCheck", "com/intellij/lang/aspectj/build/AjBuilderBase", "<init>"));
        }
        super(category);
        this.myClassToCheck = classToCheck;
    }

    @NotNull
    public String getPresentableName() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/AjBuilderBase", "getPresentableName"));
        }
        return ID;
    }

    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> holder, @NotNull ModuleLevelBuilder.OutputConsumer consumer) throws ProjectBuildException, IOException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/aspectj/build/AjBuilderBase", "build"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/intellij/lang/aspectj/build/AjBuilderBase", "build"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/aspectj/build/AjBuilderBase", "build"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/aspectj/build/AjBuilderBase", "build"));
        }
        JpsProject project = context.getProjectDescriptor().getProject();
        String compilerId = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project).getJavaCompilerId();
        if (!ID.equals(compilerId)) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        AjCompilerSettings settings = AjJpsCompilerSettings.getSettings(project);
        if (settings == null) {
            String message = "Compiler settings component not initialized for " + project;
            LOG.error(message);
            context.processMessage(AjBuilderBase.error(message));
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        try {
            Class.forName(this.myClassToCheck);
        }
        catch (ClassNotFoundException e) {
            context.processMessage(AjBuilderBase.error(AjJpsBundle.message("aj.compiler.path.incorrect", settings.ajcPath)));
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        try {
            return this.doBuild(context, chunk, holder, consumer, settings);
        }
        catch (AjBuildException e) {
            context.processMessage(AjBuilderBase.error(e.getMessage()));
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
    }

    public abstract ModuleLevelBuilder.ExitCode doBuild(@NotNull CompileContext var1, @NotNull ModuleChunk var2, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> var3, @NotNull ModuleLevelBuilder.OutputConsumer var4, @NotNull AjCompilerSettings var5) throws ProjectBuildException, IOException, AjBuildException;

    @NotNull
    public static List<String> getAspectPath(@NotNull ModuleBuildTarget target, @Nullable AjModuleSettings moduleSettings) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/aspectj/build/AjBuilderBase", "getAspectPath"));
        }
        List paths = ContainerUtil.newSmartList();
        if (moduleSettings != null) {
            if (target.isTests()) {
                ContainerUtil.addIfNotNull((Collection)paths, (Object)AjBuilderBase.getModuleOutputPath(target.getModule()));
            }
            AjBuilderBase.addPaths(paths, moduleSettings.aspectPath);
        }
        List list = paths;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/AjBuilderBase", "getAspectPath"));
        }
        return list;
    }

    private static void addPaths(List<String> paths, List<AjPathEntries.Entry> entries) {
        for (AjPathEntries.Entry entry : entries) {
            JpsModule module;
            if (entry instanceof AjPathEntries.LibraryEntry) {
                JpsLibrary library = (JpsLibrary)((AjPathEntries.LibraryEntry)entry).resolve();
                if (library == null || !(library.getType() instanceof JpsJavaLibraryType)) continue;
                for (JpsLibraryRoot root : library.getRoots(JpsOrderRootType.COMPILED)) {
                    paths.add(JpsPathUtil.urlToOsPath((String)root.getUrl()));
                }
                continue;
            }
            if (!(entry instanceof AjPathEntries.ModuleEntry) || (module = (JpsModule)((AjPathEntries.ModuleEntry)entry).resolve()) == null || !(module.getModuleType() instanceof JpsJavaModuleType)) continue;
            ContainerUtil.addIfNotNull(paths, (Object)AjBuilderBase.getModuleOutputPath(module));
        }
    }

    private static String getModuleOutputPath(JpsModule module) {
        String outputUrl = JpsJavaExtensionService.getInstance().getOutputUrl(module, false);
        return outputUrl != null ? JpsPathUtil.urlToOsPath((String)outputUrl) : null;
    }

    @NotNull
    public static String getTargetDir(@NotNull ModuleBuildTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/aspectj/build/AjBuilderBase", "getTargetDir"));
        }
        File outputDir = target.getOutputDir();
        if (outputDir == null) {
            throw new AjBuildException("missing output dir for target '" + target + "'");
        }
        if (!outputDir.isDirectory() && !outputDir.mkdirs()) {
            throw new AjBuildException("unable to create output directory '" + outputDir + "'");
        }
        String string = outputDir.getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/AjBuilderBase", "getTargetDir"));
        }
        return string;
    }

    public static BuildMessage error(String text) {
        return new CompilerMessage(ID, BuildMessage.Kind.ERROR, text);
    }

    public static class AjBuildException
    extends RuntimeException {
        public AjBuildException(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/aspectj/build/AjBuilderBase$AjBuildException", "<init>"));
            }
            super(message);
        }
    }
}

