/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.modules.ModuleScriptData;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompilerKt$sam$Predicate$0b85b970;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.cli.jvm.plugins.PluginCliParser;
import org.jetbrains.kotlin.cli.jvm.repl.ReplFromTerminal;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CliOptionsKt;
import org.jetbrains.kotlin.compiler.plugin.PluginCliOptionProcessingException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProvider;
import org.jetbrains.kotlin.script.StandardScriptDefinition;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.KotlinPathsFromHomeDir;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\b\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "()V", "compileJavaFilesIfNeeded", "", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "arguments", "createArguments", "createCoreEnvironment", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "createEnvironmentWithScriptingSupport", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "executableScriptFileName", "", "registerJavacIfNeeded", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "Companion", "kotlin-compiler"})
public final class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    private static long initStartNanos;
    private static final HashMap<String, Long> elapsedGCTime;
    private static long elapsedJITTime;
    public static final Companion Companion;

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable) {
        List<Object> friendPaths;
        List<Object> list2;
        ExitCode exitCode;
        KotlinPaths kotlinPaths;
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(rootDisposable, "rootDisposable");
        MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        if (arguments2.kotlinHome != null) {
            kotlinPaths = new KotlinPathsFromHomeDir(new File(arguments2.kotlinHome));
        } else {
            KotlinPaths kotlinPaths2 = PathUtil.getKotlinPathsForCompiler();
            kotlinPaths = kotlinPaths2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinPaths2, "PathUtil.getKotlinPathsForCompiler()");
        }
        KotlinPaths paths = kotlinPaths;
        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.LOGGING, "Using Kotlin home directory " + paths.getHomePath(), null, 4, null);
        PerformanceCounter.Companion.setTimeCounterEnabled(arguments2.reportPerf);
        MessageCollector messageCollector3 = messageCollector2;
        Intrinsics.checkExpressionValueIsNotNull(messageCollector3, "messageCollector");
        ExitCode it = exitCode = K2JVMCompiler.Companion.setupJdkClasspathRoots(arguments2, configuration, messageCollector3);
        if (Intrinsics.areEqual((Object)it, (Object)ExitCode.OK) ^ true) {
            return it;
        }
        try {
            PluginCliParser.loadPlugins(arguments2, configuration);
        }
        catch (PluginCliOptionProcessingException e) {
            String message = e.getMessage() + "\n\n" + CliOptionsKt.cliPluginUsageString(e.getPluginId(), e.getOptions());
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, message, null, 4, null);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (CliOptionProcessingException e) {
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, string, null, 4, null);
            return ExitCode.INTERNAL_ERROR;
        }
        catch (Throwable t) {
            MessageCollectorUtil.reportException(messageCollector2, t);
            return ExitCode.INTERNAL_ERROR;
        }
        if (!arguments2.script && arguments2.buildFile == null) {
            for (String arg : arguments2.freeArgs) {
                File file = new File(arg);
                if (Intrinsics.areEqual(FilesKt.getExtension(file), "java")) {
                    JvmContentRootsKt.addJavaSourceRoot$default(configuration, file, null, 2, null);
                    continue;
                }
                String string = arg;
                Intrinsics.checkExpressionValueIsNotNull(string, "arg");
                ContentRootsKt.addKotlinSourceRoot(configuration, string);
                if (!file.isDirectory()) continue;
                JvmContentRootsKt.addJavaSourceRoot$default(configuration, file, null, 2, null);
            }
        }
        K2JVMCompiler.Companion.configureContentRoots(paths, arguments2, configuration);
        String string = arguments2.moduleName;
        if (string == null) {
            string = "main";
        }
        configuration.put(CommonConfigurationKeys.MODULE_NAME, string);
        if (arguments2.buildFile == null && arguments2.freeArgs.isEmpty() && !arguments2.version) {
            if (arguments2.script) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Specify script source path to evaluate", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            ReplFromTerminal.Companion.run(rootDisposable, configuration);
            return ExitCode.OK;
        }
        if (arguments2.includeRuntime) {
            configuration.put(JVMConfigurationKeys.INCLUDE_RUNTIME, true);
        }
        if (arguments2.friendPaths != null) {
            list2 = ArraysKt.toList((Object[])arguments2.friendPaths);
        } else {
            String[] cfr_ignored_0 = arguments2.friendPaths;
            list2 = friendPaths = null;
        }
        if (friendPaths != null) {
            configuration.put(JVMConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        if (arguments2.jvmTarget != null) {
            String string2 = arguments2.jvmTarget;
            Intrinsics.checkExpressionValueIsNotNull(string2, "arguments.jvmTarget");
            JvmTarget jvmTarget = JvmTarget.Companion.fromString(string2);
            if (jvmTarget != null) {
                configuration.put(JVMConfigurationKeys.JVM_TARGET, jvmTarget);
            } else {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unknown JVM target version: " + arguments2.jvmTarget + '\n' + "Supported versions: " + ArraysKt.joinToString$default(JvmTarget.values(), null, null, null, 0, null, (Function1)doExecute.2.INSTANCE, 31, null), null, 4, null);
            }
        }
        configuration.put(JVMConfigurationKeys.PARAMETERS_METADATA, arguments2.javaParameters);
        K2JVMCompiler.Companion.putAdvancedOptions(configuration, arguments2);
        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", null, 4, null);
        try {
            block41: {
                boolean bl;
                String destination;
                block42: {
                    KotlinCoreEnvironment environment2;
                    block44: {
                        block43: {
                            String sourcePath;
                            block40: {
                                boolean bl2;
                                destination = arguments2.destination;
                                if (arguments2.buildFile == null) break block40;
                                Function1 function1 = new Function1<CompilerMessageSeverity, Boolean>(CompilerMessageSeverity.VERBOSE){

                                    public final boolean invoke(CompilerMessageSeverity p1) {
                                        return ((EnumSet)this.receiver).contains((Object)((Object)p1));
                                    }

                                    public final KDeclarationContainer getOwner() {
                                        return Reflection.getOrCreateKotlinClass(EnumSet.class);
                                    }

                                    public final String getName() {
                                        return "contains";
                                    }

                                    public final String getSignature() {
                                        return "contains(Ljava/lang/Object;)Z";
                                    }
                                };
                                FilteringMessageCollector sanitizedCollector2 = new FilteringMessageCollector(messageCollector2, new K2JVMCompilerKt$sam$Predicate$0b85b970(function1));
                                ModuleScriptData moduleScript = CompileEnvironmentUtil.loadModuleDescriptions(arguments2.buildFile, sanitizedCollector2);
                                if (destination != null) {
                                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, "The '-d' option with a directory destination is ignored because '-Xbuild-file' is specified", null, 4, null);
                                }
                                File moduleFile = new File(arguments2.buildFile);
                                File directory = moduleFile.getAbsoluteFile().getParentFile();
                                List<Module> list3 = moduleScript.getModules();
                                Intrinsics.checkExpressionValueIsNotNull(list3, "moduleScript.modules");
                                File file = directory;
                                Intrinsics.checkExpressionValueIsNotNull(file, "directory");
                                KotlinToJVMBytecodeCompiler.INSTANCE.configureSourceRoots(configuration, list3, file);
                                configuration.put(JVMConfigurationKeys.MODULE_XML_FILE, moduleFile);
                                KotlinCoreEnvironment kotlinCoreEnvironment = this.createEnvironmentWithScriptingSupport(rootDisposable, configuration, arguments2, messageCollector2);
                                if (kotlinCoreEnvironment == null) {
                                    return ExitCode.COMPILATION_ERROR;
                                }
                                KotlinCoreEnvironment environment3 = kotlinCoreEnvironment;
                                boolean it2 = bl2 = this.registerJavacIfNeeded(environment3, arguments2);
                                if (!it2) {
                                    return ExitCode.COMPILATION_ERROR;
                                }
                                KotlinToJVMBytecodeCompiler.INSTANCE.compileModules(environment3, directory);
                                break block41;
                            }
                            if (!arguments2.script) break block42;
                            String string3 = sourcePath = (String)CollectionsKt.first(arguments2.freeArgs);
                            Intrinsics.checkExpressionValueIsNotNull(string3, "sourcePath");
                            ContentRootsKt.addKotlinSourceRoot(configuration, string3);
                            configuration.put(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, true);
                            KotlinCoreEnvironment kotlinCoreEnvironment = this.createEnvironmentWithScriptingSupport(rootDisposable, configuration, arguments2, messageCollector2);
                            if (kotlinCoreEnvironment == null) {
                                return ExitCode.COMPILATION_ERROR;
                            }
                            environment2 = kotlinCoreEnvironment;
                            KotlinScriptDefinitionProvider kotlinScriptDefinitionProvider = KotlinScriptDefinitionProvider.Companion.getInstance(environment2.getProject());
                            if (kotlinScriptDefinitionProvider == null) {
                                Intrinsics.throwNpe();
                            }
                            KotlinScriptDefinitionProvider scriptDefinitionProvider = kotlinScriptDefinitionProvider;
                            File scriptFile = new File(sourcePath);
                            if (scriptFile.isDirectory()) break block43;
                            String string4 = scriptFile.getName();
                            Intrinsics.checkExpressionValueIsNotNull(string4, "scriptFile.name");
                            if (scriptDefinitionProvider.isScript(string4)) break block44;
                        }
                        String extensionHint = Intrinsics.areEqual(configuration.get(JVMConfigurationKeys.SCRIPT_DEFINITIONS), CollectionsKt.listOf(StandardScriptDefinition.INSTANCE)) ? " (.kts)" : "";
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Specify path to the script file" + extensionHint + " as the first argument", null, 4, null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                    List<String> scriptArgs = arguments2.freeArgs.subList(1, arguments2.freeArgs.size());
                    return KotlinToJVMBytecodeCompiler.INSTANCE.compileAndExecuteScript$kotlin_compiler(environment2, scriptArgs);
                }
                if (destination != null) {
                    if (StringsKt.endsWith$default(destination, ".jar", false, 2, null)) {
                        configuration.put(JVMConfigurationKeys.OUTPUT_JAR, new File(destination));
                    } else {
                        configuration.put(JVMConfigurationKeys.OUTPUT_DIRECTORY, new File(destination));
                    }
                }
                KotlinCoreEnvironment kotlinCoreEnvironment = this.createEnvironmentWithScriptingSupport(rootDisposable, configuration, arguments2, messageCollector2);
                if (kotlinCoreEnvironment == null) {
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinCoreEnvironment environment4 = kotlinCoreEnvironment;
                boolean it3 = bl = this.registerJavacIfNeeded(environment4, arguments2);
                if (!it3) {
                    return ExitCode.COMPILATION_ERROR;
                }
                if (environment4.getSourceFiles().isEmpty()) {
                    if (arguments2.version) {
                        return ExitCode.OK;
                    }
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "No source files", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinToJVMBytecodeCompiler.INSTANCE.compileBunchOfSources(environment4);
                it3 = bl = this.compileJavaFilesIfNeeded(environment4, arguments2);
                if (!it3) {
                    return ExitCode.COMPILATION_ERROR;
                }
            }
            if (arguments2.reportPerf) {
                Companion.reportGCTime(configuration);
                Companion.reportCompilationTime(configuration);
                PerformanceCounter.Companion.report((Function1<? super String, Unit>)new Function1<String, Unit>(configuration){
                    final /* synthetic */ CompilerConfiguration $configuration;

                    public final void invoke(@NotNull String s) {
                        Intrinsics.checkParameterIsNotNull(s, "s");
                        K2JVMCompiler.Companion.reportPerf(this.$configuration, s);
                    }
                    {
                        this.$configuration = compilerConfiguration;
                        super(1);
                    }
                });
            }
            return ExitCode.OK;
        }
        catch (CompilationException e) {
            String string5 = OutputMessageUtil.renderException(e);
            Intrinsics.checkExpressionValueIsNotNull(string5, "OutputMessageUtil.renderException(e)");
            messageCollector2.report(CompilerMessageSeverity.EXCEPTION, string5, MessageUtil.psiElementToMessageLocation(e.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
    }

    private final boolean registerJavacIfNeeded(KotlinCoreEnvironment environment2, K2JVMCompilerArguments arguments2) {
        if (arguments2.useJavac) {
            environment2.getConfiguration().put(JVMConfigurationKeys.USE_JAVAC, true);
            return KotlinCoreEnvironment.registerJavac$default(environment2, null, null, arguments2.javacArguments, 3, null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean compileJavaFilesIfNeeded(KotlinCoreEnvironment environment2, K2JVMCompilerArguments arguments2) {
        block10: {
            Closeable closeable;
            boolean bl;
            if (!arguments2.useJavac) break block10;
            Closeable closeable2 = JavacWrapper.Companion.getInstance(environment2.getProject());
            boolean bl2 = false;
            try {
                JavacWrapper it = (JavacWrapper)closeable2;
                bl = JavacWrapper.compile$default(it, null, 1, null);
                closeable = closeable2;
            }
            catch (Exception exception) {
                try {
                    bl2 = true;
                    try {
                        Closeable closeable3 = closeable2;
                        if (closeable3 != null) {
                            closeable3.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw (Throwable)exception;
                }
                catch (Throwable throwable) {
                    if (!bl2) {
                        Closeable closeable4 = closeable2;
                        if (closeable4 != null) {
                            closeable4.close();
                        }
                    }
                    throw throwable;
                }
            }
            if (closeable != null) {
                closeable.close();
            }
            return bl;
        }
        return true;
    }

    private final KotlinCoreEnvironment createEnvironmentWithScriptingSupport(Disposable rootDisposable, CompilerConfiguration configuration, K2JVMCompilerArguments arguments2, MessageCollector messageCollector2) {
        HashMap<String, Object> hashMap = Companion.createScriptResolverEnvironment(arguments2, messageCollector2);
        if (hashMap == null) {
            return null;
        }
        HashMap<String, Object> scriptResolverEnv = hashMap;
        Companion.configureScriptDefinitions(arguments2.scriptTemplates, configuration, messageCollector2, scriptResolverEnv);
        if (!messageCollector2.hasErrors()) {
            KotlinCoreEnvironment environment2 = this.createCoreEnvironment(rootDisposable, configuration);
            if (!messageCollector2.hasErrors()) {
                Object object;
                Object object2 = environment2.getProject();
                String string = "projectRoot";
                HashMap<String, Object> hashMap2 = scriptResolverEnv;
                Object $receiver = object2;
                String string2 = $receiver.getBasePath();
                if (string2 == null) {
                    VirtualFile virtualFile2 = $receiver.getBaseDir();
                    string2 = virtualFile2 != null ? virtualFile2.getCanonicalPath() : null;
                }
                Object object3 = string2;
                HashMap<String, Object> hashMap3 = hashMap2;
                String string3 = string;
                String string4 = object3;
                if (string4 != null) {
                    object2 = string4;
                    string = string3;
                    hashMap2 = hashMap3;
                    Object p1 = object2;
                    object3 = new File((String)p1);
                    hashMap3 = hashMap2;
                    string3 = string;
                    object = object3;
                } else {
                    object = null;
                }
                hashMap3.put(string3, object);
                return environment2;
            }
        }
        return null;
    }

    private final KotlinCoreEnvironment createCoreEnvironment(Disposable rootDisposable, CompilerConfiguration configuration) {
        KotlinCoreEnvironment result2 = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
        if (K2JVMCompiler.Companion.getInitStartNanos() != 0L) {
            long initNanos = System.nanoTime() - K2JVMCompiler.Companion.getInitStartNanos();
            Companion.reportPerf(configuration, "INIT: Compiler initialized in " + TimeUnit.NANOSECONDS.toMillis(initNanos) + " ms");
            K2JVMCompiler.Companion.setInitStartNanos(0L);
        }
        return result2;
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JVMCompilerArguments arguments2, @NotNull Services services) {
        block1: {
            String[] stringArray;
            IncrementalCompilationComponents components;
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
            Intrinsics.checkParameterIsNotNull(services, "services");
            if (IncrementalCompilation.isEnabled() && (components = services.get(IncrementalCompilationComponents.class)) != null) {
                configuration.put(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS, components);
            }
            if (arguments2.additionalJavaModules == null) break block1;
            String[] additionalJavaModules = stringArray = arguments2.additionalJavaModules;
            configuration.addAll(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, (Collection)ArraysKt.toList((Object[])additionalJavaModules));
        }
    }

    @Override
    @NotNull
    public K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments k2JVMCompilerArguments;
        K2JVMCompilerArguments $receiver = k2JVMCompilerArguments = new K2JVMCompilerArguments();
        if (System.getenv("KOTLIN_REPORT_PERF") != null) {
            $receiver.reportPerf = true;
        }
        return k2JVMCompilerArguments;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc-jvm";
    }

    static {
        Companion = new Companion(null);
        initStartNanos = System.nanoTime();
        elapsedGCTime = new HashMap();
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JA\u0010\u001a\u001a\u00020\u00132\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\u0002\u0010 J&\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eJ\u001b\u0010\"\u001a\u00020\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cH\u0007\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010&\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010'\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010(\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u0005J\u0006\u0010*\u001a\u00020\u0013J \u0010+\u001a\u00020,2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R0\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler$Companion;", "", "()V", "elapsedGCTime", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getElapsedGCTime", "()Ljava/util/HashMap;", "elapsedJITTime", "getElapsedJITTime", "()J", "setElapsedJITTime", "(J)V", "initStartNanos", "getInitStartNanos", "setInitStartNanos", "configureContentRoots", "", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "configureScriptDefinitions", "scriptTemplates", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "scriptResolverEnv", "([Ljava/lang/String;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/HashMap;)V", "createScriptResolverEnvironment", "main", "args", "([Ljava/lang/String;)V", "putAdvancedOptions", "reportCompilationTime", "reportGCTime", "reportPerf", "message", "resetInitStartTime", "setupJdkClasspathRoots", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "kotlin-compiler"})
    public static final class Companion {
        private final long getInitStartNanos() {
            return initStartNanos;
        }

        private final void setInitStartNanos(long l) {
            initStartNanos = l;
        }

        private final HashMap<String, Long> getElapsedGCTime() {
            return elapsedGCTime;
        }

        private final long getElapsedJITTime() {
            return elapsedJITTime;
        }

        private final void setElapsedJITTime(long l) {
            elapsedJITTime = l;
        }

        public final void resetInitStartTime() {
            if (this.getInitStartNanos() == 0L) {
                this.setInitStartNanos(System.nanoTime());
            }
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull(args, "args");
            CLITool.Companion.doMain(new K2JVMCompiler(), args);
        }

        public final void reportPerf(@NotNull CompilerConfiguration configuration, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(message, "message");
            if (!configuration.getBoolean(CLIConfigurationKeys.REPORT_PERF)) {
                return;
            }
            MessageCollector.DefaultImpls.report$default(configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY), CompilerMessageSeverity.INFO, "PERF: " + message, null, 4, null);
        }

        public final void reportGCTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Iterable $receiver$iv = ManagementFactory.getGarbageCollectorMXBeans();
            for (Object element$iv : $receiver$iv) {
                String string;
                String string2;
                GarbageCollectorMXBean it = (GarbageCollectorMXBean)element$iv;
                long currentTime = it.getCollectionTime();
                Map map2 = Companion.getElapsedGCTime();
                Intrinsics.checkExpressionValueIsNotNull(it.getName(), "it.name");
                Object object = map2.get(string2);
                if (object == null) {
                    object = 0L;
                }
                long elapsedTime = ((Number)object).longValue();
                long time = currentTime - elapsedTime;
                Companion.reportPerf(configuration, "GC time for " + it.getName() + " is " + time + " ms");
                Map map3 = Companion.getElapsedGCTime();
                Intrinsics.checkExpressionValueIsNotNull(it.getName(), "it.name");
                Long l = currentTime;
                map3.put(string, l);
            }
        }

        public final void reportCompilationTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
            if (compilationMXBean == null) {
                return;
            }
            CompilationMXBean bean = compilationMXBean;
            long currentTime = bean.getTotalCompilationTime();
            this.reportPerf(configuration, "JIT time is " + (currentTime - this.getElapsedJITTime()) + " ms");
            this.setElapsedJITTime(currentTime);
        }

        private final void putAdvancedOptions(CompilerConfiguration configuration, K2JVMCompilerArguments arguments2) {
            block1: {
                String string;
                configuration.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments2.noCallAssertions);
                configuration.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments2.noParamAssertions);
                configuration.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments2.noOptimize);
                configuration.put(JVMConfigurationKeys.INHERIT_MULTIFILE_PARTS, arguments2.inheritMultifileParts);
                configuration.put(JVMConfigurationKeys.SKIP_RUNTIME_VERSION_CHECK, arguments2.skipRuntimeVersionCheck);
                configuration.put(JVMConfigurationKeys.USE_FAST_CLASS_FILES_READING, !arguments2.useOldClassFilesReading);
                if (arguments2.useOldClassFilesReading) {
                    MessageCollector.DefaultImpls.report$default(configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY), CompilerMessageSeverity.INFO, "Using the old java class files reading implementation", null, 4, null);
                }
                configuration.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.allowKotlinPackage);
                configuration.put(CLIConfigurationKeys.REPORT_PERF, arguments2.reportPerf);
                configuration.put(JVMConfigurationKeys.USE_SINGLE_MODULE, arguments2.singleModule);
                configuration.put(JVMConfigurationKeys.ADD_BUILT_INS_FROM_COMPILER_TO_DEPENDENCIES, arguments2.addCompilerBuiltIns);
                configuration.put(JVMConfigurationKeys.CREATE_BUILT_INS_FROM_MODULE_DEPENDENCIES, arguments2.loadBuiltInsFromDependencies);
                String string2 = arguments2.declarationsOutputPath;
                if (string2 == null) break block1;
                String it = string = string2;
                configuration.put(JVMConfigurationKeys.DECLARATIONS_JSON_PATH, it);
            }
        }

        private final void configureContentRoots(KotlinPaths paths, K2JVMCompilerArguments arguments2, CompilerConfiguration configuration) {
            String string = arguments2.classpath;
            List list2 = string != null ? StringsKt.split$default((CharSequence)string, new char[]{File.pathSeparatorChar}, false, 0, 6, null) : null;
            List list3 = list2;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            for (String path : list3) {
                configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(new File(path)));
            }
            String string2 = arguments2.javaModulePath;
            list2 = string2 != null ? StringsKt.split$default((CharSequence)string2, new char[]{File.pathSeparatorChar}, false, 0, 6, null) : null;
            List list4 = list2;
            if (list4 == null) {
                list4 = CollectionsKt.emptyList();
            }
            for (String modularRoot : list4) {
                configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(new File(modularRoot)));
            }
            File file = configuration.get(JVMConfigurationKeys.JDK_HOME);
            File it = file;
            boolean isModularJava = it != null && CoreJrtFileSystem.Companion.isModularJdk(it);
            Function2<String, File, Unit> addRoot$ = new Function2<String, File, Unit>(isModularJava, configuration){
                final /* synthetic */ boolean $isModularJava;
                final /* synthetic */ CompilerConfiguration $configuration;

                public final void invoke(@NotNull String moduleName, @NotNull File file) {
                    Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
                    Intrinsics.checkParameterIsNotNull(file, "file");
                    if (this.$isModularJava) {
                        this.$configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(file));
                        this.$configuration.add(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, moduleName);
                    } else {
                        this.$configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(file));
                    }
                }
                {
                    this.$isModularJava = bl;
                    this.$configuration = compilerConfiguration;
                    super(2);
                }
            };
            if (!arguments2.noStdlib) {
                File file2 = paths.getStdlibPath();
                Intrinsics.checkExpressionValueIsNotNull(file2, "paths.stdlibPath");
                addRoot$.invoke("kotlin.stdlib", file2);
                File file3 = paths.getScriptRuntimePath();
                Intrinsics.checkExpressionValueIsNotNull(file3, "paths.scriptRuntimePath");
                addRoot$.invoke("kotlin.script.runtime", file3);
            }
            if (!arguments2.noReflect && !arguments2.noStdlib) {
                File file4 = paths.getReflectPath();
                Intrinsics.checkExpressionValueIsNotNull(file4, "paths.reflectPath");
                addRoot$.invoke("kotlin.reflect", file4);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final ExitCode setupJdkClasspathRoots(K2JVMCompilerArguments arguments2, CompilerConfiguration configuration, MessageCollector messageCollector2) {
            try {
                void jdkHome;
                Pair<File, List<File>> pair;
                if (arguments2.noJdk) {
                    if (arguments2.jdkHome != null) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, "The '-jdk-home' option is ignored because '-no-jdk' is specified", null, 4, null);
                    }
                    return ExitCode.OK;
                }
                if (arguments2.jdkHome != null) {
                    File jdkHome2 = new File(arguments2.jdkHome);
                    if (!jdkHome2.exists()) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "JDK home directory does not exist: " + jdkHome2, null, 4, null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.LOGGING, "Using JDK home directory " + jdkHome2, null, 4, null);
                    pair = TuplesKt.to(jdkHome2, PathUtil.getJdkClassesRoots(jdkHome2));
                } else {
                    pair = TuplesKt.to(new File(System.getProperty("java.home")), PathUtil.getJdkClassesRootsFromCurrentJre());
                }
                Pair<File, List<File>> pair2 = pair;
                File file = pair2.component1();
                List<File> list2 = pair2.component2();
                pair2 = null;
                configuration.put(JVMConfigurationKeys.JDK_HOME, jdkHome);
                if (!CoreJrtFileSystem.Companion.isModularJdk((File)jdkHome)) {
                    void classesRoots;
                    void v1 = classesRoots;
                    Intrinsics.checkExpressionValueIsNotNull(v1, "classesRoots");
                    JvmContentRootsKt.addJvmClasspathRoots(configuration, (List<? extends File>)v1);
                    if (classesRoots.isEmpty()) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "No class roots are found in the JDK path: " + jdkHome, null, 4, null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                }
            }
            catch (Throwable t) {
                MessageCollectorUtil.reportException(messageCollector2, t);
                return ExitCode.INTERNAL_ERROR;
            }
            return ExitCode.OK;
        }

        /*
         * WARNING - void declaration
         */
        public final void configureScriptDefinitions(@Nullable String[] scriptTemplates, @NotNull CompilerConfiguration configuration, @NotNull MessageCollector messageCollector2, @NotNull HashMap<String, Object> scriptResolverEnv) {
            Object[] objectArray;
            Object object;
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(messageCollector2, "messageCollector");
            Intrinsics.checkParameterIsNotNull(scriptResolverEnv, "scriptResolverEnv");
            List<File> classpath = JvmContentRootsKt.getJvmClasspathRoots(configuration);
            if (scriptTemplates != null && !(((Object[])(object = (objectArray = (Object[])scriptTemplates))).length == 0)) {
                Collection<URL> collection;
                void $receiver$iv$iv;
                Collection $receiver$iv;
                URLClassLoader uRLClassLoader;
                object = classpath;
                URLClassLoader uRLClassLoader2 = uRLClassLoader;
                URLClassLoader uRLClassLoader3 = uRLClassLoader;
                void var8_11 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    URL uRL = it.toURI().toURL();
                    collection.add(uRL);
                }
                collection = (List)destination$iv$iv;
                Collection thisCollection$iv = $receiver$iv = (Collection)collection;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[thisCollection$iv.size()]);
                if (uRLArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                collection = uRLArray;
                uRLClassLoader2((URL[])collection, Thread.currentThread().getContextClassLoader());
                URLClassLoader classloader = uRLClassLoader3;
                boolean hasErrors = false;
                for (int i = 0; i < scriptTemplates.length; ++i) {
                    String template = scriptTemplates[i];
                    try {
                        Class<?> cls = classloader.loadClass(template);
                        KotlinScriptDefinitionFromAnnotatedTemplate def = new KotlinScriptDefinitionFromAnnotatedTemplate(JvmClassMappingKt.getKotlinClass(cls), null, null, scriptResolverEnv, null, 16, null);
                        configuration.add(JVMConfigurationKeys.SCRIPT_DEFINITIONS, def);
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Added script definition " + template + " to configuration: files pattern = \"" + def.getScriptFilePattern() + "\", " + "resolver = " + def.getDependencyResolver().getClass().getName(), null, 4, null);
                        continue;
                    }
                    catch (ClassNotFoundException ex) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Cannot find script definition template class " + template, null, 4, null);
                        hasErrors = true;
                        continue;
                    }
                    catch (Exception ex) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Error processing script definition template " + template + ": " + ex.getMessage(), null, 4, null);
                        hasErrors = true;
                        break;
                    }
                }
                if (hasErrors) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.LOGGING, "(Classpath used for templates loading: " + classpath + ')', null, 4, null);
                    return;
                }
            }
            configuration.add(JVMConfigurationKeys.SCRIPT_DEFINITIONS, StandardScriptDefinition.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final HashMap<String, Object> createScriptResolverEnvironment(@NotNull K2JVMCompilerArguments arguments2, @NotNull MessageCollector messageCollector2) {
            Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
            Intrinsics.checkParameterIsNotNull(messageCollector2, "messageCollector");
            HashMap<String, Object> scriptResolverEnv = new HashMap<String, Object>();
            String string = "(\\w+)=(?:\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\"|([^\\s]*))";
            Regex envParseRe = new Regex(string);
            String string2 = "\\\\([\"\\\\])";
            Regex unescapeRe = new Regex(string2);
            if (arguments2.scriptResolverEnvironment != null) {
                String[] stringArray = arguments2.scriptResolverEnvironment;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3;
                    String string4;
                    HashMap<String, Object> hashMap;
                    String string5;
                    Object object;
                    block6: {
                        void $receiver$iv;
                        String envParam;
                        String string6 = envParam = stringArray[i];
                        Intrinsics.checkExpressionValueIsNotNull(string6, "envParam");
                        MatchResult match2 = envParseRe.matchEntire(string6);
                        if (match2 == null || match2.getGroupValues().size() < 4 || StringsKt.isBlank(match2.getGroupValues().get(1))) {
                            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to parse script-resolver-environment argument " + envParam, null, 4, null);
                            return null;
                        }
                        object = CollectionsKt.drop((Iterable)match2.getGroupValues(), 2);
                        string5 = match2.getGroupValues().get(1);
                        hashMap = scriptResolverEnv;
                        for (Object element$iv : $receiver$iv) {
                            String it = (String)element$iv;
                            CharSequence charSequence = it;
                            if (!(charSequence.length() > 0)) continue;
                            string4 = (String)element$iv;
                            break block6;
                        }
                        string4 = null;
                    }
                    String string7 = string4;
                    HashMap<String, Object> hashMap2 = hashMap;
                    String string8 = string5;
                    String string9 = string7;
                    if (string9 != null) {
                        object = string9;
                        string5 = string8;
                        hashMap = hashMap2;
                        Object it = object;
                        string7 = unescapeRe.replace((CharSequence)it, "$1");
                        hashMap2 = hashMap;
                        string8 = string5;
                        string3 = string7;
                    } else {
                        string3 = null;
                    }
                    hashMap2.put(string8, string3);
                }
            }
            return scriptResolverEnv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

