/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.jboss.arquillian.configuration;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainer;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerBean;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerManual;
import com.intellij.plugins.jboss.arquillian.configuration.container.ArquillianContainerPredefined;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArquillianContainersAppManager {
    @NotNull
    private final ArquillianContainer manualContainer = new ArquillianContainerManual();
    @NotNull
    private final List<ArquillianContainer> manualContainers = Collections.singletonList(this.manualContainer);
    @NotNull
    private final List<ArquillianContainer> embeddedContainers;
    @NotNull
    private final List<ArquillianContainer> managedContainers;
    @NotNull
    private final List<ArquillianContainer> remoteContainers;
    private Map<String, ArquillianContainer> registeredContainers;

    public ArquillianContainersAppManager() {
        List<Object> extensions = Arrays.asList(ArquillianContainerBean.EP_NAME.getExtensions());
        Collections.sort(extensions, new Ordering<ArquillianContainerBean>(){

            public int compare(ArquillianContainerBean left, ArquillianContainerBean right) {
                return left.name.compareTo(right.name);
            }
        });
        List predefined = extensions.stream().map(ArquillianContainerPredefined::new).collect(Collectors.toList());
        this.embeddedContainers = predefined.stream().filter(c -> c.getScope() == ArquillianContainer.Scope.Embedded).collect(Collectors.toList());
        this.managedContainers = predefined.stream().filter(c -> c.getScope() == ArquillianContainer.Scope.Managed).collect(Collectors.toList());
        this.remoteContainers = predefined.stream().filter(c -> c.getScope() == ArquillianContainer.Scope.Remote).collect(Collectors.toList());
        this.registeredContainers = Maps.uniqueIndex((Iterable)Iterables.concat(this.manualContainers, this.embeddedContainers, this.managedContainers, this.remoteContainers), arquillianContainer -> arquillianContainer.getId());
    }

    public static ArquillianContainersAppManager getInstance() {
        return (ArquillianContainersAppManager)ServiceManager.getService(ArquillianContainersAppManager.class);
    }

    @NotNull
    public List<ArquillianContainer> getContainers(ArquillianContainer.Scope scope) {
        switch (scope) {
            default: {
                List<ArquillianContainer> list = this.manualContainers;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getContainers"));
                }
                return list;
            }
            case Embedded: {
                List<ArquillianContainer> list = this.embeddedContainers;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getContainers"));
                }
                return list;
            }
            case Managed: {
                List<ArquillianContainer> list = this.managedContainers;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getContainers"));
                }
                return list;
            }
            case Remote: 
        }
        List<ArquillianContainer> list = this.remoteContainers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getContainers"));
        }
        return list;
    }

    @NotNull
    public List<ArquillianContainer> getEmbeddedContainers() {
        List<ArquillianContainer> list = this.embeddedContainers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getEmbeddedContainers"));
        }
        return list;
    }

    @NotNull
    public List<ArquillianContainer> getManagedContainers() {
        List<ArquillianContainer> list = this.managedContainers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getManagedContainers"));
        }
        return list;
    }

    @NotNull
    public List<ArquillianContainer> getManualContainers() {
        List<ArquillianContainer> list = this.manualContainers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getManualContainers"));
        }
        return list;
    }

    @NotNull
    public List<ArquillianContainer> getRemoteContainers() {
        List<ArquillianContainer> list = this.remoteContainers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/jboss/arquillian/configuration/ArquillianContainersAppManager", "getRemoteContainers"));
        }
        return list;
    }

    @Nullable
    public ArquillianContainer findContainerById(String id) {
        ArquillianContainer container = this.registeredContainers.get(id);
        return container == null ? this.manualContainer : container;
    }
}

