/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.SmartDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SmartTypeRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.idea.highlighter.IdeRenderers;
import org.jetbrains.kotlin.idea.highlighter.renderersUtil.RenderersUtilKt;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.RenderingFormat;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.types.KotlinType;

public class HtmlTabledDescriptorRenderer
extends TabledDescriptorRenderer {
    private static final DescriptorRenderer.ValueParametersHandler VALUE_PARAMETERS_HANDLER = new DescriptorRenderer.ValueParametersHandler(){

        @Override
        public void appendBeforeValueParameter(@NotNull ValueParameterDescriptor parameter, int parameterIndex2, int parameterCount, @NotNull StringBuilder builder) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendBeforeValueParameter"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendBeforeValueParameter"));
            }
            builder.append("<td align=\"right\" style=\"white-space:nowrap;font-weight:bold;\">");
        }

        @Override
        public void appendAfterValueParameter(@NotNull ValueParameterDescriptor parameter, int parameterIndex2, int parameterCount, @NotNull StringBuilder builder) {
            boolean last;
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendAfterValueParameter"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendAfterValueParameter"));
            }
            boolean bl = last = parameterIndex2 == parameterCount - 1;
            if (!last) {
                builder.append(",");
            }
            builder.append("</td>");
        }

        @Override
        public void appendBeforeValueParameters(int parameterCount, @NotNull StringBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendBeforeValueParameters"));
            }
            builder.append("</td>");
            if (parameterCount == 0) {
                HtmlTabledDescriptorRenderer.tdBold(builder, "( )");
            } else {
                HtmlTabledDescriptorRenderer.tdBold(builder, "(");
            }
        }

        @Override
        public void appendAfterValueParameters(int parameterCount, @NotNull StringBuilder builder) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer$1", "appendAfterValueParameters"));
            }
            if (parameterCount != 0) {
                HtmlTabledDescriptorRenderer.tdBold(builder, ")");
            }
            builder.append("<td style=\"white-space:nowrap;font-weight:bold;\">");
        }
    };
    private static final DiagnosticParameterRenderer<DeclarationDescriptor> DESCRIPTOR_IN_TABLE = new SmartDescriptorRenderer(DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)new Function1<DescriptorRendererOptions, Unit>(){

        public Unit invoke(DescriptorRendererOptions options2) {
            options2.setWithDefinedIn(false);
            options2.setModifiers(Collections.emptySet());
            options2.setValueParametersHandler(VALUE_PARAMETERS_HANDLER);
            options2.setTextFormat(RenderingFormat.HTML);
            return Unit.INSTANCE;
        }
    }));

    @Override
    @NotNull
    public DiagnosticParameterRenderer<KotlinType> getTypeRenderer() {
        SmartTypeRenderer smartTypeRenderer = IdeRenderers.HTML_RENDER_TYPE;
        if (smartTypeRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer", "getTypeRenderer"));
        }
        return smartTypeRenderer;
    }

    @Override
    protected void renderText(TabledDescriptorRenderer.TextRenderer textRenderer, StringBuilder result2) {
        for (TabledDescriptorRenderer.TextRenderer.TextElement element2 : textRenderer.elements) {
            HtmlTabledDescriptorRenderer.renderText(result2, element2.type, element2.text);
        }
    }

    private static void renderText(StringBuilder result2, TabledDescriptorRenderer.TextElementType elementType, String text2) {
        if (elementType == TabledDescriptorRenderer.TextElementType.DEFAULT) {
            result2.append(text2);
        } else if (elementType == TabledDescriptorRenderer.TextElementType.ERROR) {
            result2.append(RenderersUtilKt.renderError(text2));
        } else if (elementType == TabledDescriptorRenderer.TextElementType.STRONG) {
            result2.append(RenderersUtilKt.renderStrong(text2));
        }
    }

    private static int countColumnNumber(TabledDescriptorRenderer.TableRenderer table) {
        int argumentsNumber = 0;
        for (TabledDescriptorRenderer.TableRenderer.TableRow row : table.rows) {
            int argumentTypesNumber;
            if (row instanceof TabledDescriptorRenderer.TableRenderer.DescriptorRow) {
                int valueParametersNumber = ((TabledDescriptorRenderer.TableRenderer.DescriptorRow)row).descriptor.getValueParameters().size();
                if (valueParametersNumber <= argumentsNumber) continue;
                argumentsNumber = valueParametersNumber;
                continue;
            }
            if (!(row instanceof TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow) || (argumentTypesNumber = ((TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow)row).argumentTypes.size()) <= argumentsNumber) continue;
            argumentsNumber = argumentTypesNumber;
        }
        return argumentsNumber + 6;
    }

    @Override
    protected void renderTable(TabledDescriptorRenderer.TableRenderer table, StringBuilder result2) {
        if (table.rows.isEmpty()) {
            return;
        }
        RenderingContext context = HtmlTabledDescriptorRenderer.computeRenderingContext(table);
        int rowsNumber = HtmlTabledDescriptorRenderer.countColumnNumber(table);
        result2.append("<table>");
        for (TabledDescriptorRenderer.TableRenderer.TableRow row : table.rows) {
            result2.append("<tr>");
            if (row instanceof TabledDescriptorRenderer.TextRenderer) {
                StringBuilder rowText = new StringBuilder();
                this.renderText((TabledDescriptorRenderer.TextRenderer)row, rowText);
                HtmlTabledDescriptorRenderer.tdColspan(result2, rowText.toString(), rowsNumber);
            }
            if (row instanceof TabledDescriptorRenderer.TableRenderer.DescriptorRow) {
                HtmlTabledDescriptorRenderer.tdSpace(result2);
                HtmlTabledDescriptorRenderer.tdRightBoldColspan(result2, 2, DESCRIPTOR_IN_TABLE.render(((TabledDescriptorRenderer.TableRenderer.DescriptorRow)row).descriptor, context));
            }
            if (row instanceof TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow) {
                TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow functionArgumentsRow = (TabledDescriptorRenderer.TableRenderer.FunctionArgumentsRow)row;
                this.renderFunctionArguments(functionArgumentsRow.receiverType, functionArgumentsRow.argumentTypes, functionArgumentsRow.isErrorPosition, result2, context);
            }
            result2.append("</tr>");
        }
        result2.append("</table>");
    }

    private void renderFunctionArguments(@Nullable KotlinType receiverType2, @NotNull List<KotlinType> argumentTypes2, Predicate<ConstraintPosition> isErrorPosition, StringBuilder result2, @NotNull RenderingContext context) {
        if (argumentTypes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer", "renderFunctionArguments"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/highlighter/HtmlTabledDescriptorRenderer", "renderFunctionArguments"));
        }
        boolean hasReceiver = receiverType2 != null;
        HtmlTabledDescriptorRenderer.tdSpace(result2);
        String receiver = "";
        if (hasReceiver) {
            boolean error = false;
            if (isErrorPosition.test(ConstraintPositionKind.RECEIVER_POSITION.position())) {
                error = true;
            }
            receiver = "receiver: " + RenderersUtilKt.renderStrong(this.getTypeRenderer().render(receiverType2, context), error);
        }
        HtmlTabledDescriptorRenderer.td(result2, receiver);
        HtmlTabledDescriptorRenderer.td(result2, hasReceiver ? "arguments: " : "");
        if (argumentTypes2.isEmpty()) {
            HtmlTabledDescriptorRenderer.tdBold(result2, "( )");
            return;
        }
        HtmlTabledDescriptorRenderer.td(result2, RenderersUtilKt.renderStrong("("));
        int i = 0;
        Iterator<KotlinType> iterator2 = argumentTypes2.iterator();
        while (iterator2.hasNext()) {
            KotlinType argumentType = iterator2.next();
            boolean error = false;
            if (isErrorPosition.test(ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(i))) {
                error = true;
            }
            String renderedArgument = argumentType == null ? "unknown" : this.getTypeRenderer().render(argumentType, context);
            HtmlTabledDescriptorRenderer.tdRight(result2, RenderersUtilKt.renderStrong(renderedArgument, error) + (iterator2.hasNext() ? RenderersUtilKt.renderStrong(",") : ""));
            ++i;
        }
        HtmlTabledDescriptorRenderer.td(result2, RenderersUtilKt.renderStrong(")"));
    }

    public static HtmlTabledDescriptorRenderer create() {
        return new HtmlTabledDescriptorRenderer();
    }

    protected HtmlTabledDescriptorRenderer() {
    }

    private static void td(StringBuilder builder, String text2) {
        builder.append("<td style=\"white-space:nowrap;\">").append(text2).append("</td>");
    }

    private static void tdSpace(StringBuilder builder) {
        builder.append("<td width=\"10%\"></td>");
    }

    private static void tdColspan(StringBuilder builder, String text2, int colspan) {
        builder.append("<td colspan=\"").append(colspan).append("\" style=\"white-space:nowrap;\">").append(text2).append("</td>");
    }

    private static void tdBold(StringBuilder builder, String text2) {
        builder.append("<td style=\"white-space:nowrap;font-weight:bold;\">").append(text2).append("</td>");
    }

    private static void tdRight(StringBuilder builder, String text2) {
        builder.append("<td align=\"right\" style=\"white-space:nowrap;\">").append(text2).append("</td>");
    }

    private static void tdRightBoldColspan(StringBuilder builder, int colspan, String text2) {
        builder.append("<td align=\"right\" colspan=\"").append(colspan).append("\" style=\"white-space:nowrap;font-weight:bold;\">").append(text2).append("</td>");
    }

    public static String tableForTypes(String message2, String firstDescription, TabledDescriptorRenderer.TextElementType firstType, String secondDescription, TabledDescriptorRenderer.TextElementType secondType) {
        StringBuilder result2 = new StringBuilder();
        result2.append("<html>").append(message2);
        result2.append("<table><tr><td>").append(firstDescription).append("</td><td>");
        HtmlTabledDescriptorRenderer.renderText(result2, firstType, "{0}");
        result2.append("</td></tr><tr><td>").append(secondDescription).append("</td><td>");
        HtmlTabledDescriptorRenderer.renderText(result2, secondType, "{1}");
        result2.append("</td></tr></table></html>");
        return result2.toString();
    }
}

