/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.UnusedReceiverParameterInspection;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.idea.util.ExtensionUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedReceiverParameterInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "suppressionKey", "", "getSuppressionKey", "()Ljava/lang/String;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "MyQuickFix", "idea"})
public final class UnusedReceiverParameterInspection
extends AbstractKotlinInspection {
    @Override
    @NotNull
    protected String getSuppressionKey() {
        return "unused";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            private final void check(KtCallableDeclaration callableDeclaration) {
                void used;
                KtTypeReference receiverTypeReference = callableDeclaration.getReceiverTypeReference();
                if (receiverTypeReference == null || receiverTypeReference.getTextRange().isEmpty()) {
                    return;
                }
                if (PsiModificationUtilsKt.isOverridable(callableDeclaration) || callableDeclaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                    return;
                }
                if (callableDeclaration instanceof KtProperty && ((KtProperty)callableDeclaration).getAccessors().isEmpty()) {
                    return;
                }
                if (callableDeclaration instanceof KtNamedFunction && !((KtNamedFunction)callableDeclaration).hasBody()) {
                    return;
                }
                DeclarationDescriptor callable2 = UtilsKt.getDescriptor(callableDeclaration);
                Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                booleanRef.element = false;
                callableDeclaration.acceptChildren(new KtVisitorVoid((Ref.BooleanRef)used, callable2){
                    final /* synthetic */ Ref.BooleanRef $used;
                    final /* synthetic */ DeclarationDescriptor $callable;

                    public void visitKtElement(@NotNull KtElement element2) {
                        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                        if (this.$used.element) {
                            return;
                        }
                        element2.acceptChildren(this);
                        BindingContext bindingContext2 = ResolutionUtils.analyze$default(element2, null, 1, null);
                        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(element2, bindingContext2);
                        if (resolvedCall2 == null) {
                            return;
                        }
                        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                        if (this.isUsageOfReceiver(resolvedCall3, bindingContext2)) {
                            this.$used.element = true;
                        } else if (resolvedCall3 instanceof VariableAsFunctionResolvedCall && this.isUsageOfReceiver(((VariableAsFunctionResolvedCall)((Object)resolvedCall3)).getVariableCall(), bindingContext2)) {
                            this.$used.element = true;
                        }
                    }

                    private final boolean isUsageOfReceiver(ResolvedCall<?> resolvedCall2, BindingContext bindingContext2) {
                        if (Intrinsics.areEqual((Object)ExtensionUtils.getThisReceiverOwner(resolvedCall2.getDispatchReceiver(), bindingContext2), (Object)this.$callable) || Intrinsics.areEqual((Object)ExtensionUtils.getThisReceiverOwner(resolvedCall2.getExtensionReceiver(), bindingContext2), (Object)this.$callable)) {
                            return true;
                        }
                        ? obj = resolvedCall2.getCandidateDescriptor();
                        if (!(obj instanceof ReceiverParameterDescriptor)) {
                            obj = null;
                        }
                        ReceiverParameterDescriptor receiverParameterDescriptor = (ReceiverParameterDescriptor)obj;
                        return Intrinsics.areEqual((Object)(receiverParameterDescriptor != null ? receiverParameterDescriptor.getContainingDeclaration() : null), (Object)this.$callable);
                    }
                    {
                        this.$used = $captured_local_variable$0;
                        this.$callable = $captured_local_variable$1;
                    }
                });
                if (!used.element) {
                    this.$holder.registerProblem((PsiElement)receiverTypeReference, KotlinBundle.message("unused.receiver.parameter", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyQuickFix(callableDeclaration)});
                }
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                this.check(function2);
            }

            public void visitProperty(@NotNull KtProperty property2) {
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                this.check(property2);
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00009\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u000e\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\r\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedReceiverParameterInspection$MyQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "configureChangeSignature", "org/jetbrains/kotlin/idea/inspections/UnusedReceiverParameterInspection$MyQuickFix$configureChangeSignature$1", "()Lorg/jetbrains/kotlin/idea/inspections/UnusedReceiverParameterInspection$MyQuickFix$configureChangeSignature$1;", "getFamilyName", "", "getName", "startInWriteAction", "", "idea"})
    private static final class MyQuickFix
    implements LocalQuickFix {
        @NotNull
        private final KtCallableDeclaration declaration;

        @NotNull
        public String getName() {
            String string = KotlinBundle.message("unused.receiver.parameter.remove", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinBundle.message(\"un\u2026ceiver.parameter.remove\")");
            return string;
        }

        private final configureChangeSignature.1 configureChangeSignature() {
            return new KotlinChangeSignatureConfiguration(){

                public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                    Intrinsics.checkParameterIsNotNull(affectedFunctions, (String)"affectedFunctions");
                    return true;
                }

                @NotNull
                public KotlinMethodDescriptor configure(@NotNull KotlinMethodDescriptor originalDescriptor) {
                    Intrinsics.checkParameterIsNotNull((Object)originalDescriptor, (String)"originalDescriptor");
                    return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)configureChangeSignature.configure.1.INSTANCE));
                }

                public boolean forcePerformForSelectedFunctionOnly() {
                    return KotlinChangeSignatureConfiguration.DefaultImpls.forcePerformForSelectedFunctionOnly(this);
                }
            };
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement element2 = descriptor2.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element2)) {
                return;
            }
            PsiElement psiElement2 = element2.getParent();
            if (!(psiElement2 instanceof KtCallableDeclaration)) {
                psiElement2 = null;
            }
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)psiElement2;
            if (ktCallableDeclaration == null) {
                return;
            }
            KtCallableDeclaration function2 = ktCallableDeclaration;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.analyze$default(function2, null, 1, null).get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
            if (!(declarationDescriptor instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
            if (callableDescriptor == null) {
                return;
            }
            CallableDescriptor callableDescriptor2 = callableDescriptor;
            KotlinChangeSignatureConfiguration kotlinChangeSignatureConfiguration = this.configureChangeSignature();
            PsiElement psiElement3 = element2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element");
            KotlinChangeSignatureKt.runChangeSignature(project, callableDescriptor2, kotlinChangeSignatureConfiguration, psiElement3, this.getName());
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public final KtCallableDeclaration getDeclaration() {
            return this.declaration;
        }

        public MyQuickFix(@NotNull KtCallableDeclaration declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            this.declaration = declaration2;
        }
    }
}

