/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/WhenByPlatformEnumChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "frontend.java"})
public final class WhenByPlatformEnumChecker
implements AdditionalTypeChecker {
    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)expressionType, (String)"expressionType");
        Intrinsics.checkParameterIsNotNull((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        if (expression2 instanceof KtWhenExpression && ((KtWhenExpression)expression2).getElseExpression() == null) {
            KtExpression ktExpression = ((KtWhenExpression)expression2).getSubjectExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression subjectExpression = ktExpression;
            KotlinType kotlinType = c.trace.getType(subjectExpression);
            if (kotlinType == null) {
                return;
            }
            KotlinType type2 = kotlinType;
            if (FlexibleTypesKt.isFlexible(type2) && TypeUtils.isNullableType(FlexibleTypesKt.asFlexibleType(type2).getUpperBound())) {
                DataFlowInfo dataFlowInfo;
                KtExpression ktExpression2 = subjectExpression;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"subjectExpression");
                KotlinType kotlinType2 = type2;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
                DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(ktExpression2, kotlinType2, c);
                KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)c.trace.get(BindingContext.EXPRESSION_TYPE_INFO, subjectExpression);
                DataFlowInfo dataFlowInfo2 = dataFlowInfo = kotlinTypeInfo != null ? kotlinTypeInfo.getDataFlowInfo() : null;
                if (dataFlowInfo != null && !dataFlowInfo.getStableNullability(dataFlowValue).canBeNull()) {
                    return;
                }
                ClassDescriptor classDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(type2);
                if (classDescriptor == null) {
                    return;
                }
                ClassDescriptor enumClassDescriptor = classDescriptor;
                BindingContext context = c.trace.getBindingContext();
                KtWhenExpression ktWhenExpression = (KtWhenExpression)expression2;
                BindingContext bindingContext2 = context;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context");
                if (WhenChecker.getEnumMissingCases(ktWhenExpression, bindingContext2, enumClassDescriptor).isEmpty() && !WhenChecker.INSTANCE.containsNullCase((KtWhenExpression)expression2, context)) {
                    BindingTrace bindingTrace = c.trace;
                    KtExpression ktExpression3 = ((KtWhenExpression)expression2).getSubjectExpression();
                    if (ktExpression3 == null) {
                        Intrinsics.throwNpe();
                    }
                    bindingTrace.report(ErrorsJvm.WHEN_ENUM_CAN_BE_NULL_IN_JAVA.on((KtExpression)((PsiElement)ktExpression3)));
                }
            }
        }
    }
}

