/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTrackerBase;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import org.jetbrains.annotations.NotNull;

public class ProjectDeploymentRevisionTracker
extends DeploymentRevisionTrackerBase {
    public ProjectDeploymentRevisionTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ProjectDeploymentRevisionTracker", "<init>"));
        }
        super(project, project.getName(), ProjectDeploymentRevisionTracker.getProjectPathForTracker(project));
    }

    private static String getProjectPathForTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ProjectDeploymentRevisionTracker", "getProjectPathForTracker"));
        }
        if (project.isDefault()) {
            throw new IllegalStateException("ProjectDeploymentRevisionTracker is non-default project service.");
        }
        String baseDir = project.getBasePath();
        if (baseDir == null) {
            throw new IllegalStateException("Non-default project with null base directory");
        }
        return baseDir;
    }

    @NotNull
    public static DeploymentRevisionTracker getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ProjectDeploymentRevisionTracker", "getInstance"));
        }
        DeploymentRevisionTracker deploymentRevisionTracker = (DeploymentRevisionTracker)ServiceManager.getService((Project)project, DeploymentRevisionTracker.class);
        if (deploymentRevisionTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ProjectDeploymentRevisionTracker", "getInstance"));
        }
        return deploymentRevisionTracker;
    }

    static class ProjectDeploymentRevisionTrackerStartupActivity
    implements StartupActivity {
        ProjectDeploymentRevisionTrackerStartupActivity() {
        }

        public void runActivity(final @NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ProjectDeploymentRevisionTracker$ProjectDeploymentRevisionTrackerStartupActivity", "runActivity"));
            }
            if (project.isDefault()) {
                return;
            }
            project.getMessageBus().connect().subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

                @Override
                public void optionsChanged() {
                    if (PublishConfig.getInstance(project).getPromptOnRemoteOverwrite() == PublishConfig.PromptOnRemoteOverwrite.NONE) {
                        ProjectDeploymentRevisionTracker tracker = (ProjectDeploymentRevisionTracker)ProjectDeploymentRevisionTracker.getInstance(project);
                        tracker.closeMap();
                        tracker.clearFiles();
                    }
                }
            });
        }
    }
}

