/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config.sockets;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.sockets.MyFtpServerSocketFactoryBase;
import com.jetbrains.plugins.webDeployment.config.sockets.MyFtpSocketFactoryBase;
import com.jetbrains.plugins.webDeployment.config.sockets.MyFtpsServerSocketFactoryWrapper;
import com.jetbrains.plugins.webDeployment.config.sockets.MyFtpsSocketFactoryWrapper;
import com.jetbrains.plugins.webDeployment.config.sockets.MySftpSocketFactory;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.net.SocketFactory;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.ServerSocketFactoryWrapper;
import org.apache.commons.vfs2.provider.ftps.SocketFactoryWrapper;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.net.util.IPAddressUtil;

public class DeploymentSocketUtils {
    private static final Logger LOG = Logger.getInstance(DeploymentSocketUtils.class);

    private DeploymentSocketUtils() {
    }

    public static void patchSftpSockets(@NotNull FileSystemOptions options, @NotNull FileTransferConfig ftc, @Nullable EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> disconnectTrigger) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/jetbrains/plugins/webDeployment/config/sockets/DeploymentSocketUtils", "patchSftpSockets"));
        }
        if (ftc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ftc", "com/jetbrains/plugins/webDeployment/config/sockets/DeploymentSocketUtils", "patchSftpSockets"));
        }
        if (disconnectTrigger != null || DeploymentSocketUtils.shouldPatchSocketsOnMacForIPv6(ftc)) {
            SftpFileSystemConfigBuilder.getInstance().setSocketFactory(options, (com.jcraft.jsch.SocketFactory)new MySftpSocketFactory(disconnectTrigger));
        }
    }

    public static void patchFtpSocketsIfNeeded(@NotNull FileSystemOptions options, @NotNull FileTransferConfig ftc, @Nullable EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> disconnectTrigger) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/jetbrains/plugins/webDeployment/config/sockets/DeploymentSocketUtils", "patchFtpSocketsIfNeeded"));
        }
        if (ftc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ftc", "com/jetbrains/plugins/webDeployment/config/sockets/DeploymentSocketUtils", "patchFtpSocketsIfNeeded"));
        }
        if (disconnectTrigger != null || DeploymentSocketUtils.shouldPatchSocketsOnMacForIPv6(ftc)) {
            FtpFileSystemConfigBuilder.getInstance().setSocketFactory(options, (SocketFactory)new MyFtpSocketFactoryBase(disconnectTrigger));
        }
        if (disconnectTrigger != null) {
            FtpFileSystemConfigBuilder.getInstance().setServerSocketFactory(options, MyFtpServerSocketFactoryBase.createInstance(disconnectTrigger));
        }
    }

    public static void patchFtpsSocketsIfNeeded(@NotNull FileSystemOptions options, @NotNull FileTransferConfig ftc, @Nullable EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> disconnectTrigger) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/jetbrains/plugins/webDeployment/config/sockets/DeploymentSocketUtils", "patchFtpsSocketsIfNeeded"));
        }
        if (ftc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ftc", "com/jetbrains/plugins/webDeployment/config/sockets/DeploymentSocketUtils", "patchFtpsSocketsIfNeeded"));
        }
        if (disconnectTrigger != null || DeploymentSocketUtils.shouldPatchSocketsOnMacForIPv6(ftc)) {
            MyFtpsSocketFactoryWrapper socketFactoryWrapper = new MyFtpsSocketFactoryWrapper(disconnectTrigger);
            FtpsFileSystemConfigBuilder.getInstance().setSocketFactoryWrapper(options, (SocketFactoryWrapper)socketFactoryWrapper);
            FtpFileSystemConfigBuilder.getInstance().setSocketFactory(options, SocketFactory.getDefault());
        }
        if (disconnectTrigger != null) {
            FtpsFileSystemConfigBuilder.getInstance().setServerSocketFactoryWrapper(options, (ServerSocketFactoryWrapper)new MyFtpsServerSocketFactoryWrapper(disconnectTrigger));
        }
    }

    public static boolean hasProperEqualsAndHash(Object value) {
        return value instanceof MySftpSocketFactory || value instanceof MyFtpSocketFactoryBase || value instanceof MyFtpServerSocketFactoryBase || value == SocketFactory.getDefault() || value instanceof MyFtpsSocketFactoryWrapper || value instanceof MyFtpsServerSocketFactoryWrapper;
    }

    private static boolean shouldPatchSocketsOnMacForIPv6(FileTransferConfig fileTransferConfig) {
        if (!SystemInfo.isMac) {
            return false;
        }
        try {
            boolean result;
            InetAddress address = InetAddress.getByName(fileTransferConfig.getHost());
            boolean bl = result = address instanceof Inet6Address && !StringUtil.isEmptyOrSpaces((String)DeploymentSocketUtils.getBannedInterfaces());
            if (result) {
                LOG.debug("Socket patching needed for " + fileTransferConfig.getHost());
            }
            return result;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    static InetAddress getProperAddressIfNeeded(@NotNull InetAddress inetAddress) throws SocketException, UnknownHostException {
        NetworkInterface networkInterface;
        if (inetAddress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inetAddress", "com/jetbrains/plugins/webDeployment/config/sockets/DeploymentSocketUtils", "getProperAddressIfNeeded"));
        }
        if (inetAddress instanceof Inet6Address && (networkInterface = DeploymentSocketUtils.findProperIpv6HostNetworkInterface()) != null) {
            return DeploymentSocketUtils.createAddressForInterface(networkInterface, inetAddress);
        }
        return null;
    }

    @Nullable
    private static NetworkInterface findProperIpv6HostNetworkInterface() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        String bannedInterfaces = DeploymentSocketUtils.getBannedInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (bannedInterfaces.contains(networkInterface.getName())) continue;
            if (!networkInterface.isUp()) {
                LOG.debug("Interface " + networkInterface + " is down ");
                continue;
            }
            for (InterfaceAddress address : networkInterface.getInterfaceAddresses()) {
                if (!(address.getAddress() instanceof Inet6Address)) continue;
                LOG.debug("Using interface " + networkInterface);
                return networkInterface;
            }
            LOG.debug("No ipv6 addresses for " + networkInterface);
        }
        return null;
    }

    @NotNull
    private static InetAddress createAddressForInterface(@NotNull NetworkInterface anInterface, InetAddress address) throws UnknownHostException {
        if (anInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anInterface", "com/jetbrains/plugins/webDeployment/config/sockets/DeploymentSocketUtils", "createAddressForInterface"));
        }
        Inet6Address inet6Address = Inet6Address.getByAddress(address.getHostAddress(), IPAddressUtil.textToNumericFormatV6(address.getHostAddress()), anInterface.getIndex());
        if (inet6Address == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/sockets/DeploymentSocketUtils", "createAddressForInterface"));
        }
        return inet6Address;
    }

    @NotNull
    private static String getBannedInterfaces() {
        String string = Registry.get((String)"deployment.macOs.bannedInterfaces").asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/sockets/DeploymentSocketUtils", "getBannedInterfaces"));
        }
        return string;
    }
}

