/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.plugins.webDeployment.connections.PatchedSftpFileSystem;
import java.util.Collection;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.HostFileNameParser;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PatchedSftpFileProvider
extends SftpFileProvider {
    public PatchedSftpFileProvider() {
        this.setFileNameParser((FileNameParser)new HostFileNameParser(22));
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        if (!Registry.is((String)"ide.ssh.one.time.password")) {
            return super.doCreateFileSystem(name, fileSystemOptions);
        }
        return new PatchedSftpFileSystem((GenericFileName)name, fileSystemOptions);
    }

    @Contract(pure=true)
    @NotNull
    public static Collection<Capability> getSftpCapabilities() {
        Collection collection = capabilities;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/connections/PatchedSftpFileProvider", "getSftpCapabilities"));
        }
        return collection;
    }
}

