/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.transport;

import com.intellij.openapi.diagnostic.Logger;
import com.jcraft.jsch.Session;
import com.jetbrains.plugins.webDeployment.transport.ChannelFactory;
import com.jetbrains.plugins.webDeployment.transport.SessionConfig;
import com.jetbrains.plugins.webDeployment.transport.SshChannel;
import com.jetbrains.plugins.webDeployment.transport.SshConnectionUtil;
import com.jetbrains.plugins.webDeployment.transport.SshConnectionUtilKt;
import com.jetbrains.plugins.webDeployment.transport.SshSession;
import com.jetbrains.plugins.webDeployment.transport.SshTransportException;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J\u0006\u0010\u0019\u001a\u00020\u0015J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J-\u0010\u001d\u001a\u0002H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!H\u0007\u00a2\u0006\u0002\u0010\"R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/jetbrains/plugins/webDeployment/transport/SshConnection;", "", "userName", "", "host", "port", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "closed", "", "getHost", "()Ljava/lang/String;", "lock", "Ljava/lang/Object;", "getPort", "()I", "sessions", "Ljava/util/ArrayList;", "Lcom/jetbrains/plugins/webDeployment/transport/SshSession;", "getUserName", "connect", "", "sessionConfig", "Lcom/jetbrains/plugins/webDeployment/transport/SessionConfig;", "createSession", "disconnect", "getSession", "Lcom/jcraft/jsch/Session;", "getSshSession", "openChannel", "R", "Lcom/jetbrains/plugins/webDeployment/transport/SshChannel;", "channelCreator", "Lcom/jetbrains/plugins/webDeployment/transport/ChannelFactory;", "(Lcom/jetbrains/plugins/webDeployment/transport/SessionConfig;Lcom/jetbrains/plugins/webDeployment/transport/ChannelFactory;)Lcom/jetbrains/plugins/webDeployment/transport/SshChannel;", "Companion", "webDeployment"})
public final class SshConnection {
    private final ArrayList<SshSession> sessions;
    private final Object lock;
    private boolean closed;
    @NotNull
    private final String userName;
    @NotNull
    private final String host;
    private final int port;
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final <R extends SshChannel> R openChannel(@NotNull SessionConfig sessionConfig, @NotNull ChannelFactory<? extends R> channelCreator) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkParameterIsNotNull(channelCreator, (String)"channelCreator");
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw (Throwable)new IllegalStateException("SSH connection is closed");
            }
            Iterator<SshSession> iterator = this.sessions.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    SshConnection.Companion.getLOG().debug("Failed to create SSH channel using existing SSH sessions, creating new SSH session");
                    SshSession sshSession = this.createSession(sessionConfig);
                    R r = sshSession.openChannel$webDeployment(channelCreator);
                    return r;
                }
                SshSession session = iterator.next();
                if (session.isConnected()) {
                    try {
                        R r = session.openChannel$webDeployment(channelCreator);
                        return r;
                    }
                    catch (SshTransportException e) {
                        if (SshConnection.Companion.isChannelIsNotOpenedCause(e)) continue;
                        throw (Throwable)new SshTransportException(e.getMessage(), e);
                    }
                }
                iterator.remove();
            }
        }
    }

    public final void connect(@NotNull SessionConfig sessionConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        this.getSession(sessionConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final SshSession getSshSession(@NotNull SessionConfig sessionConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        Object object = this.lock;
        synchronized (object) {
            Iterator<SshSession> iterator = this.sessions.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    SshConnection.Companion.getLOG().debug("No opened sessions to " + this.userName + '@' + this.host + ':' + this.port + " found");
                    return this.createSession(sessionConfig);
                }
                SshSession session = iterator.next();
                if (session.isConnected()) {
                    SshSession sshSession = session;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sshSession, (String)"session");
                    return sshSession;
                }
                iterator.remove();
            }
        }
    }

    @NotNull
    public final Session getSession(@NotNull SessionConfig sessionConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        return this.getSshSession(sessionConfig).getRawSession();
    }

    private final SshSession createSession(SessionConfig sessionConfig) throws SshTransportException {
        SshConnection.Companion.getLOG().debug("Establishing new SSH session to " + this.userName + '@' + this.host + ':' + this.port);
        Session rawSession = SshConnectionUtil.INSTANCE.createSession$webDeployment(sessionConfig);
        SshSession session = new SshSession(rawSession);
        SshConnection.Companion.getLOG().debug("SSH session " + SshConnectionUtilKt.id(session) + " (" + SshConnectionUtilKt.id(rawSession) + ") established to " + this.userName + '@' + this.host + ':' + this.port);
        this.sessions.add(session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                SshConnection.Companion.getLOG().debug("Disconnecting SSH sessions to " + this.userName + '@' + this.host + ':' + this.port);
                this.closed = true;
                for (SshSession session : this.sessions) {
                    session.disconnect();
                }
                this.sessions.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final String getUserName() {
        return this.userName;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public SshConnection(@NotNull String userName, @NotNull String host, int port) {
        Intrinsics.checkParameterIsNotNull((Object)userName, (String)"userName");
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        this.userName = userName;
        this.host = host;
        this.port = port;
        this.sessions = new ArrayList();
        this.lock = new Object();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(SshConnection.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(SshConnection::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugins/webDeployment/transport/SshConnection$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "isChannelIsNotOpenedCause", "", "e", "Lcom/jetbrains/plugins/webDeployment/transport/SshTransportException;", "webDeployment"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private final boolean isChannelIsNotOpenedCause(SshTransportException e) {
            String string = e.getMessage();
            return string != null && StringsKt.contains$default((CharSequence)string, (CharSequence)"channel is not opened.", (boolean)false, (int)2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

