/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.transport;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import com.jetbrains.plugins.webDeployment.transport.AuthAgentIdentityRepositoryFactory;
import com.jetbrains.plugins.webDeployment.transport.ChannelFactory;
import com.jetbrains.plugins.webDeployment.transport.ExecChannel;
import com.jetbrains.plugins.webDeployment.transport.ExecChannelConfig;
import com.jetbrains.plugins.webDeployment.transport.SessionConfig;
import com.jetbrains.plugins.webDeployment.transport.SftpChannel;
import com.jetbrains.plugins.webDeployment.transport.SftpChannelConfig;
import com.jetbrains.plugins.webDeployment.transport.ShellChannel;
import com.jetbrains.plugins.webDeployment.transport.ShellChannelConfig;
import com.jetbrains.plugins.webDeployment.transport.SshChannel;
import com.jetbrains.plugins.webDeployment.transport.SshConnection;
import com.jetbrains.plugins.webDeployment.transport.SshConnectionUtil;
import com.jetbrains.plugins.webDeployment.transport.SshSession;
import com.jetbrains.plugins.webDeployment.transport.SshSessionKey;
import com.jetbrains.plugins.webDeployment.transport.SshTransportException;
import com.jetbrains.plugins.webDeployment.transport.channels.ExecChannelImpl;
import com.jetbrains.plugins.webDeployment.transport.channels.SftpChannelImpl;
import com.jetbrains.plugins.webDeployment.transport.channels.ShellChannelImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u001a\u0010(\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\b\u0010)\u001a\u0004\u0018\u00010%H\u0002J-\u0010*\u001a\u0002H+\"\b\b\u0000\u0010+*\u00020,2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0.H\u0003\u00a2\u0006\u0002\u0010/J\u0018\u00100\u001a\u0002012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u000202H\u0007J\u0018\u00103\u001a\u0002042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u000205H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/jetbrains/plugins/webDeployment/transport/SshConnectionService;", "Lcom/intellij/openapi/Disposable;", "()V", "authAgentIdentityRepositoryFactory", "Lcom/jetbrains/plugins/webDeployment/transport/AuthAgentIdentityRepositoryFactory;", "getAuthAgentIdentityRepositoryFactory", "()Lcom/jetbrains/plugins/webDeployment/transport/AuthAgentIdentityRepositoryFactory;", "pool", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/plugins/webDeployment/transport/SshSessionKey;", "Lcom/jetbrains/plugins/webDeployment/transport/SshConnection;", "sshAgentProxyCreationFailed", "", "sshAgentProxyLock", "", "sshConnectionsGroup", "Lcom/intellij/notification/NotificationGroup;", "connect", "Lcom/jetbrains/plugins/webDeployment/transport/SshSession;", "sessionConfig", "Lcom/jetbrains/plugins/webDeployment/transport/SessionConfig;", "createRemoteIdentityRepository", "Lcom/jcraft/jsch/IdentityRepository;", "createSshAgentConnector", "Lcom/jcraft/jsch/agentproxy/Connector;", "dispose", "", "exec", "Lcom/jetbrains/plugins/webDeployment/transport/ExecChannel;", "channelConfig", "Lcom/jetbrains/plugins/webDeployment/transport/ExecChannelConfig;", "getIdentityRepositoryFactory", "Lorg/apache/commons/vfs2/provider/sftp/IdentityRepositoryFactory;", "data", "Lcom/intellij/remote/RemoteCredentials;", "logAgentProxyException", "authAgentName", "", "e", "Lcom/jcraft/jsch/agentproxy/AgentProxyException;", "notifyAgentProxyCreationFailure", "errorMessage", "openChannel", "R", "Lcom/jetbrains/plugins/webDeployment/transport/SshChannel;", "channelCreator", "Lcom/jetbrains/plugins/webDeployment/transport/ChannelFactory;", "(Lcom/jetbrains/plugins/webDeployment/transport/SessionConfig;Lcom/jetbrains/plugins/webDeployment/transport/ChannelFactory;)Lcom/jetbrains/plugins/webDeployment/transport/SshChannel;", "sftp", "Lcom/jetbrains/plugins/webDeployment/transport/SftpChannel;", "Lcom/jetbrains/plugins/webDeployment/transport/SftpChannelConfig;", "shell", "Lcom/jetbrains/plugins/webDeployment/transport/ShellChannel;", "Lcom/jetbrains/plugins/webDeployment/transport/ShellChannelConfig;", "Companion", "webDeployment"})
public final class SshConnectionService
implements Disposable {
    private final NotificationGroup sshConnectionsGroup;
    private final ConcurrentHashMap<SshSessionKey, SshConnection> pool;
    private final Object sshAgentProxyLock;
    private boolean sshAgentProxyCreationFailed;
    @NotNull
    private final AuthAgentIdentityRepositoryFactory authAgentIdentityRepositoryFactory;
    private static final Logger LOG;
    private static final String SSH_AUTH_SOCK = "SSH_AUTH_SOCK";
    public static final Companion Companion;

    public void dispose() {
        SshConnectionService.Companion.getLOG().debug("Disconnecting SSH connections on " + SshConnectionService.class + " dispose");
        Map map = this.pool;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            SshSessionKey key = (SshSessionKey)entry2.getKey();
            entry2 = entry;
            SshConnection value = (SshConnection)entry2.getValue();
            value.disconnect();
        }
        this.pool.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IdentityRepository createRemoteIdentityRepository() {
        Object object = this.sshAgentProxyLock;
        synchronized (object) {
            block4: {
                Connector sshAgentConnector;
                if (this.sshAgentProxyCreationFailed || (sshAgentConnector = this.createSshAgentConnector()) == null) break block4;
                IdentityRepository identityRepository = (IdentityRepository)new RemoteIdentityRepository(sshAgentConnector);
                return identityRepository;
            }
            IdentityRepository identityRepository = null;
            return identityRepository;
        }
    }

    @NotNull
    public final AuthAgentIdentityRepositoryFactory getAuthAgentIdentityRepositoryFactory() {
        return this.authAgentIdentityRepositoryFactory;
    }

    @Nullable
    public final IdentityRepositoryFactory getIdentityRepositoryFactory(@NotNull RemoteCredentials data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return Intrinsics.areEqual((Object)data.getAuthType(), (Object)AuthType.AUTH_AGENT) ? (IdentityRepositoryFactory)this.authAgentIdentityRepositoryFactory : null;
    }

    private final Connector createSshAgentConnector() {
        SshConnectionService.Companion.getLOG().debug("Creating authentication agent connector");
        if (SystemInfo.isWindows) {
            try {
                return (Connector)new PageantConnector();
            }
            catch (AgentProxyException e) {
                this.sshAgentProxyCreationFailed = true;
                this.logAgentProxyException("Pageant", e);
                this.notifyAgentProxyCreationFailure("Pageant", e.getMessage());
            }
        } else {
            String unixSocketPath = System.getenv(SshConnectionService.Companion.getSSH_AUTH_SOCK());
            CharSequence charSequence = unixSocketPath;
            if (charSequence == null || charSequence.length() == 0) {
                this.sshAgentProxyCreationFailed = true;
                SshConnectionService.Companion.getLOG().info("" + SshConnectionService.Companion.getSSH_AUTH_SOCK() + " environment variable is not defined");
                this.notifyAgentProxyCreationFailure("ssh-agent", "" + SshConnectionService.Companion.getSSH_AUTH_SOCK() + " environment variable is not defined");
                return null;
            }
            SshConnectionService.Companion.getLOG().debug("UNIX-domain socket " + unixSocketPath + " defined in environment variable " + SshConnectionService.Companion.getSSH_AUTH_SOCK() + " will be used to connect to " + "authentication agent");
            try {
                return (Connector)new SSHAgentConnector((USocketFactory)new JNAUSocketFactory(), unixSocketPath);
            }
            catch (AgentProxyException e) {
                this.sshAgentProxyCreationFailed = true;
                this.logAgentProxyException("ssh-agent", e);
                this.notifyAgentProxyCreationFailure("ssh-agent", e.getMessage());
            }
        }
        return null;
    }

    private final void logAgentProxyException(String authAgentName, AgentProxyException e) {
        if (SshConnectionService.Companion.getLOG().isDebugEnabled()) {
            SshConnectionService.Companion.getLOG().debug("Failed to create " + authAgentName + " proxy", (Throwable)e);
        } else {
            SshConnectionService.Companion.getLOG().info("Failed to create " + authAgentName + " proxy: " + (Object)((Object)e));
        }
    }

    private final void notifyAgentProxyCreationFailure(String authAgentName, String errorMessage) {
        String content = "<html><body>Unable to connect to " + authAgentName + ": " + errorMessage + ".<br>\n" + "Using " + authAgentName + " during SSH key-based authentication process disabled.";
        this.sshConnectionsGroup.createNotification("Authentication using " + authAgentName, content, NotificationType.WARNING, null).notify(null);
    }

    @NotNull
    public final SshSession connect(@NotNull SessionConfig sessionConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        SshSessionKey sessionKey = new SshSessionKey(sessionConfig);
        SshConnection sshConnection2 = this.pool.computeIfAbsent(sessionKey, new Function<SshSessionKey, SshConnection>(sessionKey){
            final /* synthetic */ SshSessionKey $sessionKey;

            @NotNull
            public final SshConnection apply(@NotNull SshSessionKey it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new SshConnection(this.$sessionKey.getUsername(), this.$sessionKey.getHost(), this.$sessionKey.getPort());
            }
            {
                this.$sessionKey = sshSessionKey;
            }
        });
        return sshConnection2.getSshSession(sessionConfig);
    }

    @NotNull
    public final ExecChannel exec(@NotNull SessionConfig sessionConfig, @NotNull ExecChannelConfig channelConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkParameterIsNotNull((Object)channelConfig, (String)"channelConfig");
        SshSessionKey sessionKey = new SshSessionKey(sessionConfig);
        SshConnection sshConnection2 = this.pool.computeIfAbsent(sessionKey, new Function<SshSessionKey, SshConnection>(sessionKey){
            final /* synthetic */ SshSessionKey $sessionKey;

            @NotNull
            public final SshConnection apply(@NotNull SshSessionKey it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new SshConnection(this.$sessionKey.getUsername(), this.$sessionKey.getHost(), this.$sessionKey.getPort());
            }
            {
                this.$sessionKey = sshSessionKey;
            }
        });
        return (ExecChannel)sshConnection2.openChannel(sessionConfig, (ChannelFactory)new ChannelFactory<ExecChannel>(channelConfig){
            final /* synthetic */ ExecChannelConfig $channelConfig;

            @NotNull
            public ExecChannel create(@NotNull SshSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                com.jetbrains.plugins.webDeployment.transport.SshConnectionService$Companion.access$getLOG$p(SshConnectionService.Companion).info("Executing SSH command: " + this.$channelConfig.getCommand() + " within " + session);
                Channel channel = session.getRawSession().openChannel(SshConnectionUtil.INSTANCE.getEXEC_CHANNEL_TYPE());
                if (channel == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jcraft.jsch.ChannelExec");
                }
                ChannelExec channel2 = (ChannelExec)channel;
                channel2.setPty(this.$channelConfig.isPty());
                channel2.setCommand(this.$channelConfig.getCommand());
                InputStream inputStream = null;
                OutputStream outputStream = null;
                InputStream errStream = null;
                if (this.$channelConfig.isAutoOpen()) {
                    inputStream = channel2.getInputStream();
                    outputStream = channel2.getOutputStream();
                    errStream = channel2.getErrStream();
                }
                channel2.connect(this.$channelConfig.getTimeoutInMillis());
                return new ExecChannelImpl(session, channel2, this.$channelConfig.isPty(), inputStream, outputStream, errStream);
            }
            {
                this.$channelConfig = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final SftpChannel sftp(@NotNull SessionConfig sessionConfig, @NotNull SftpChannelConfig channelConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkParameterIsNotNull((Object)channelConfig, (String)"channelConfig");
        SshSessionKey sessionKey = new SshSessionKey(sessionConfig);
        SshConnection sshConnection2 = this.pool.computeIfAbsent(sessionKey, new Function<SshSessionKey, SshConnection>(sessionKey){
            final /* synthetic */ SshSessionKey $sessionKey;

            @NotNull
            public final SshConnection apply(@NotNull SshSessionKey it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new SshConnection(this.$sessionKey.getUsername(), this.$sessionKey.getHost(), this.$sessionKey.getPort());
            }
            {
                this.$sessionKey = sshSessionKey;
            }
        });
        return (SftpChannel)sshConnection2.openChannel(sessionConfig, (ChannelFactory)new ChannelFactory<SftpChannel>(channelConfig){
            final /* synthetic */ SftpChannelConfig $channelConfig;

            @NotNull
            public SftpChannel create(@NotNull SshSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                com.jetbrains.plugins.webDeployment.transport.SshConnectionService$Companion.access$getLOG$p(SshConnectionService.Companion).info("Creating sftp channel within " + session);
                Channel channel = session.getRawSession().openChannel(SshConnectionUtil.INSTANCE.getSFTP_CHANNEL_TYPE());
                if (channel == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jcraft.jsch.ChannelSftp");
                }
                ChannelSftp channel2 = (ChannelSftp)channel;
                if (this.$channelConfig.getDecoratorClass() != null) {
                    try {
                        Object[] elements$iv;
                        Object[] objectArray = new Class[]{ChannelSftp.class};
                        GenericDeclaration genericDeclaration = this.$channelConfig.getDecoratorClass();
                        Object[] objectArray2 = elements$iv;
                        Class[] classArray = (Class[])objectArray2;
                        Constructor<?> c = ((Class)genericDeclaration).getConstructor(Arrays.copyOf(classArray, classArray.length));
                        elements$iv = new Object[]{channel2};
                        genericDeclaration = c;
                        objectArray2 = elements$iv;
                        T t = ((Constructor)genericDeclaration).newInstance(Arrays.copyOf(objectArray2, objectArray2.length));
                        if (t == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.jcraft.jsch.ChannelSftp");
                        }
                        channel2 = (ChannelSftp)t;
                    }
                    catch (Exception c) {
                        // empty catch block
                    }
                }
                InputStream inputStream = null;
                OutputStream outputStream = null;
                if (this.$channelConfig.isAutoOpen()) {
                    inputStream = channel2.getInputStream();
                    outputStream = channel2.getOutputStream();
                }
                channel2.connect(this.$channelConfig.getTimeoutInMillis());
                return new SftpChannelImpl(session, channel2, inputStream, outputStream);
            }
            {
                this.$channelConfig = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final ShellChannel shell(@NotNull SessionConfig sessionConfig, @NotNull ShellChannelConfig channelConfig) throws SshTransportException {
        Intrinsics.checkParameterIsNotNull((Object)sessionConfig, (String)"sessionConfig");
        Intrinsics.checkParameterIsNotNull((Object)channelConfig, (String)"channelConfig");
        return (ShellChannel)this.openChannel(sessionConfig, (ChannelFactory)new ChannelFactory<ShellChannel>(channelConfig){
            final /* synthetic */ ShellChannelConfig $channelConfig;

            @NotNull
            public ShellChannel create(@NotNull SshSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                com.jetbrains.plugins.webDeployment.transport.SshConnectionService$Companion.access$getLOG$p(SshConnectionService.Companion).info("Creating shell channel within " + session);
                Channel channel = session.getRawSession().openChannel(SshConnectionUtil.INSTANCE.getSHELL_CHANNEL_TYPE());
                if (channel == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jcraft.jsch.ChannelShell");
                }
                ChannelShell channel2 = (ChannelShell)channel;
                InputStream inputStream = null;
                OutputStream outputStream = null;
                channel2.setPty(this.$channelConfig.isPty());
                channel2.setPtyType("xterm-256color");
                channel2.setEnv("LANG", "en_US.UTF-8");
                if (this.$channelConfig.isAutoOpen()) {
                    inputStream = channel2.getInputStream();
                    outputStream = channel2.getOutputStream();
                }
                channel2.connect(this.$channelConfig.getTimeoutInMillis());
                return new ShellChannelImpl(session, channel2, inputStream, outputStream);
            }
            {
                this.$channelConfig = $captured_local_variable$0;
            }
        });
    }

    private final <R extends SshChannel> R openChannel(SessionConfig sessionConfig, ChannelFactory<? extends R> channelCreator) throws SshTransportException {
        SshSessionKey sessionKey = new SshSessionKey(sessionConfig);
        SshConnection sshConnection2 = this.pool.computeIfAbsent(sessionKey, new Function<SshSessionKey, SshConnection>(sessionKey){
            final /* synthetic */ SshSessionKey $sessionKey;

            @NotNull
            public final SshConnection apply(@NotNull SshSessionKey it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new SshConnection(this.$sessionKey.getUsername(), this.$sessionKey.getHost(), this.$sessionKey.getPort());
            }
            {
                this.$sessionKey = sshSessionKey;
            }
        });
        return sshConnection2.openChannel(sessionConfig, channelCreator);
    }

    public SshConnectionService() {
        NotificationGroup notificationGroup = NotificationGroup.balloonGroup((String)"SSH Connections");
        Intrinsics.checkExpressionValueIsNotNull((Object)notificationGroup, (String)"NotificationGroup.balloonGroup(\"SSH Connections\")");
        this.sshConnectionsGroup = notificationGroup;
        this.pool = new ConcurrentHashMap();
        this.sshAgentProxyLock = new Object();
        this.authAgentIdentityRepositoryFactory = new AuthAgentIdentityRepositoryFactory();
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(SshConnectionService.class);
        SSH_AUTH_SOCK = SSH_AUTH_SOCK;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/plugins/webDeployment/transport/SshConnectionService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "SSH_AUTH_SOCK", "", "getSSH_AUTH_SOCK", "()Ljava/lang/String;", "instance", "Lcom/jetbrains/plugins/webDeployment/transport/SshConnectionService;", "getInstance", "()Lcom/jetbrains/plugins/webDeployment/transport/SshConnectionService;", "webDeployment"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private final String getSSH_AUTH_SOCK() {
            return SSH_AUTH_SOCK;
        }

        @NotNull
        public final SshConnectionService getInstance() {
            Object object = ServiceManager.getService(SshConnectionService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026ctionService::class.java)");
            return (SshConnectionService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

