/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PlatformIcons;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.WebServerConfigForm;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AddServerForm {
    private static final Dimension PREFERRED_DESCRIPTION_LABEL_SIZE;
    private JLabel myIconLabel;
    private JTextField myNameField;
    private ComboBox<AccessType> myAccessTypeCombo;
    private JPanel myContentPane;
    private MultiLineLabel myAccessTypeDescriptionLabel;
    private JLabel myUpDownHint;
    private final EventDispatcher<Listener> myEventDispatcher;
    private final boolean myGlobalServersOnly;

    public AddServerForm(boolean remoteServersOnly, boolean globalServersOnly) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myGlobalServersOnly = globalServersOnly;
        this.myIconLabel.setIcon(Messages.getQuestionIcon());
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((Listener)AddServerForm.this.myEventDispatcher.getMulticaster()).nameChanged();
            }
        });
        ArrayList<AccessType> types = new ArrayList<AccessType>();
        for (AccessType type : AccessType.values()) {
            if (!PublishUtils.needsTransfer(type) && remoteServersOnly) continue;
            types.add(type);
        }
        this.myAccessTypeCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(types, types.get(0)));
        this.myAccessTypeCombo.setRenderer((ListCellRenderer)((Object)new WebServerConfigForm.AccessTypeComboRenderer()));
        this.myAccessTypeDescriptionLabel.setText(((AccessType)((Object)this.myAccessTypeCombo.getSelectedItem())).getDescription());
        this.myAccessTypeDescriptionLabel.setPreferredSize(PREFERRED_DESCRIPTION_LABEL_SIZE);
        this.myAccessTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddServerForm.this.myAccessTypeDescriptionLabel.setText(((AccessType)((Object)AddServerForm.this.myAccessTypeCombo.getSelectedItem())).getDescription());
            }
        });
        this.myUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.registerUpDownHint();
    }

    private void registerUpDownHint() {
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                if (e.getInputEvent() instanceof KeyEvent) {
                    int code = ((KeyEvent)e.getInputEvent()).getKeyCode();
                    this.scrollBy(code == 40 ? 1 : (code == 38 ? -1 : 0));
                }
            }

            private void scrollBy(int delta) {
                if (delta == 0) {
                    return;
                }
                int size = AddServerForm.this.myAccessTypeCombo.getModel().getSize();
                int next = AddServerForm.this.myAccessTypeCombo.getSelectedIndex() + delta;
                if (next < 0 || next >= size) {
                    if (!UISettings.getInstance().getCycleScrolling()) {
                        return;
                    }
                    next = (next + size) % size;
                }
                AddServerForm.this.myAccessTypeCombo.setSelectedIndex(next);
                AddServerForm.this.myAccessTypeCombo.repaint();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{38, 40}), (JComponent)this.myNameField);
    }

    public void addListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public String getName() {
        return this.myNameField.getText();
    }

    private AccessType getAccessType() {
        return (AccessType)((Object)this.myAccessTypeCombo.getSelectedItem());
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    public WebServerConfig getResult() {
        WebServerConfig result = new WebServerConfig(WebServerConfig.getNextId());
        result.initializeNewCreatedServer(this.myGlobalServersOnly);
        result.setName(this.getName());
        result.getFileTransferConfig().setAccessType(this.getAccessType());
        result.getFileTransferConfig().setPort(this.getAccessType().getDefaultPort());
        return result;
    }

    static {
        double preferredWidth = 0.0;
        double preferredHeight = 0.0;
        MultiLineLabel label = new MultiLineLabel();
        for (AccessType accessType : AccessType.values()) {
            label.setText(accessType.getDescription());
            Dimension dimension = label.getPreferredSize();
            preferredWidth = Math.max(preferredWidth, dimension.getWidth());
            preferredHeight = Math.max(preferredHeight, dimension.getHeight());
        }
        PREFERRED_DESCRIPTION_LABEL_SIZE = new Dimension();
        PREFERRED_DESCRIPTION_LABEL_SIZE.setSize(preferredWidth, preferredHeight);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        MultiLineLabel multiLineLabel;
        ComboBox comboBox;
        JTextField jTextField;
        JLabel jLabel2;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Name:");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myIconLabel = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 3, 1, 9, 0, 0, 0, null, null, null));
        this.myNameField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Type:");
        jLabel4.setDisplayedMnemonic('T');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAccessTypeCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(3, 1, 1, 2, 0, 1, 0, 2, null, new Dimension(150, -1), null));
        this.myAccessTypeDescriptionLabel = multiLineLabel = new MultiLineLabel();
        multiLineLabel.setVerticalTextPosition(1);
        multiLineLabel.setText("Description");
        multiLineLabel.setVerticalAlignment(1);
        multiLineLabel.setForeground(SystemColor.textInactiveText);
        jPanel.add((Component)multiLineLabel, new GridConstraints(4, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myUpDownHint = jLabel = new JLabel();
        jLabel.setToolTipText("Pressing Up or Down arrows while in editor changes the type");
        jPanel.add((Component)jLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel3.setLabelFor(jTextField);
        jLabel4.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static interface Listener
    extends EventListener {
        public void nameChanged();
    }
}

